<?php
namespace MascotCoreErecoElementor\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

use MASCOTCOREERECO\Lib;
use MASCOTCOREERECO\CPT\Clients\CPT_Clients;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Hello World
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class TM_Elementor_Clients extends Widget_Base {

  /**
   * Retrieve the widget name.
   *
   * @since 1.0.0
   *
   * @access public
   *
   * @return string Widget name.
   */
  public function get_name() {
    return 'tm-ele-cpt-clients';
  }

  /**
   * Retrieve the widget title.
   *
   * @since 1.0.0
   *
   * @access public
   *
   * @return string Widget title.
   */
  public function get_title() {
    return esc_html__( 'Clients', 'mascot-core-elementor' );
  }

  /**
   * Retrieve the widget icon.
   *
   * @since 1.0.0
   *
   * @access public
   *
   * @return string Widget icon.
   */
  public function get_icon() {
    return 'tm-elementor-widget-icon';
  }

  /**
   * Retrieve the list of categories the widget belongs to.
   *
   * Used to determine where to display the widget in the editor.
   *
   * Note that currently Elementor supports only one category.
   * When multiple categories passed, Elementor uses the first one.
   *
   * @since 1.0.0
   *
   * @access public
   *
   * @return array Widget categories.
   */
  public function get_categories() {
    return [ 'tm' ];
  }

  /**
   * Retrieve the list of scripts the widget depended on.
   *
   * Used to set scripts dependencies required to run the widget.
   *
   * @since 1.0.0
   *
   * @access public
   *
   * @return array Widget scripts dependencies.
   */
  public function get_script_depends() {
    return [ 'mascot-core-hellojs' ];
  }

  /**
   * Register the widget controls.
   *
   * Adds different input fields to allow the user to change and customize the widget settings.
   *
   * @since 1.0.0
   *
   * @access protected
   */
  protected function _register_controls() {
    $new_cpt_class = CPT_Clients::Instance();
    $categories_array = ereco_mascot_category_list_array_for_vc( $new_cpt_class->ptTaxKey );
    $orderby_parameters_list = mascot_core_ereco_orderby_parameters_list();

    $this->start_controls_section(
      'general',
      [
        'label' => esc_html__( 'General', 'mascot-core-elementor' ),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'custom_css_class',
      [
        'label' => esc_html__( "Custom CSS class", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::TEXT,
      ]
    );
    $this->add_control(
      'display_type',
      [
        'label' => esc_html__( "Display Type", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => [
          'grid' => esc_html__( 'Grid', 'mascot-core-elementor' ),
          'carousel' => esc_html__( 'Carousel', 'mascot-core-elementor' ),
        ],
        'default' => 'grid'
      ]
    );
    $this->add_control(
      'columns',
      [
        'label' => esc_html__( "Number of visible items", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'description' => esc_html__( 'Select number of items to visible.', 'mascot-core-elementor' ),
        'options' => [
          '2'  =>  '2',
          '3'  =>  '3',
          '4'  =>  '4',
          '5'  =>  '5',
          '6'  =>  '6',
          '7'  =>  '7',
          '8'  =>  '8',
          '9'  =>  '9',
        ],
        'condition' => [
          'display_type' => array('carousel')
        ],
        'default' => '6'
      ]
    );
    $this->add_control(
      'columns_grid',
      [
        'label' => esc_html__( "Columns Layout", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'description' => esc_html__( 'Define Columns Layout for Grid/Carousel.', 'mascot-core-elementor' ),
        'options' => [
          '2'  =>  '2',
          '3'  =>  '3',
          '4'  =>  '4',
          '5'  =>  '5',
          '6'  =>  '6',
          '7'  =>  '7',
          '8'  =>  '8',
          '9'  =>  '9',
        ],
        'condition' => [
          'display_type' => array('grid')
        ],
        'default' => '6'
      ]
    );
    $this->add_control(
      'hover_animation_type',
      [
        'label' => esc_html__( "Hover Animation Type", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => [
          'clients-animation-no-effect' =>  esc_html__( 'No Effect', 'mascot-core-elementor' ),
          'clients-animation-grayscale' =>  esc_html__( 'Grayscale Effect', 'mascot-core-elementor' ),
          'clients-animation-opacity' =>  esc_html__( 'Opacity Effect', 'mascot-core-elementor' ),
          'clients-animation-blur'  =>  esc_html__( 'Blur Effect', 'mascot-core-elementor' ),
          'clients-animation-zoom'  =>  esc_html__( 'Zoom Effect', 'mascot-core-elementor' ),
          'clients-animation-contrast'  =>  esc_html__( 'Contrast Effect', 'mascot-core-elementor' ),
          'clients-animation-invert'  =>  esc_html__( 'Invert Effect', 'mascot-core-elementor' ),
        ],
        'default' => 'clients-animation-grayscale'
      ]
    );
    $this->add_control(
      'rollover_effect',
      [
        'label' => esc_html__( "Make Roll Over Effect", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'default' => 'no'
      ]
    );
    $this->add_control(
      'logo_filter_options',
      [
        'label' => esc_html__( 'Filter Options', 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::HEADING,
      ]
    );
    $this->add_control(
      'logo_filter_white',
      [
        'label' => esc_html__( 'Filter Logo to White', 'mascot-core-elementor' ),
        'type' => Controls_Manager::SWITCHER,
        'selectors' => [
          '{{WRAPPER}} .tm-sc-clients .client-thumb' => 'filter:brightness(0) invert(1);',
        ],
      ]
    );
    $this->add_control(
      'logo_filter_white_hover',
      [
        'label' => esc_html__( 'Filter Logo to White (Hover)', 'mascot-core-elementor' ),
        'type' => Controls_Manager::SWITCHER,
        'selectors' => [
          '{{WRAPPER}} .tm-sc-clients img:hover' => 'filter:brightness(0) invert(1);',
        ],
      ]
    );
    $this->add_control(
      'logo_filter_black',
      [
        'label' => esc_html__( 'Filter Logo to Black', 'mascot-core-elementor' ),
        'type' => Controls_Manager::SWITCHER,
        'selectors' => [
          '{{WRAPPER}} .tm-sc-clients .client-thumb' => 'filter:brightness(0) invert(0);',
        ],
      ]
    );
    $this->add_control(
      'logo_filter_black_hover',
      [
        'label' => esc_html__( 'Filter Logo to Black (Hover)', 'mascot-core-elementor' ),
        'type' => Controls_Manager::SWITCHER,
        'selectors' => [
          '{{WRAPPER}} .tm-sc-clients img:hover' => 'filter:brightness(0) invert(0);',
        ],
      ]
    );
    $this->add_control(
      'logo_opacity_options',
      [
        'label' => esc_html__( 'Opacity Options', 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::HEADING,
      ]
    );
    $this->add_control(
      'opacity',
      [
        'label' => esc_html__( 'Opacity', 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'description' => esc_html__( 'Value should be any floating value between 0 to 1. Example: 0.7', 'mascot-core-elementor' ),
        'selectors' => [
          '{{WRAPPER}} .tm-sc-clients .client-thumb' => 'opacity: {{VALUE}};'
        ]
      ]
    );

    $this->add_control(
      'hover_opacity',
      [
        'label' => esc_html__( 'Opacity (Hover)', 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => '1',
        'description' => esc_html__( 'Value should be any floating value between 0 to 1. Example: 0.7', 'mascot-core-elementor' ),
        'selectors' => [
          '{{WRAPPER}} .tm-sc-clients .client-thumb:hover, {{WRAPPER}} .tm-sc-clients .client-thumb-hover:hover' => 'opacity: {{VALUE}};'
        ]
      ]
    );

    $this->end_controls_section();





    //Carousel Options
    $this->start_controls_section(
      'carousel_options', [
        'label' => esc_html__( 'Carousel Options', 'mascot-core-elementor' ),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
          'display_type' => array('carousel')
        ]
      ]
    );
    mascot_core_ereco_elementor_get_owl_carousel_arraylist( $this, 1, '', array('display_type' => array('carousel') ) );
    mascot_core_ereco_elementor_get_owl_carousel_arraylist( $this, 2, '', array('display_type' => array('carousel') ) );
    mascot_core_ereco_elementor_get_owl_carousel_arraylist( $this, 3, '', array('display_type' => array('carousel') ) );
    mascot_core_ereco_elementor_get_owl_carousel_arraylist( $this, 4, '', array('display_type' => array('carousel') ) );
    mascot_core_ereco_elementor_get_owl_carousel_arraylist( $this, 5, '', array('display_type' => array('carousel') ) );
    mascot_core_ereco_elementor_get_owl_carousel_arraylist( $this, 6, '', array('display_type' => array('carousel') ) );
    mascot_core_ereco_elementor_get_owl_carousel_arraylist( $this, 7, '', array('display_type' => array('carousel') ) );
    mascot_core_ereco_elementor_get_owl_carousel_arraylist( $this, 8, '', array('display_type' => array('carousel') ) );
    mascot_core_ereco_elementor_get_owl_carousel_arraylist( $this, 9, '', array('display_type' => array('carousel') ) );
    mascot_core_ereco_elementor_get_owl_carousel_arraylist( $this, 10, '', array('display_type' => array('carousel') ) );
    mascot_core_ereco_elementor_get_owl_carousel_arraylist( $this, 11, '', array('display_type' => array('carousel') ) );
    mascot_core_ereco_elementor_get_owl_carousel_arraylist( $this, 12, '', array('display_type' => array('carousel') ) );
    mascot_core_ereco_elementor_get_owl_carousel_arraylist( $this, 13, '', array('display_type' => array('carousel') ) );
    $this->end_controls_section();

		//Carousel Arrow Navigation Options
		$this->start_controls_section(
			'carousel_arrow_nav_options', [
				'label' => esc_html__( 'Carousel Arrow Navigation Options', 'mascot-core-elementor' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 1, '', array('display_type' => array('carousel') ) );
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 2, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 3, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 4, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 5, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 6, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 7, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 8, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 9, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 10, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 11, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 12, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 13, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 14, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 15, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 16, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 17, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 18, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 19, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 20, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 21, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 22, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 23, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 24, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 25, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 26, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 27, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 28, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 29, '');
		$this->end_controls_section();

		//Carousel Bullets/Dots Options
		$this->start_controls_section(
			'carousel_arrow_dots_options', [
				'label' => esc_html__( 'Carousel Bullets/Dots Options', 'mascot-core-elementor' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 1, '', array('display_type' => array('carousel') ) );
		mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 2, '');
		mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 3, '');
		mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 4, '');
		mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 5, '');
		mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 6, '');
		mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 7, '');
		mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 8, '');
		mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 9, '');
		mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 10, '');
		mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 11, '');
		mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 12, '');
		mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 13, '');
		mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 14, '');
		mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 15, '');
		mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 16, '');
		mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 17, '');
		$this->end_controls_section();



    //Query Options
    $this->start_controls_section(
      'query',
      [
        'label' => esc_html__( 'Query', 'mascot-core-elementor' ),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'total_items',
      [
        'label' => esc_html__( "Number of Items to Query from Database", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        "description" => esc_html__( "How many items do you wish to show? Put -1 to show all. Default 3", 'mascot-core-elementor' ),
		'default' => '3'
      ]
    );
    $this->add_control(
      'selected_category',
      [
        'label' => esc_html__( "Category", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => $categories_array,
      ]
    );
    $this->add_control(
      'order_by',
      [
        'label' => esc_html__( "Order By", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => $orderby_parameters_list,
      ]
    );
    $this->add_control(
      'order',
      [
        'label' => esc_html__( "Order", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => [
            'Descending' => esc_html__( 'DESC', 'mascot-core-elementor' ),
            'Ascending' => esc_html__( 'ASC', 'mascot-core-elementor' ),
        ],
      ]
    );

    $this->end_controls_section();



    $this->start_controls_section(
      'content',
      [
        'label' => esc_html__( 'Content', 'mascot-core-elementor' ),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'show_client_name',
      [
        'label' => esc_html__( "Show Client Name", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'default' => 'no'
      ]
    );
    $this->add_control(
      'show_client_description',
      [
        'label' => esc_html__( "Show Client description", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'default' => 'no'
      ]
    );
    $this->add_control(
      'show_client_logo',
      [
        'label' => esc_html__( "Show Client Logo", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'default' => 'yes'
      ]
    );
    $this->add_control(
      'link_client_url',
      [
        'label' => esc_html__( "Link Client Logo by Url", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'default' => 'yes'
      ]
    );
    $this->add_control(
      'open_links_in',
      [
        'label' => esc_html__( "Open links in", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => mascot_core_ereco_open_link_in(),
        'default' => '_blank',
        'condition' => [
          'link_client_url' => array('yes')
        ]
      ]
    );

    $this->end_controls_section();


  }

  /**
   * Render the widget output on the frontend.
   *
   * Written in PHP and used to generate the final HTML.
   *
   * @since 1.0.0
   *
   * @access protected
   */
  protected function render() {
    $new_cpt_class = CPT_Clients::Instance();
    $settings = $this->get_settings_for_display();

    //query args
    $args = array(
      'post_type' => $new_cpt_class->ptKey,
      'orderby' => $settings['order_by'],
      'order' => $settings['order'],
      'posts_per_page' => $settings['total_items'],
    );

    //if category selected
    if( ! empty( $settings['selected_category'] ) ) {
      $args['tax_query'] = array(
        array(
          'taxonomy' => $new_cpt_class->ptTaxKey,
          'field' => 'slug',
          'terms' => explode(',', $settings['selected_category']),
        )
      );
    }

    //if order by client_author_name selected
    if( $settings['order_by'] == 'client_name' ) {
      $args['meta_key'] = 'ereco_mascot_' . 'client_name';
      $args['orderby']  = 'meta_value';
    }

    $the_query = new \WP_Query( $args );
    $settings['the_query'] = $the_query;

    //classes
    $classes = array();
    $classes[] = $settings['custom_css_class'];
    $classes[] = $settings['hover_animation_type'];
    if( $settings['rollover_effect'] == 'yes' ) {
      $classes[] = 'clients-animation-rollover';
    }
    $settings['classes'] = $classes;
    
    //Owl Carousel Data
    $settings['owl_carousel_data_info'] = ereco_mascot_prepare_owlcarousel_data_from_params( $settings );

    //Produce HTML version by using the parameters (filename, variation, folder name, parameters, shortcode_ob_start)
    $html = mascot_core_ereco_elementor_get_cpt_shortcode_template_part( 'clients', $settings['display_type'], 'clients/tpl', $settings, true );
    
    echo $html;
  }
}
