<?php ereco_mascot_wp_enqueue_script_slick(); ?>
<?php if ( !empty( $gallery_single_id ) ) : ?>
	<div class="tm-sc-gallery tm-sc-gallery-masonry <?php echo esc_attr(implode(' ', $classes)); ?>">

		<!-- Isotope Gallery Grid -->
		<div id="<?php echo esc_attr( $holder_id ) ?>" class="slick-thumbnail-slider clearfix lightgallery-lightbox" data-nav="true" data-slider-id="<?php echo esc_attr( $holder_id ) ?>">

			<!-- the loop -->
			<?php if ( !empty( $gallery_images ) ) { foreach ( $gallery_images as $each_gallery_image ) { ?>
			<!-- Isotope Item Start -->
			<div class="tm-carousel-item">
				<div class="tm-gallery box-hover-effect">
					<div class="effect-wrapper">
						<?php if ( $each_gallery_image['url'] ) { ?>
						<div class="thumb <?php if( $show_gradient_effect_on_image == 'yes' ) echo esc_attr( 'gradient-effect' );?>">
							<?php $file_info = pathinfo($each_gallery_image['url']); $gallery_thumb_url = $file_info['dirname'] . '/' .$each_gallery_image['sizes'][$thumb_image_size]['file']; ?>
							<img class=" img-fullwidth" src="<?php echo esc_url( $gallery_thumb_url );?>" alt="<?php esc_attr_e( 'Image', 'mascot-core-elementor'); ?>">
						</div>
						<?php } ?>

						<div class="overlay-shade <?php echo esc_attr( $gallery_overlay_color_on_image );?>"></div>
						<div class="icons-holder icons-holder-middle">
							<div class="icons-holder-inner">
								<div class="<?php echo esc_attr( apply_filters( 'ereco_mascot_sc_gallery_social_info', 'styled-icons icon-dark icon-circled icon-theme-colored1') ); ?>">
									<a class="lightgallery-trigger styled-icons-item" data-exthumbimage="<?php echo esc_url( $each_gallery_image['full_url'] );?>" data-src="<?php echo esc_url( $each_gallery_image['full_url'] );?>" title="<?php echo the_title_attribute (array( 'post'=>$gallery_single_id ) );?>" href="<?php echo esc_url( $each_gallery_image['full_url'] );?>"><i class="fa fa-picture-o"></i></a>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<!-- Isotope Item End -->
			<?php } } ?>
			<!-- end of the loop -->
		</div>

		<div class="slider-nav-<?php echo esc_attr( $holder_id ) ?>"  data-slider-id="<?php echo esc_attr( $holder_id ) ?>">
			<!-- the loop -->
			<?php if ( !empty( $gallery_images ) ) { foreach ( $gallery_images as $each_gallery_image ) { ?>
			<div class="thumb-item">
				<?php if ( $each_gallery_image['url'] ) { ?>
				<div class="thumb">
					<?php $file_info = pathinfo($each_gallery_image['url']); $gallery_thumb_url = $file_info['dirname'] . '/' .$each_gallery_image['sizes']['thumbnail']['file']; ?>
					<img class="img-thumbnail" src="<?php echo esc_url( $gallery_thumb_url );?>" alt="<?php esc_attr_e( 'Image', 'mascot-core-elementor'); ?>">
				</div>
				<?php } ?>
			</div>
			<?php } } ?>
			<!-- end of the loop -->
		</div>
		<!-- End Isotope Gallery Grid -->
		<?php wp_reset_postdata(); ?>
	</div>

<?php else : ?>
	<?php ereco_mascot_no_posts_match_criteria_text(); ?>
<?php endif; ?>