<?php
namespace MascotCoreErecoElementor\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

use MASCOTCOREERECO\Lib;
use MASCOTCOREERECO\CPT\Projects\CPT_Projects;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Hello World
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class TM_Elementor_Projects extends Widget_Base {

  /**
   * Retrieve the widget name.
   *
   * @since 1.0.0
   *
   * @access public
   *
   * @return string Widget name.
   */
  public function get_name() {
    return 'tm-ele-cpt-projects';
  }

  /**
   * Retrieve the widget title.
   *
   * @since 1.0.0
   *
   * @access public
   *
   * @return string Widget title.
   */
  public function get_title() {
    return esc_html__( 'Projects', 'mascot-core-elementor' );
  }

  /**
   * Retrieve the widget icon.
   *
   * @since 1.0.0
   *
   * @access public
   *
   * @return string Widget icon.
   */
  public function get_icon() {
    return 'tm-elementor-widget-icon';
  }

  /**
   * Retrieve the list of categories the widget belongs to.
   *
   * Used to determine where to display the widget in the editor.
   *
   * Note that currently Elementor supports only one category.
   * When multiple categories passed, Elementor uses the first one.
   *
   * @since 1.0.0
   *
   * @access public
   *
   * @return array Widget categories.
   */
  public function get_categories() {
    return [ 'tm' ];
  }

  /**
   * Retrieve the list of scripts the widget depended on.
   *
   * Used to set scripts dependencies required to run the widget.
   *
   * @since 1.0.0
   *
   * @access public
   *
   * @return array Widget scripts dependencies.
   */
  public function get_script_depends() {
    return [ 'mascot-core-hellojs' ];
  }

  /**
   * Register the widget controls.
   *
   * Adds different input fields to allow the user to change and customize the widget settings.
   *
   * @since 1.0.0
   *
   * @access protected
   */
  protected function _register_controls() {
    $new_cpt_class = CPT_Projects::Instance();
    $posts_array = mascot_core_ereco_get_post_list_array_by_post_type( $new_cpt_class->ptKey );
    $categories_array = ereco_mascot_category_list_array( $new_cpt_class->ptTaxKey );
    $orderby_parameters_list = mascot_core_ereco_orderby_parameters_list();

    $this->start_controls_section(
      'general', [
        'label' => esc_html__( 'General', 'mascot-core-elementor' ),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'custom_css_class', [
        'label' => esc_html__( "Custom CSS class", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::TEXT,
      ]
    );
    $this->add_control(
      'design_style', [
        'label' => esc_html__( "Design Style", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => [
          'projects-simple' => esc_html__( 'Style - Default', 'mascot-core-elementor' ),
          'projects-classic' => esc_html__( 'Style - Classic', 'mascot-core-elementor' ),
          'projects-modern' => esc_html__( 'Style - Modern', 'mascot-core-elementor' ),
          'projects-round-thumb' => esc_html__( 'Style - Round Thumb', 'mascot-core-elementor' ),
          'projects-hanging-thumb' => esc_html__( 'Style - Hanging Thumb', 'mascot-core-elementor' ),
          'projects-hanging-content' => esc_html__( 'Style - Hanging Content', 'mascot-core-elementor' ),
          'projects-fullwidth-gallery' => esc_html__( 'Style - Fullwidth Gallery', 'mascot-core-elementor' ),
          'projects-current-theme' => esc_html__( 'Style - Current Theme', 'mascot-core-elementor' ),
        ],
        'default' => 'projects-current-theme'
      ]
    );
    $this->add_control(
      'display_type', [
        'label' => esc_html__( "Display Type", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => [
          'grid'  =>  esc_html__( 'Grid', 'mascot-core-elementor' ),
          'masonry' =>  esc_html__( 'Masonry', 'mascot-core-elementor' ),
          'carousel'  =>  esc_html__( 'Carousel', 'mascot-core-elementor' )
        ],
        'default' => 'grid'
      ]
    );
    $this->add_control(
      'columns', [
        'label' => esc_html__( "Columns Layout", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => [
          '1'  =>  '1',
          '2'  =>  '2',
          '3'  =>  '3',
          '4'  =>  '4',
          '5'  =>  '5',
          '6'  =>  '6',
        ],
        'default' => '3'
      ]
    );
    $this->add_control(
      'gutter',
      [
        'label' => esc_html__( "Gutter", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => mascot_core_ereco_isotope_gutter_list_elementor(),
        'default' => 'gutter-15',
        'condition' => [
          'display_type' => array('grid', 'masonry', 'masonry-tiles')
        ]
      ]
    );

    $this->end_controls_section();





    //Carousel Options
    $this->start_controls_section(
      'carousel_options', [
        'label' => esc_html__( 'Carousel Options', 'mascot-core-elementor' ),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
          'display_type' => array('carousel')
        ]
      ]
    );
    mascot_core_ereco_elementor_get_owl_carousel_arraylist( $this, 1, '', array('display_type' => array('carousel') ) );
    mascot_core_ereco_elementor_get_owl_carousel_arraylist( $this, 2, '', array('display_type' => array('carousel') ) );
    mascot_core_ereco_elementor_get_owl_carousel_arraylist( $this, 3, '', array('display_type' => array('carousel') ) );
    mascot_core_ereco_elementor_get_owl_carousel_arraylist( $this, 4, '', array('display_type' => array('carousel') ) );
    mascot_core_ereco_elementor_get_owl_carousel_arraylist( $this, 5, '', array('display_type' => array('carousel') ) );
    mascot_core_ereco_elementor_get_owl_carousel_arraylist( $this, 6, '', array('display_type' => array('carousel') ) );
    mascot_core_ereco_elementor_get_owl_carousel_arraylist( $this, 7, '', array('display_type' => array('carousel') ) );
    mascot_core_ereco_elementor_get_owl_carousel_arraylist( $this, 8, '', array('display_type' => array('carousel') ) );
    mascot_core_ereco_elementor_get_owl_carousel_arraylist( $this, 9, '', array('display_type' => array('carousel') ) );
    mascot_core_ereco_elementor_get_owl_carousel_arraylist( $this, 10, '', array('display_type' => array('carousel') ) );
    mascot_core_ereco_elementor_get_owl_carousel_arraylist( $this, 11, '', array('display_type' => array('carousel') ) );
    mascot_core_ereco_elementor_get_owl_carousel_arraylist( $this, 12, '', array('display_type' => array('carousel') ) );
    mascot_core_ereco_elementor_get_owl_carousel_arraylist( $this, 13, '', array('display_type' => array('carousel') ) );
    mascot_core_ereco_elementor_get_owl_carousel_arraylist( $this, 14, '', array('display_type' => array('carousel') ) );
    $this->end_controls_section();

    //Carousel Arrow Navigation Options
    $this->start_controls_section(
      'carousel_arrow_nav_options', [
        'label' => esc_html__( 'Carousel Arrow Navigation Options', 'mascot-core-elementor' ),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );
    mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 1, '', array('display_type' => array('carousel') ) );
    mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 2, '');
    mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 3, '');
    mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 4, '');
    mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 5, '');
    mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 6, '');
    mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 7, '');
    mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 8, '');
    mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 9, '');
    mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 10, '');
    mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 11, '');
    mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 12, '');
    mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 13, '');
    mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 14, '');
    mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 15, '');
    mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 16, '');
    mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 17, '');
    mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 18, '');
    mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 19, '');
    mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 20, '');
    mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 21, '');
    mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 22, '');
    mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 23, '');
    mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 24, '');
    mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 25, '');
    mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 26, '');
    mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 27, '');
    mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 28, '');
    mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 29, '');
    $this->end_controls_section();




    

    //Carousel Arrow Navigation Options
    $this->start_controls_section(
      'carousel_arrow_nav_bs5_breakpoints_options', [
        'label' => esc_html__( 'Carousel Arrow Nav Bootstrap5 Breakpoints', 'mascot-core-elementor' ),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );
    mascot_core_ereco_elementor_get_owl_carousel_nav_bs5_breakpoints_arraylist( $this, 1, '');
    mascot_core_ereco_elementor_get_owl_carousel_nav_bs5_breakpoints_arraylist( $this, 2, '');
    mascot_core_ereco_elementor_get_owl_carousel_nav_bs5_breakpoints_arraylist( $this, 3, '');
    mascot_core_ereco_elementor_get_owl_carousel_nav_bs5_breakpoints_arraylist( $this, 4, '');
    mascot_core_ereco_elementor_get_owl_carousel_nav_bs5_breakpoints_arraylist( $this, 5, '');

    mascot_core_ereco_elementor_get_owl_carousel_nav_bs5_breakpoints_arraylist( $this, 6, '');
    mascot_core_ereco_elementor_get_owl_carousel_nav_bs5_breakpoints_arraylist( $this, 7, '');
    mascot_core_ereco_elementor_get_owl_carousel_nav_bs5_breakpoints_arraylist( $this, 8, '');
    mascot_core_ereco_elementor_get_owl_carousel_nav_bs5_breakpoints_arraylist( $this, 9, '');
    mascot_core_ereco_elementor_get_owl_carousel_nav_bs5_breakpoints_arraylist( $this, 10, '');
    $this->end_controls_section();






    //Carousel Bullets/Dots Options
    $this->start_controls_section(
      'carousel_arrow_dots_options', [
        'label' => esc_html__( 'Carousel Bullets/Dots Options', 'mascot-core-elementor' ),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );
    mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 1, '', array('display_type' => array('carousel') ) );
    mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 2, '');
    mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 3, '');
    mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 4, '');
    mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 5, '');
    mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 6, '');
    mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 7, '');
    mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 8, '');
    mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 9, '');
    mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 10, '');
    mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 11, '');
    mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 12, '');
    mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 13, '');
    mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 14, '');
    mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 15, '');
    mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 16, '');
    mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 17, '');
    $this->end_controls_section();





    //Query Options
    $this->start_controls_section(
      'query', [
        'label' => esc_html__( 'Query', 'mascot-core-elementor' ),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'total_items', [
        'label' => esc_html__( "Number of Items to Query from Database", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        "description" => esc_html__( "How many items do you wish to show? Put -1 to show all. Default 3", 'mascot-core-elementor' ),
        'default' => '3'
      ]
    );
    $this->add_control(
      'show_only_selected_single_post', [
        'label' => esc_html__( "Show Only Selected Single Item", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'default' => 'no',
      ]
    );
    $this->add_control(
      'selected_single_post', [
        'label' => esc_html__( "Choose Single Item", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => $posts_array,
        'condition' => [
          'show_only_selected_single_post' => array('yes')
        ]
      ]
    );
    $this->add_control(
      'selected_category', [
        'label' => esc_html__( "Category", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => $categories_array,
      ]
    );
    $this->add_control(
      'order_by', [
        'label' => esc_html__( "Order By", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => $orderby_parameters_list,
      ]
    );
    $this->add_control(
      'order', [
        'label' => esc_html__( "Order", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => [
          'DESC' => esc_html__( 'Descending', 'mascot-core-elementor' ),
          'ASC' => esc_html__( 'Ascending', 'mascot-core-elementor' ),
        ],
      ]
    );

    $this->end_controls_section();







    //Category Filter
    $this->start_controls_section(
      'cat_filter_section', [
        'label' => esc_html__( 'Category Filter', 'mascot-core-elementor' ),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );
    mascot_core_ereco_elementor_get_cat_filter_arraylist( $this, 1, array('display_type' => array('grid', 'masonry', 'carousel') ) );
    mascot_core_ereco_elementor_get_cat_filter_arraylist( $this, 2 );
    mascot_core_ereco_elementor_get_cat_filter_arraylist( $this, 3 );
    mascot_core_ereco_elementor_get_cat_filter_arraylist( $this, 4 );

    $this->end_controls_section();



    //Content Options
    $this->start_controls_section(
      'content_section', [
        'label' => esc_html__( 'Content', 'mascot-core-elementor' ),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'add_border_radius', [
        'label' => esc_html__( "Add Border Radius Around the Box", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'default' => 'yes'
      ]
    );
    $this->add_control(
      'custom_border_radius', [
        'label' => esc_html__( "Custom Border Radius", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        "description" => esc_html__( "Example: 15px 10px 15px 10px", 'mascot-core-elementor' ),
        'condition' => [
          'add_border_radius' => array('yes')
        ]
      ]
    );
    $this->add_control(
      'show_title', [
        'label' => esc_html__( "Show Title", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'default' => 'yes'
      ]
    );
    $this->add_control(
      'title_tag', [
        'label' => esc_html__( "Title Tag", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => ereco_mascot_heading_tag_list(),
        'default' => 'h5',
        'condition' => [
          'show_title' => array('yes')
        ]
      ]
    );
    $this->add_control(
      'show_excerpt', [
        'label' => esc_html__( "Show Excerpt", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'default' => 'yes'
      ]
    );
    $this->add_control(
      'excerpt_length', [
        'label' => esc_html__( "Excerpt Length", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        "description" => esc_html__( "Number of words to display. Example: 25. Default all", 'mascot-core-elementor' ),
        'condition' => [
          'show_excerpt' => array('yes')
        ]
      ]
    );
    $this->add_control(
      'show_cat', [
        'label' => esc_html__( "Show Category", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'default' => 'no'
      ]
    );
    $this->add_control(
      'show_thumb', [
        'label' => esc_html__( "Show Thumbnail", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'default' => 'yes'
      ]
    );
    $this->add_control(
      'feature_thumb_image_size', [
        'label' => esc_html__( "Thumbnail Image Size", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => mascot_core_ereco_elementor_get_available_image_sizes(),
        'condition' => [
          'show_thumb' => array('yes')
        ]
      ]
    );
    $this->end_controls_section();





    //Button
    $this->start_controls_section(
      'button_options', [
          'label' => esc_html__( 'Button Options', 'mascot-core-elementor' ),
          'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );
    mascot_core_ereco_elementor_get_viewdetails_button_arraylist($this, 1);
    mascot_core_ereco_elementor_get_viewdetails_button_arraylist($this, 2);
    mascot_core_ereco_elementor_get_button_arraylist($this, 1);
    mascot_core_ereco_elementor_get_button_arraylist($this, 2);
    mascot_core_ereco_elementor_get_button_arraylist($this, 3);
    mascot_core_ereco_elementor_get_button_arraylist($this, 4);
    mascot_core_ereco_elementor_get_button_arraylist($this, 5);
    mascot_core_ereco_elementor_get_button_arraylist($this, 6);
    mascot_core_ereco_elementor_get_button_arraylist($this, 7);
    mascot_core_ereco_elementor_get_button_arraylist($this, 8);
    mascot_core_ereco_elementor_get_button_arraylist($this, 9);
    mascot_core_ereco_elementor_get_button_arraylist($this, 10);
    mascot_core_ereco_elementor_get_button_arraylist($this, 11);
    mascot_core_ereco_elementor_get_button_arraylist($this, 12);

    $this->end_controls_section();




    //Loadmore Button options
    $this->start_controls_section(
      'loadmore_button_options', [
          'label' => esc_html__( 'Loadmore Button Options', 'mascot-core-elementor' ),
          'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );
    mascot_core_ereco_elementor_get_viewdetails_button_arraylist($this, 1,  esc_html__( "Load More", 'mascot-core-elementor' ), 'loadmore_');
    mascot_core_ereco_elementor_get_viewdetails_button_arraylist($this, 2,  esc_html__( "Load More", 'mascot-core-elementor' ), 'loadmore_');
    mascot_core_ereco_elementor_get_button_arraylist($this, 1, 'loadmore_');
    mascot_core_ereco_elementor_get_button_arraylist($this, 2, 'loadmore_');
    mascot_core_ereco_elementor_get_button_arraylist($this, 3, 'loadmore_');
    mascot_core_ereco_elementor_get_button_arraylist($this, 4, 'loadmore_');
    mascot_core_ereco_elementor_get_button_arraylist($this, 5, 'loadmore_');
    mascot_core_ereco_elementor_get_button_arraylist($this, 6, 'loadmore_');
    mascot_core_ereco_elementor_get_button_arraylist($this, 7, 'loadmore_');
    mascot_core_ereco_elementor_get_button_arraylist($this, 8, 'loadmore_');
    mascot_core_ereco_elementor_get_button_arraylist($this, 9, 'loadmore_');
    mascot_core_ereco_elementor_get_button_arraylist($this, 10, 'loadmore_');
    mascot_core_ereco_elementor_get_button_arraylist($this, 11, 'loadmore_');
    mascot_core_ereco_elementor_get_button_arraylist($this, 12, 'loadmore_');

    $this->end_controls_section();

  }

  /**
   * Render the widget output on the frontend.
   *
   * Written in PHP and used to generate the final HTML.
   *
   * @since 1.0.0
   *
   * @access protected
   */
  protected function render() {
    $settings = $this->get_settings_for_display();

    $new_cpt_class = CPT_Projects::Instance();
    $class_instance =  (array) $new_cpt_class;
    
    $settings['holder_id'] = ereco_mascot_get_isotope_holder_ID('projects');
    ereco_mascot_custom_loadmore_enque_script( 'projects', $settings, $class_instance );

    return mascot_core_ereco_elementor_cpt_sc_projects_render_output( $class_instance, $settings );
  }
}


if(!function_exists('mascot_core_ereco_elementor_cpt_sc_projects_render_output')) {
  /**
   * Output render
   */
  function mascot_core_ereco_elementor_cpt_sc_projects_render_output( $class_instance, $settings ) {
    $new_cpt_class = $class_instance;
    $paged = isset($settings['paged']) ? $settings['paged'] : '';

    if( $settings['display_type'] != 'masonry' ) {
      $settings['use_masonry_tiles_featured_image_size'] = 'false';
    }
    
    //if single post selected
    if( $settings['show_only_selected_single_post'] == 'yes' && !empty( $settings['selected_single_post'] )) {
      //query args
      $args = array(
        'p' => $settings['selected_single_post'],
        'post_type' => $new_cpt_class['ptKey'],
      );
    } else {
      //query args
      $args = array(
        'post_type' => $new_cpt_class['ptKey'],
        'orderby' => $settings['order_by'],
        'order' => $settings['order'],
        'posts_per_page' => $settings['total_items'],
        'paged' => $paged,
      );
      //if category selected
      if( ! empty( $settings['selected_category'] ) ) {
        $args['tax_query'] = array(
          array(
            'taxonomy' => $new_cpt_class['ptTaxKey'],
            'field' => 'slug',
            'terms' => explode(',', $settings['selected_category']),
          )
        );
      }
    }

    $the_query = new \WP_Query( $args );
    $settings['the_query'] = $the_query;
    
    if ( !$the_query->have_posts() && isset( $settings['from_loadmore_ajax_handler'] ) && $settings['from_loadmore_ajax_handler'] === true ) {
      return;
    }
    
    //classes
    $classes = array();
    $classes[] = $settings['design_style'];
    if( $settings['add_border_radius'] ) {
      $classes[] = 'border-radius-around-box';
    }
    $classes[] = $settings['custom_css_class'];
    $settings['classes'] = $classes;
    
    //button classes
    $settings['btn_classes'] = ereco_mascot_prepare_button_classes_from_params( $settings );
    $settings['loadmore_btn_classes'] = ereco_mascot_prepare_button_classes_from_params( $settings, 'loadmore_' );
    
    //ptTaxKey
    $settings['ptTaxKey'] = $new_cpt_class['ptTaxKey'];
    
    //Owl Carousel Data
    $settings['owl_carousel_data_info'] = ereco_mascot_prepare_owlcarousel_data_from_params( $settings );

    $settings['box_inline_css'] = ereco_mascot_get_inline_css( mascot_core_ereco_elementor_sc_projects_css( $settings ) );

    $html = mascot_core_ereco_elementor_get_cpt_shortcode_template_part( 'projects', $settings['display_type'], 'projects/tpl', $settings, true );
    
    echo $html;
  }
}

if(!function_exists('mascot_core_ereco_elementor_sc_projects_css')) {
  /**
   * Get Box Styles
   */
  function mascot_core_ereco_elementor_sc_projects_css( $settings ) {
    $css_array = array();

    if( $settings['custom_border_radius'] != '' ) {
      $css_array[] = 'border-radius: '.$settings['custom_border_radius'];
    }

    return implode( '; ', $css_array );
  }
}