<?php
namespace MascotCoreErecoElementor\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Hello World
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class TM_Elementor_BlockFeatures extends Widget_Base {

  /**
   * Retrieve the widget name.
   *
   * @since 1.0.0
   *
   * @access public
   *
   * @return string Widget name.
   */
  public function get_name() {
		return 'tm-ele-block-features';
  }

  /**
   * Retrieve the widget title.
   *
   * @since 1.0.0
   *
   * @access public
   *
   * @return string Widget title.
   */
  public function get_title() {
		return esc_html__( 'Block Features', 'mascot-core-elementor' );
  }

  /**
   * Retrieve the widget icon.
   *
   * @since 1.0.0
   *
   * @access public
   *
   * @return string Widget icon.
   */
  public function get_icon() {
		return 'tm-elementor-widget-icon';
  }

  /**
   * Retrieve the list of categories the widget belongs to.
   *
   * Used to determine where to display the widget in the editor.
   *
   * Note that currently Elementor supports only one category.
   * When multiple categories passed, Elementor uses the first one.
   *
   * @since 1.0.0
   *
   * @access public
   *
   * @return array Widget categories.
   */
  public function get_categories() {
		return [ 'tm' ];
  }

  /**
   * Retrieve the list of scripts the widget depended on.
   *
   * Used to set scripts dependencies required to run the widget.
   *
   * @since 1.0.0
   *
   * @access public
   *
   * @return array Widget scripts dependencies.
   */
  public function get_script_depends() {
		return [ 'mascot-core-hellojs' ];
  }

  /**
   * Register the widget controls.
   *
   * Adds different input fields to allow the user to change and customize the widget settings.
   *
   * @since 1.0.0
   *
   * @access protected
   */
  protected function _register_controls() {
	$this->start_controls_section(
		'general',
		[
			'label' => esc_html__( 'General', 'mascot-core-elementor' ),
			'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
		]
	);

	$this->add_control(
		'custom_css_class',
		[
			'label' => esc_html__( "Custom CSS class", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::TEXT,
		]
	);
	$this->add_control(
		'design_style',
		[
			'label' => esc_html__( "Design Style", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'options' => [
				'style1' => esc_html__( 'Style 1', 'mascot-core-elementor' ),
				'style2' => esc_html__( 'Style 2', 'mascot-core-elementor' ),
			],
			'default' => 'style1'
		]
	);
	$this->add_control(
		'box_bg_img',
		[
			'label' => esc_html__( "Background Image", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::MEDIA,
			'condition' => [
				'design_style' => array('style2')
			]
		]
	);
	$this->add_control(
		'content',
		[
			'label' => esc_html__( "Paragraph", 'mascot-core-elementor' ),
			"description" => esc_html__( "It will be displayed above/under title", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::WYSIWYG,
			'default' => esc_html__( "Write a short description, that will describe the title or something informational and useful.", 'mascot-core-elementor' ),
		]
	);
	$this->add_control(
		'content_color',
		[
			'label' => esc_html__( "Paragraph Color", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::COLOR,
			'selectors' => [
				'{{WRAPPER}} .feature-details' => 'color: {{VALUE}};'
			]
		]
	);
	$this->add_control(
		'content_color_hover',
		[
			'label' => esc_html__( "Paragraph Color on Hover", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::COLOR,
			'selectors' => [
				'{{WRAPPER}}:hover .feature-details' => 'color: {{VALUE}};'
			]
		]
	);
	$this->end_controls_section();





	$this->start_controls_section(
		'icon_section',
		[
			'label' => esc_html__( 'Icon Type', 'mascot-core-elementor' ),
			'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
		]
	);
	$this->add_control(
		'icon_custom_css_class',
		[
			'label' => esc_html__( "Icon Custom CSS Class", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::TEXT,
		]
	);
	$this->add_control(
		'icon_type',
		[
			'label' => esc_html__( "Icon Type", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'options' => [
				'no-icon' => esc_html__( 'No Icon', 'mascot-core-elementor' ),
				'font-icon' => esc_html__( 'Font Icon', 'mascot-core-elementor' ),
				'image' => esc_html__( 'JPG/PNG Image', 'mascot-core-elementor' ),
			],
			'default' => 'no-icon'
		]
	);


	//image
	$this->add_control(
		'image_icon',
		[
			'label' => esc_html__( "Upload Image Icon", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::MEDIA,
			'condition' => [
				'icon_type' => array('image')
			]
		]
	);
	$this->add_control(
		'image_icon_predefined_image_size',
		[
			'label' => esc_html__( "Choose Predefined Image Size", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'options' => mascot_core_ereco_elementor_get_available_image_sizes(),
			'default' => 'full',
			'condition' => [
				'icon_type' => array('image')
			]
		]
	);
	$this->add_control(
		'image_icon_custom_size',
		[
			'label' => esc_html__( "Image Custom Width (Only number)", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::TEXT,
			"description" => esc_html__( "Put custom width of the uploaded image in positive integer value. Example: 120", 'mascot-core-elementor' ),
			'condition' => [
				'icon_type' => array('image')
			]
		]
	);



	//font icon
	//collect icon pack
	if( function_exists('ereco_mascot_get_elementor_icon_pack_array') ) {
		ereco_mascot_get_elementor_icon_pack_array($this);
	}


	$this->add_control(
		'icon_custom_font_size',
		[
			'label' => esc_html__( "Icon Custom Font Size", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::TEXT,
			'condition' => [
				'icon_type' => array('font-icon')
			]
		]
	);
	$this->add_control(
		'icon_line_height',
		[
			'label' => esc_html__( "Icon Line Height", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::TEXT,
			'condition' => [
				'icon_type' => array('font-icon')
			]
		]
	);
	$this->add_control(
		'icon_padding_around',
		[
			'label' => esc_html__( "Padding Around Icon/Image", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::TEXT,
			'condition' => [
				'icon_type' => array('font-icon')
			]
		]
	);
	$this->add_control(
		'icon_theme_colored',
		[
			'label' => esc_html__( "Make Icon Theme Colored?", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'options' => ereco_mascot_theme_color_list(),
			'default' => '',
			'condition' => [
				'icon_type' => array('font-icon')
			]
		]
	);
	$this->add_control(
		'icon_custom_color',
		[
			'label' => esc_html__( "Icon Custom Color", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::COLOR,
			'condition' => [
				'icon_type' => array('font-icon')
			],
			'selectors' => [
				'{{WRAPPER}} .icon i' => 'color: {{VALUE}};'
			]
		]
	);
	$this->end_controls_section();










	$this->start_controls_section(
		'icon_styling',
		[
			'label' => esc_html__( 'Icon Styling', 'mascot-core-elementor' ),
			'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
		]
	);
	$this->add_control(
		'animate_icon_on_hover',
		[
			'label' => esc_html__( "Animate Icon on Hover", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'options' => [
				'' => esc_html__( 'None', 'mascot-core-elementor' ),
				'rotate' => esc_html__( 'Rotate', 'mascot-core-elementor' ),
				'rotate-x' => esc_html__( 'Rotate X', 'mascot-core-elementor' ),
				'rotate-y' => esc_html__( 'Rotate Y', 'mascot-core-elementor' ),
				'translate'  => esc_html__( 'Translate', 'mascot-core-elementor' ),
				'translate-x'  => esc_html__( 'Translate X', 'mascot-core-elementor' ),
				'translate-y'  => esc_html__( 'Translate Y', 'mascot-core-elementor' ),
				'scale'  => esc_html__( 'Scale', 'mascot-core-elementor' ),
			],
			'default' => '',
		]
	);

	$this->end_controls_section();




	$this->start_controls_section(
		'title_section',
		[
			'label' => esc_html__( 'Title Options', 'mascot-core-elementor' ),
			'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
		]
	);
	$this->add_control(
		'title_custom_css_class',
		[
			'label' => esc_html__( "Title Custom CSS Class", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::TEXT,
		]
	);
	$this->add_control(
		'title',
		[
			'label' => esc_html__( "Title", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => esc_html__( "This is a section title", 'mascot-core-elementor' ),
		]
	);
	$this->add_control(
		'title_tag',
		[
			'label' => esc_html__( "Title Tag", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'options' => ereco_mascot_heading_tag_list(),
			'default' => 'h3'
		]
	);
	$this->add_control(
		'title_text_color',
		[
			'label' => esc_html__( "Text Color", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::COLOR,
			'selectors' => [
				'{{WRAPPER}} .icon-box-title' => 'color: {{VALUE}};'
			]
		]
	);
	$this->add_group_control(
		\Elementor\Group_Control_Typography::get_type(),
		[
			'name' => 'title_typography',
			'label' => esc_html__( 'Typography', 'mascot-core-elementor' ),
			'selector' => '{{WRAPPER}} .feature-title',
		]
	);
	$this->end_controls_section();









	//other settings
	$this->start_controls_section(
		'other_options',
		[
			'label' => esc_html__( 'Other Options', 'mascot-core-elementor' ),
			'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
		]
	);
	$this->add_control(
		'text_alignment',
		[
			'label' => esc_html__( "Text Alignment", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'options' => ereco_mascot_redux_text_alignment_list(),
		]
	);
	$this->add_control(
		'box_animation',
		[
			'label' => esc_html__( "Box Animation Style", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'options' => [
			  ''  =>  esc_html__( 'No Animation', 'mascot-core-elementor' ),
			  'iconbox-style1-current-theme-animation'  =>  esc_html__( 'Style 1 - Current Theme Animation', 'mascot-core-elementor' ),
			  'iconbox-style2-border-bottom'  =>  esc_html__( 'Style 2 - Border Bottom', 'mascot-core-elementor' ),
			  'iconbox-style3-moving-border-bottom' =>  esc_html__( 'Style 3 - Moving Border Bottom', 'mascot-core-elementor' ),
			  'iconbox-style4-bgcolor'  =>  esc_html__( 'Style 4 - Hover BG Color', 'mascot-core-elementor' ),
			  'iconbox-style5-moving-bgcolor' =>  esc_html__( 'Style 5 - Hover Moving BG Color', 'mascot-core-elementor' ),
			  'iconbox-style6-moving-double-bgcolor'  =>  esc_html__( 'Style 6 - Hover Moving Double BG Color', 'mascot-core-elementor' ),
			  'iconbox-style7-hover-moving-border'  =>  esc_html__( 'Style 7 - Hover Moving Border Around Box', 'mascot-core-elementor' ),
			],
			'default' => '',
		]
	);
	$this->add_control(
		'box_shadow',
		[
			'label' => esc_html__( "Box Shadow?", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::SWITCHER,
		]
	);
	$this->add_control(
		'box_shadow_on_hover',
		[
			'label' => esc_html__( "Box Shadow only on Hover?", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::SWITCHER,
		]
	);
	$this->end_controls_section();







	$this->start_controls_section(
		'button_options',
		[
			'label' => esc_html__( 'Button Options', 'mascot-core-elementor' ),
			'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
		]
	);
	$this->add_control(
		'link_icon_title',
		[
			'label' => esc_html__( "Link Icon, Title and Button?", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::SWITCHER,
			'default' => 'no',
		]
	);

	$this->add_control(
		'link',
		[
			'label' => esc_html__( "Link URL", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::URL,
			'show_external' => true,
			'default' => [
				'url' => '',
			],
			'condition' => [
				'link_icon_title' => array('yes')
			]
		]
	);
	mascot_core_ereco_elementor_get_viewdetails_button_arraylist($this, 1);
	mascot_core_ereco_elementor_get_viewdetails_button_arraylist($this, 2);
	mascot_core_ereco_elementor_get_button_arraylist($this, 1);
	mascot_core_ereco_elementor_get_button_arraylist($this, 2);
	mascot_core_ereco_elementor_get_button_arraylist($this, 3);
	mascot_core_ereco_elementor_get_button_arraylist($this, 4);
	mascot_core_ereco_elementor_get_button_arraylist($this, 5);
	mascot_core_ereco_elementor_get_button_arraylist($this, 6);
	mascot_core_ereco_elementor_get_button_arraylist($this, 7);
	mascot_core_ereco_elementor_get_button_arraylist($this, 8);
	mascot_core_ereco_elementor_get_button_arraylist($this, 9);
	mascot_core_ereco_elementor_get_button_arraylist($this, 10);
	mascot_core_ereco_elementor_get_button_arraylist($this, 11);
	mascot_core_ereco_elementor_get_button_arraylist($this, 12);
	mascot_core_ereco_elementor_get_button_arraylist($this, 13);
	mascot_core_ereco_elementor_get_button_arraylist($this, 14);
	mascot_core_ereco_elementor_get_button_arraylist($this, 15);
	$this->end_controls_section();







  }

  /**
   * Render the widget output on the frontend.
   *
   * Written in PHP and used to generate the final HTML.
   *
   * @since 1.0.0
   *
   * @access protected
   */
  protected function render() {
	$settings = $this->get_settings_for_display();


	//link url
	$settings['target'] = ( $settings['link'] && $settings['link']['is_external'] ) ? ' target="_blank"' : '';
	$settings['url'] = ( $settings['link'] && $settings['link']['url'] ) ? $settings['link']['url'] : '';



	//classes
	$classes = array();
	$classes[] = $settings['custom_css_class'];

	if( $settings['icon_type'] ) {
	  $classes[] = 'tm-iconbox-icontype-' . $settings['icon_type'];
	}
	if( $settings['icon_theme_colored'] ) {
	  $classes[] = 'iconbox-theme-colored' . $settings['icon_theme_colored'];
	}
	if( $settings['animate_icon_on_hover'] ) {
	  $classes[] = 'animate-icon-on-hover animate-icon-'.$settings['animate_icon_on_hover'];
	}

	$settings['classes'] = $classes;


	//icon classes
	$icon_classes = array();
	$settings['icon_classes'] = $icon_classes;

	//button classes
	$settings['btn_classes'] = ereco_mascot_prepare_button_classes_from_params( $settings );

	//title classes
	$title_classes = array();
	$title_classes[] = $settings['title_custom_css_class'];
	$settings['title_classes'] = $title_classes;

	//icon classes
	$icon_classes = array();
	$icon_classes[] = $settings['icon_custom_css_class'];
	$settings['icon_classes'] = $icon_classes;

	$settings['icon_parent_inline_css'] = ereco_mascot_get_inline_css( mascot_core_ereco_elementor_icon_box_icon_parent_css( $settings ) );

	$settings['settings'] = $settings;

	//Produce HTML version by using the parameters (filename, variation, folder name, parameters, shortcode_ob_start)
	$html = mascot_core_ereco_elementor_get_shortcode_current_theme_template_part( 'block-features-' . $settings['design_style'], null, 'block-features/tpl', $settings, true );

	echo $html;
  }
}

