<?php
namespace MascotCoreErecoElementor\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Hello World
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class TM_Elementor_InfoBanner extends Widget_Base {

  /**
   * Retrieve the widget name.
   *
   * @since 1.0.0
   *
   * @access public
   *
   * @return string Widget name.
   */
  public function get_name() {
		return 'tm-ele-info-banner';
  }

  /**
   * Retrieve the widget title.
   *
   * @since 1.0.0
   *
   * @access public
   *
   * @return string Widget title.
   */
  public function get_title() {
		return esc_html__( 'Info Banner', 'mascot-core-elementor' );
  }

  /**
   * Retrieve the widget icon.
   *
   * @since 1.0.0
   *
   * @access public
   *
   * @return string Widget icon.
   */
  public function get_icon() {
		return 'tm-elementor-widget-icon';
  }

  /**
   * Retrieve the list of categories the widget belongs to.
   *
   * Used to determine where to display the widget in the editor.
   *
   * Note that currently Elementor supports only one category.
   * When multiple categories passed, Elementor uses the first one.
   *
   * @since 1.0.0
   *
   * @access public
   *
   * @return array Widget categories.
   */
  public function get_categories() {
		return [ 'tm' ];
  }

  /**
   * Retrieve the list of scripts the widget depended on.
   *
   * Used to set scripts dependencies required to run the widget.
   *
   * @since 1.0.0
   *
   * @access public
   *
   * @return array Widget scripts dependencies.
   */
  public function get_script_depends() {
		return [ 'mascot-core-hellojs' ];
  }

  /**
   * Register the widget controls.
   *
   * Adds different input fields to allow the user to change and customize the widget settings.
   *
   * @since 1.0.0
   *
   * @access protected
   */
  protected function _register_controls() {
	$this->start_controls_section(
		'general',
		[
			'label' => esc_html__( 'General', 'mascot-core-elementor' ),
			'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
		]
	);

	$this->add_control(
		'bg_image',
		[
			'label' => esc_html__( "Choose Background Image", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::MEDIA,
		]
	);
	$this->add_control(
		'bg_image_size',
		[
			'label' => esc_html__( "Background Image Size", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'options' => mascot_core_ereco_elementor_get_available_image_sizes(),
			'default' => 'large',
		]
	);
	$this->add_control(
		'overlay_color',
		[
			'label' => esc_html__( "Background Image Overlay Color", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::COLOR,
		]
	);
	$this->add_responsive_control(
		'text_alignment',
		[
			'label' => esc_html__( "Text Alignment", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'options' => mascot_core_ereco_elementor_text_alignment_list(),
			'devices' => [ 'desktop', 'tablet', 'mobile' ],
			'selectors' => [
				'{{WRAPPER}}' => 'text-align: {{VALUE}};'
			]
		]
	);
	$this->end_controls_section();














	$this->start_controls_section(
		'title_section',
		[
			'label' => esc_html__( 'Title Options', 'mascot-core-elementor' ),
			'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
		]
	);
	$this->add_control(
		'title',
		[
			'label' => esc_html__( "Title", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => esc_html__( "This is a section title", 'mascot-core-elementor' ),
		]
	);
	$this->add_control(
		'title_tag',
		[
			'label' => esc_html__( "Title Tag", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'options' => ereco_mascot_heading_tag_list(),
			'default' => 'h3'
		]
	);
	$this->add_control(
		'title_theme_colored',
		[
			'label' => esc_html__( "Make Title Theme Colored", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'options' => ereco_mascot_theme_color_list(),
			'selectors' => [
				'{{WRAPPER}} .feature-title' => 'color: var(--theme-color{{VALUE}});'
			]
		]
	);
	$this->add_control(
		'title_color',
		[
			'label' => esc_html__( "Title Custom Color", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::COLOR,
			'selectors' => [
				'{{WRAPPER}} .feature-title' => 'color: {{VALUE}};'
			]
		]
	);
	$this->add_group_control(
		\Elementor\Group_Control_Typography::get_type(),
		[
			'name' => 'title_typography',
			'label' => esc_html__( 'Typography', 'mascot-core-elementor' ),
			'selector' => '{{WRAPPER}} .feature-title',
		]
	);
	$this->end_controls_section();











	
	$this->start_controls_section(
		'content_section',
		[
			'label' => esc_html__( 'Content Options', 'mascot-core-elementor' ),
			'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
		]
	);
	$this->add_control(
		'content',
		[
			'label' => esc_html__( "Content", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::WYSIWYG,
			'default' => esc_html__( "Write a short description", 'mascot-core-elementor' ),
		]
	);
	$this->add_control(
		'content_color',
		[
			'label' => esc_html__( "Content Color", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::COLOR,
			'selectors' => [
				'{{WRAPPER}} .feature-details' => 'color: {{VALUE}};'
			]
		]
	);
	$this->add_group_control(
		\Elementor\Group_Control_Typography::get_type(),
		[
			'name' => 'content_typography',
			'label' => esc_html__( 'Typography', 'mascot-core-elementor' ),
			//'scheme' => Scheme_Typography::TYPOGRAPHY_1,
			'selector' => '{{WRAPPER}} .feature-details',
		]
	);
	$this->end_controls_section();









	$this->start_controls_section(
		'button_options',
		[
			'label' => esc_html__( 'Button Options', 'mascot-core-elementor' ),
			'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
		]
	);
	$this->add_control(
		'link_icon_title',
		[
			'label' => esc_html__( "Link Icon, Title and Button?", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::SWITCHER,
			'default' => 'no',
		]
	);

	$this->add_control(
		'link',
		[
			'label' => esc_html__( "Link URL", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::URL,
			'show_external' => true,
			'default' => [
				'url' => '',
			],
			'condition' => [
				'link_icon_title' => array('yes')
			]
		]
	);
	mascot_core_ereco_elementor_get_viewdetails_button_arraylist($this, 1);
	mascot_core_ereco_elementor_get_viewdetails_button_arraylist($this, 2);
	mascot_core_ereco_elementor_get_button_arraylist($this, 1);
	mascot_core_ereco_elementor_get_button_arraylist($this, 2);
	mascot_core_ereco_elementor_get_button_arraylist($this, 3);
	mascot_core_ereco_elementor_get_button_arraylist($this, 4);
	mascot_core_ereco_elementor_get_button_arraylist($this, 5);
	mascot_core_ereco_elementor_get_button_arraylist($this, 6);
	mascot_core_ereco_elementor_get_button_arraylist($this, 7);
	mascot_core_ereco_elementor_get_button_arraylist($this, 8);
	mascot_core_ereco_elementor_get_button_arraylist($this, 9);
	mascot_core_ereco_elementor_get_button_arraylist($this, 10);
	mascot_core_ereco_elementor_get_button_arraylist($this, 11);
	mascot_core_ereco_elementor_get_button_arraylist($this, 12);
	mascot_core_ereco_elementor_get_button_arraylist($this, 13);
	mascot_core_ereco_elementor_get_button_arraylist($this, 14);
	mascot_core_ereco_elementor_get_button_arraylist($this, 15);
	$this->end_controls_section();



	$this->start_controls_section(
		'button_color_typo_options', [
			'label' => esc_html__( 'Button Color/Typography', 'mascot-core-elementor' ),
			'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
		]
	);
	mascot_core_ereco_elementor_get_button_text_color_typo_arraylist($this, 1);
	mascot_core_ereco_elementor_get_button_text_color_typo_arraylist($this, 2);
	mascot_core_ereco_elementor_get_button_text_color_typo_arraylist($this, 3);
	mascot_core_ereco_elementor_get_button_text_color_typo_arraylist($this, 4);
	mascot_core_ereco_elementor_get_button_text_color_typo_arraylist($this, 5);
	mascot_core_ereco_elementor_get_button_text_color_typo_arraylist($this, 6);
	mascot_core_ereco_elementor_get_button_text_color_typo_arraylist($this, 7);
	mascot_core_ereco_elementor_get_button_text_color_typo_arraylist($this, 8);
	mascot_core_ereco_elementor_get_button_text_color_typo_arraylist($this, 9);
	$this->end_controls_section();

  }

  /**
   * Render the widget output on the frontend.
   *
   * Written in PHP and used to generate the final HTML.
   *
   * @since 1.0.0
   *
   * @access protected
   */
  protected function render() {
	$settings = $this->get_settings_for_display();

	//classes
	$classes = array();
	$settings['classes'] = $classes;


	//button classes
	$settings['btn_classes'] = ereco_mascot_prepare_button_classes_from_params( $settings );

	$settings['settings'] = $settings;

	//Produce HTML version by using the parameters (filename, variation, folder name, parameters, shortcode_ob_start)
	$html = mascot_core_ereco_elementor_get_shortcode_shop_template_part( 'info-banner', null, 'info-banner/tpl', $settings, true );

	echo $html;
  }
}

