<?php
namespace MascotCoreErecoElementor\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Hello World
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class TM_Elementor_Button extends Widget_Base {

  /**
   * Retrieve the widget name.
   *
   * @since 1.0.0
   *
   * @access public
   *
   * @return string Widget name.
   */
  public function get_name() {
		return 'tm-ele-button';
  }

  /**
   * Retrieve the widget title.
   *
   * @since 1.0.0
   *
   * @access public
   *
   * @return string Widget title.
   */
  public function get_title() {
		return esc_html__( 'Button', 'mascot-core-elementor' );
  }

  /**
   * Retrieve the widget icon.
   *
   * @since 1.0.0
   *
   * @access public
   *
   * @return string Widget icon.
   */
  public function get_icon() {
		return 'tm-elementor-widget-icon';
  }

  /**
   * Retrieve the list of categories the widget belongs to.
   *
   * Used to determine where to display the widget in the editor.
   *
   * Note that currently Elementor supports only one category.
   * When multiple categories passed, Elementor uses the first one.
   *
   * @since 1.0.0
   *
   * @access public
   *
   * @return array Widget categories.
   */
  public function get_categories() {
		return [ 'tm' ];
  }

  /**
   * Retrieve the list of scripts the widget depended on.
   *
   * Used to set scripts dependencies required to run the widget.
   *
   * @since 1.0.0
   *
   * @access public
   *
   * @return array Widget scripts dependencies.
   */
  public function get_script_depends() {
		return [ 'mascot-core-hellojs' ];
  }

  /**
   * Register the widget controls.
   *
   * Adds different input fields to allow the user to change and customize the widget settings.
   *
   * @since 1.0.0
   *
   * @access protected
   */
  protected function _register_controls() {
	$this->start_controls_section(
		'general',
		[
			'label' => esc_html__( 'General', 'mascot-core-elementor' ),
			'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
		]
	);
	$this->add_control(
		'custom_css_class',
		[
			'label' => esc_html__( "Custom CSS class", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::TEXT,
		]
	);
	$this->add_control(
		'button_text',
		[
			'label' => esc_html__( "Text", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => esc_html__( "Read More", 'mascot-core-elementor' ),
		]
	);
	$this->add_control(
		'link',
		[
			'label' => esc_html__( "Link URL", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::URL,
			'show_external' => true,
			'default' => [
				'url' => '',
			],
		]
	);
	$this->end_controls_section();




	$this->start_controls_section(
		'button_options', [
			'label' => esc_html__( 'Button Options', 'mascot-core-elementor' ),
			'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
		]
	);
	mascot_core_ereco_elementor_get_button_arraylist($this, 1);
	mascot_core_ereco_elementor_get_button_arraylist($this, 2);
	mascot_core_ereco_elementor_get_button_arraylist($this, 3);
	mascot_core_ereco_elementor_get_button_arraylist($this, 4);
	mascot_core_ereco_elementor_get_button_arraylist($this, 5);
	mascot_core_ereco_elementor_get_button_arraylist($this, 6);
	mascot_core_ereco_elementor_get_button_arraylist($this, 7);
	mascot_core_ereco_elementor_get_button_arraylist($this, 8);
	mascot_core_ereco_elementor_get_button_arraylist($this, 9);
	mascot_core_ereco_elementor_get_button_arraylist($this, 10);
	mascot_core_ereco_elementor_get_button_arraylist($this, 11);
	mascot_core_ereco_elementor_get_button_arraylist($this, 12);
	$this->add_control(
		'padding-topbottom',
		[
			'label' => esc_html__( "Padding Top Bottom", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::TEXT,
			'selectors' => [
				'{{WRAPPER}} .btn' => 'padding-top: {{VALUE}};padding-bottom: {{VALUE}};'
			]
		]
	);
	$this->add_control(
		'padding-leftright',
		[
			'label' => esc_html__( "Padding Left Right", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::TEXT,
			'selectors' => [
				'{{WRAPPER}} .btn' => 'padding-left: {{VALUE}};padding-right: {{VALUE}};'
			]
		]
	);

	$this->end_controls_section();



	$this->start_controls_section(
		'button_color_typo_options', [
			'label' => esc_html__( 'Button Color/Typography', 'mascot-core-elementor' ),
			'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
		]
	);
	mascot_core_ereco_elementor_get_button_text_color_typo_arraylist($this, 1);
	mascot_core_ereco_elementor_get_button_text_color_typo_arraylist($this, 2);
	mascot_core_ereco_elementor_get_button_text_color_typo_arraylist($this, 3);
	mascot_core_ereco_elementor_get_button_text_color_typo_arraylist($this, 4);
	mascot_core_ereco_elementor_get_button_text_color_typo_arraylist($this, 5);
	mascot_core_ereco_elementor_get_button_text_color_typo_arraylist($this, 6);
	mascot_core_ereco_elementor_get_button_text_color_typo_arraylist($this, 7);
	mascot_core_ereco_elementor_get_button_text_color_typo_arraylist($this, 8);
	mascot_core_ereco_elementor_get_button_text_color_typo_arraylist($this, 9);
	$this->end_controls_section();



	$this->start_controls_section(
		'icon_options', [
			'label' => esc_html__( 'Icon Options', 'mascot-core-elementor' ),
			'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
		]
	);
	$this->add_control(
		'add_icon',
		[
			'label' => esc_html__( "Add icon?", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::SWITCHER,
		]
	);
	$this->add_control(
		'button_icon_left',
		[
			'label' => esc_html__( "Icon Left", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::ICONS,
		]
	);
	$this->add_control(
		'button_icon_right',
		[
			'label' => esc_html__( "Icon Right", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::ICONS,
		]
	);
	$this->end_controls_section();
  }

  /**
   * Render the widget output on the frontend.
   *
   * Written in PHP and used to generate the final HTML.
   *
   * @since 1.0.0
   *
   * @access protected
   */
  protected function render() {
	$settings = $this->get_settings_for_display();
	
	//link url
	$settings['button']['target'] = ( $settings['link'] && $settings['link']['is_external'] ) ? ' target="_blank"' : '';
	$settings['button']['url'] = ( $settings['link'] && $settings['link']['url'] ) ? $settings['link']['url'] : '';


	//classes
	$classes = array();

	//css animation
	$classes[] = $settings['custom_css_class'];
	$settings['classes'] = $classes;

	//button classes
	$settings['btn_classes'] = ereco_mascot_prepare_button_classes_from_params( $settings );


	//Produce HTML version by using the parameters (filename, variation, folder name, parameters, shortcode_ob_start)
	$html = mascot_core_ereco_elementor_get_shortcode_template_part( 'button', null, 'button/tpl', $settings, true );

	echo $html;
  }
}