<?php
namespace MascotCoreErecoElementor\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Hello World
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class TM_Elementor_Countdown_Timer extends Widget_Base {

  /**
   * Retrieve the widget name.
   *
   * @since 1.0.0
   *
   * @access public
   *
   * @return string Widget name.
   */
  public function get_name() {
		return 'tm-ele-countdown-timer';
  }

  /**
   * Retrieve the widget title.
   *
   * @since 1.0.0
   *
   * @access public
   *
   * @return string Widget title.
   */
  public function get_title() {
		return esc_html__( 'Countdown Timer', 'mascot-core-elementor' );
  }

  /**
   * Retrieve the widget icon.
   *
   * @since 1.0.0
   *
   * @access public
   *
   * @return string Widget icon.
   */
  public function get_icon() {
		return 'tm-elementor-widget-icon';
  }

  /**
   * Retrieve the list of categories the widget belongs to.
   *
   * Used to determine where to display the widget in the editor.
   *
   * Note that currently Elementor supports only one category.
   * When multiple categories passed, Elementor uses the first one.
   *
   * @since 1.0.0
   *
   * @access public
   *
   * @return array Widget categories.
   */
  public function get_categories() {
		return [ 'tm' ];
  }

  /**
   * Retrieve the list of scripts the widget depended on.
   *
   * Used to set scripts dependencies required to run the widget.
   *
   * @since 1.0.0
   *
   * @access public
   *
   * @return array Widget scripts dependencies.
   */
  public function get_script_depends() {
		return [ 'mascot-core-hellojs' ];
  }

  /**
   * Register the widget controls.
   *
   * Adds different input fields to allow the user to change and customize the widget settings.
   *
   * @since 1.0.0
   *
   * @access protected
   */
  protected function _register_controls() {

	$this->start_controls_section(
		'general',
		[
			'label' => esc_html__( 'General', 'mascot-core-elementor' ),
			'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
		]
	);
	$this->add_control(
		'custom_css_class',
		[
			'label' => esc_html__( "Custom CSS class", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::TEXT,
		]
	);
	$this->add_control(
		'design_style',
		[
			'label' => esc_html__( "Design Style", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'options' => [
				'final-countdown-smart-style' => esc_html__( 'Final Countdown - Smart Version', 'mascot-core-elementor' ),
				'final-countdown-modern-circular' => esc_html__( 'Final Countdown - Modern Circular', 'mascot-core-elementor' ),
				'final-countdown-advanced-coupon' => esc_html__( 'Final Countdown - Advanced Coupon', 'mascot-core-elementor' ),
				'final-countdown-basic-coupon' => esc_html__( 'Final Countdown - Basic Coupon', 'mascot-core-elementor' ),
				'final-countdown-legacy-style' => esc_html__( 'Final Countdown - Legacy style', 'mascot-core-elementor' ),
				'final-countdown-months-offsets' => esc_html__( 'Final Countdown - Months + Days', 'mascot-core-elementor' ),
				'final-countdown-weeks-offsets' => esc_html__( 'Final Countdown - Weeks + Days', 'mascot-core-elementor' ),
				'final-countdown-days-offsets' => esc_html__( 'Final Countdown - Only Days', 'mascot-core-elementor' ),
				'final-countdown-hours' => esc_html__( 'Final Countdown - Only Hours', 'mascot-core-elementor' ),
			],
			'default' => 'final-countdown-advanced-coupon'
		]
	);
	$this->add_control(
		'countdown_future_date_time',
		[
			'label' => esc_html__( "Future Ending Date & Time (Format Y/m/d H:i:s)", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::TEXT,
			'description' => sprintf( esc_html__( 'See documentation from %1$shere%2$s to format a local time/date.', 'mascot-core-elementor' ), '<a target="_blank" href="' . esc_url( 'http://www.php.net/manual/en/function.date.php' ) . '">', '</a>' ),
			'default' => date("Y/m/d H:i:s", strtotime("+5 week")),
		]
	);
	$this->add_control(
		'show_time',
		[
			'label' => esc_html__( "Show Time?", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::SWITCHER,
			'label_on' => esc_html__( 'Yes', 'mascot-core-elementor' ),
			'label_off' => esc_html__( 'No', 'mascot-core-elementor' ),
			'return_value' => 'yes',
			'default' => 'yes',
			'description' => esc_html__( "Show or Hide Time of the date", 'mascot-core-elementor' ),
		]
	);


	$this->add_control(
		'timezone',
		[
			'label' => esc_html__( "Timezone", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::TEXT,
			'description' => sprintf( esc_html__( 'Example: Europe/Zurich. Get your own timezone from %1$shere%2$s.', 'mascot-core-elementor' ), '<a target="_blank" href="' . esc_url( 'http://php.net/manual/en/timezones.php' ) . '">', '</a>' ),
			'condition' => [
				'design_style' => array('final-countdown-modern-circular')
			]
		]
	);
	$this->add_control(
		'borderwidth',
		[
			'label' => esc_html__( "Circle Border Width", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => '3',
			'condition' => [
				'design_style' => array('final-countdown-modern-circular')
			]
		]
	);
	$this->add_control(
		'bordercolor_second',
		[
			'label' => esc_html__( "Second Border Color", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::COLOR,
			'default' => '#7995D5',
			'condition' => [
				'design_style' => array('final-countdown-modern-circular')
			]
		]
	);
	$this->add_control(
		'bordercolor_minutes',
		[
			'label' => esc_html__( "Minutes Border Color", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::COLOR,
			'default' => '#ACC742',
			'condition' => [
				'design_style' => array('final-countdown-modern-circular')
			]
		]
	);
	$this->add_control(
		'bordercolor_hours',
		[
			'label' => esc_html__( "Hours Border Color", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::COLOR,
			'default' => '#ECEFCB',
			'condition' => [
				'design_style' => array('final-countdown-modern-circular')
			]
		]
	);
	$this->add_control(
		'bordercolor_days',
		[
			'label' => esc_html__( "Days Border Color", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::COLOR,
			'default' => '#FF9900',
			'condition' => [
				'design_style' => array('final-countdown-modern-circular')
			]
		]
	);
	$this->end_controls_section();



	$this->start_controls_section(
		'Word_options',
		[
			'label' => esc_html__( 'Word Options', 'mascot-core-elementor' ),
			'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
		]
	);
	$this->add_control(
		'word_month',
		[
			'label' => esc_html__( "Word - Month", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => 'months'
		]
	);
	$this->add_control(
		'word_week',
		[
			'label' => esc_html__( "Word - Week", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => 'weeks'
		]
	);
	$this->add_control(
		'word_day',
		[
			'label' => esc_html__( "Word - Day", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => 'days'
		]
	);
	$this->add_control(
		'word_hr',
		[
			'label' => esc_html__( "Word - Hour", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => 'hr'
		]
	);
	$this->add_control(
		'word_min',
		[
			'label' => esc_html__( "Word - Minute", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => 'min'
		]
	);
	$this->add_control(
		'word_sec',
		[
			'label' => esc_html__( "Word - Second", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => 'sec'
		]
	);

	$this->end_controls_section();

  }

  /**
   * Render the widget output on the frontend.
   *
   * Written in PHP and used to generate the final HTML.
   *
   * @since 1.0.0
   *
   * @access protected
   */
  protected function render() {
	$settings = $this->get_settings_for_display();

	wp_register_script( 'jquery-countdown', MASCOT_CORE_TEMPLATE_URI . '/assets/js/plugins/jquery.countdown.min.js', array('jquery'), false, true );
	wp_register_script( 'jquery-final-countdown', MASCOT_CORE_TEMPLATE_URI . '/assets/js/plugins/jquery.final-countdown.min.js', array('jquery'), false, true );
	wp_register_script( 'kinetic', MASCOT_CORE_TEMPLATE_URI . '/assets/js/plugins/kinetic.js', array('jquery'), false, true );
	wp_enqueue_script( 'jquery-countdown' );
	wp_enqueue_script( 'jquery-final-countdown' );

	if( $settings['design_style'] == 'final-countdown-modern-circular' ) {
	  wp_enqueue_script( 'kinetic' );
	}

	//classes
	$classes = array();
	$classes[] = $settings['custom_css_class'];
	$settings['classes'] = $classes;

	//Produce HTML version by using the parameters (filename, variation, folder name, parameters, shortcode_ob_start)
	$html = mascot_core_ereco_elementor_get_shortcode_template_part( 'countdown-timer-' . $settings['design_style'], null, 'countdown-timer/tpl', $settings, true );

	echo $html;
  }
}
