<?php
namespace MascotCoreErecoElementor\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;


if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Hello World
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class TM_Elementor_Give_Campaigns extends Widget_Base {

	/**
	 * Retrieve the widget name.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'tm-ele-cpt-give-campaigns';
	}

	/**
	 * Retrieve the widget title.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Give Campaigns', 'mascot-core-elementor' );
	}

	/**
	 * Retrieve the widget icon.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'tm-elementor-widget-icon';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * Note that currently Elementor supports only one category.
	 * When multiple categories passed, Elementor uses the first one.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'tm' ];
	}

	/**
	 * Retrieve the list of scripts the widget depended on.
	 *
	 * Used to set scripts dependencies required to run the widget.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget scripts dependencies.
	 */
	public function get_script_depends() {
		return [ 'mascot-core-hellojs' ];
	}

	/**
	 * Register the widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function _register_controls() {
		$categories_array = ereco_mascot_category_list_array( 'give_forms_category' );
		$tag_array = ereco_mascot_category_list_array( 'give_forms_tag' );

		$post_meta_array = array(
			'show-post-by-author' =>  esc_html__( 'Show Author', 'mascot-core-elementor' ),
			'show-post-date'  =>  esc_html__( 'Show Date', 'mascot-core-elementor' ),
			'show-post-category'  =>  esc_html__( 'Show Category', 'mascot-core-elementor' ),
			'show-post-comments-count'  =>  esc_html__( 'Show Comments Count', 'mascot-core-elementor' ),
			'show-post-tag' =>  esc_html__( 'Show Tag', 'mascot-core-elementor' ),
			'show-post-like-button'  =>  esc_html__( 'Show Like Button', 'mascot-core-elementor' )
		);

		$this->start_controls_section(
			'general', [
				'label' => esc_html__( 'General', 'mascot-core-elementor' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'custom_css_class', [
				'label' => esc_html__( "Custom CSS class", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::TEXT,
			]
		);
		$this->add_control(
			'design_style', [
				'label' => esc_html__( "Design Style", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'current-theme-style1'	=>	esc_html__( 'Current Theme Style 1', 'mascot-core-elementor' ),
					'current-theme-style2'	=>	esc_html__( 'Current Theme Style 2', 'mascot-core-elementor' )
				],
				'default' => 'current-theme-style1'
			]
		);
		$this->add_control(
			'display_type', [
				'label' => esc_html__( "Display Type", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'grid'	=>	esc_html__( 'Grid', 'mascot-core-elementor' ),
					'masonry'	=>	esc_html__( 'Masonry', 'mascot-core-elementor' ),
					'carousel'	=>	esc_html__( 'Carousel', 'mascot-core-elementor' ),
					'horizontal'	=>	esc_html__( 'Horizontal Fullwidth', 'mascot-core-elementor' ),
					'horizontal-carousel'	=>	esc_html__( 'Horizontal Fullwidth + Carousel', 'mascot-core-elementor' )
				],
				'default' => 'grid'
			]
		);
		$this->add_control(
			'columns', [
				'label' => esc_html__( "Columns Layout", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'1'  =>  '1',
					'2'  =>  '2',
					'3'  =>  '3',
					'4'  =>  '4',
					'5'  =>  '5',
					'6'  =>  '6',
				],
				'default' => '3'
			]
		);
		$this->add_control(
			'gutter',
			[
				'label' => esc_html__( "Gutter", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => mascot_core_ereco_isotope_gutter_list_elementor(),
				'default' => 'gutter-15',
				'condition' => [
					'display_type' => array('grid', 'masonry', 'masonry-tiles')
				]
			]
		);

		$this->end_controls_section();





		//Carousel Options
		$this->start_controls_section(
			'carousel_options', [
				'label' => esc_html__( 'Carousel Options', 'mascot-core-elementor' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
				'condition' => [
					'display_type' => array('carousel')
				]
			]
		);
		mascot_core_ereco_elementor_get_owl_carousel_arraylist( $this, 1, '', array('display_type' => array('carousel') ) );
		mascot_core_ereco_elementor_get_owl_carousel_arraylist( $this, 2, '', array('display_type' => array('carousel') ) );
		mascot_core_ereco_elementor_get_owl_carousel_arraylist( $this, 3, '', array('display_type' => array('carousel') ) );
		mascot_core_ereco_elementor_get_owl_carousel_arraylist( $this, 4, '', array('display_type' => array('carousel') ) );
		mascot_core_ereco_elementor_get_owl_carousel_arraylist( $this, 5, '', array('display_type' => array('carousel') ) );
		mascot_core_ereco_elementor_get_owl_carousel_arraylist( $this, 6, '', array('display_type' => array('carousel') ) );
		mascot_core_ereco_elementor_get_owl_carousel_arraylist( $this, 7, '', array('display_type' => array('carousel') ) );
		mascot_core_ereco_elementor_get_owl_carousel_arraylist( $this, 8, '', array('display_type' => array('carousel') ) );
		mascot_core_ereco_elementor_get_owl_carousel_arraylist( $this, 9, '', array('display_type' => array('carousel') ) );
		mascot_core_ereco_elementor_get_owl_carousel_arraylist( $this, 10, '', array('display_type' => array('carousel') ) );
		mascot_core_ereco_elementor_get_owl_carousel_arraylist( $this, 11, '', array('display_type' => array('carousel') ) );
		mascot_core_ereco_elementor_get_owl_carousel_arraylist( $this, 12, '', array('display_type' => array('carousel') ) );
		mascot_core_ereco_elementor_get_owl_carousel_arraylist( $this, 13, '', array('display_type' => array('carousel') ) );
		mascot_core_ereco_elementor_get_owl_carousel_arraylist( $this, 14, '', array('display_type' => array('carousel') ) );
		$this->end_controls_section();

		//Carousel Arrow Navigation Options
		$this->start_controls_section(
			'carousel_arrow_nav_options', [
				'label' => esc_html__( 'Carousel Arrow Navigation Options', 'mascot-core-elementor' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 1, '', array('display_type' => array('carousel') ) );
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 2, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 3, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 4, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 5, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 6, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 7, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 8, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 9, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 10, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 11, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 12, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 13, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 14, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 15, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 16, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 17, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 18, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 19, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 20, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 21, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 22, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 23, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 24, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 25, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 26, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 27, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 28, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 29, '');
		$this->end_controls_section();




		

		//Carousel Arrow Navigation Options
		$this->start_controls_section(
			'carousel_arrow_nav_bs5_breakpoints_options', [
				'label' => esc_html__( 'Carousel Arrow Nav Bootstrap5 Breakpoints', 'mascot-core-elementor' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		mascot_core_ereco_elementor_get_owl_carousel_nav_bs5_breakpoints_arraylist( $this, 1, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_bs5_breakpoints_arraylist( $this, 2, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_bs5_breakpoints_arraylist( $this, 3, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_bs5_breakpoints_arraylist( $this, 4, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_bs5_breakpoints_arraylist( $this, 5, '');

		mascot_core_ereco_elementor_get_owl_carousel_nav_bs5_breakpoints_arraylist( $this, 6, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_bs5_breakpoints_arraylist( $this, 7, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_bs5_breakpoints_arraylist( $this, 8, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_bs5_breakpoints_arraylist( $this, 9, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_bs5_breakpoints_arraylist( $this, 10, '');
		$this->end_controls_section();






		//Carousel Bullets/Dots Options
		$this->start_controls_section(
			'carousel_arrow_dots_options', [
				'label' => esc_html__( 'Carousel Bullets/Dots Options', 'mascot-core-elementor' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 1, '', array('display_type' => array('carousel') ) );
		mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 2, '');
		mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 3, '');
		mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 4, '');
		mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 5, '');
		mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 6, '');
		mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 7, '');
		mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 8, '');
		mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 9, '');
		mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 10, '');
		mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 11, '');
		mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 12, '');
		mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 13, '');
		mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 14, '');
		mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 15, '');
		mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 16, '');
		mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 17, '');
		$this->end_controls_section();






		$this->start_controls_section(
			'query', [
				'label' => esc_html__( 'Query', 'mascot-core-elementor' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'total_items', [
				'label' => esc_html__( "Number of Items to Query from Database", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				"description" => esc_html__( "How many items do you wish to show? Put -1 to show all. Default 3", 'mascot-core-elementor' ),
				'default' => '3'
			]
		);
		$this->add_control(
			'selected_category', [
				'label' => esc_html__( "Category", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => $categories_array,
			]
		);
		$this->add_control(
			'tag', [
				'label' => esc_html__( "Tag", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => $tag_array,
			]
		);
		$this->add_control(
			'campaigns_id', [
				'label' => esc_html__( "Donation Form ID", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				"description" => esc_html__( "To display donation frms with specific ID, you can provide a single number or multiple IDs as a comma separated list. Example: 33,44", 'mascot-core-elementor' ),
			]
		);
		$this->add_control(
			'order_by', [
				'label' => esc_html__( "Order By", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'date'	=>	esc_html__( 'Date', 'mascot-core-elementor' ),
					'title'	=>	esc_html__( 'Title', 'mascot-core-elementor' ),
					'popular'	=>	esc_html__( 'Popular', 'mascot-core-elementor' ),
					'ending'	=>	esc_html__( 'Ending', 'mascot-core-elementor' ),
				],
			]
		);
		$this->add_control(
			'order', [
				'label' => esc_html__( "Order", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'DESC' => esc_html__( 'Descending', 'mascot-core-elementor' ),
					'ASC' => esc_html__( 'Ascending', 'mascot-core-elementor' ),
				],
			]
		);

		$this->end_controls_section();







		//Category Filter
		$this->start_controls_section(
			'cat_filter_section', [
				'label' => esc_html__( 'Category Filter', 'mascot-core-elementor' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		mascot_core_ereco_elementor_get_cat_filter_arraylist( $this, 1, array('display_type' => array('grid', 'masonry', 'carousel') ) );
		mascot_core_ereco_elementor_get_cat_filter_arraylist( $this, 2 );
		mascot_core_ereco_elementor_get_cat_filter_arraylist( $this, 3 );
		mascot_core_ereco_elementor_get_cat_filter_arraylist( $this, 4 );

		$this->end_controls_section();




		$this->start_controls_section(
			'content_section', [
				'label' => esc_html__( 'Content', 'mascot-core-elementor' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'show_thumb', [
				'label' => esc_html__( "Show Thumbnail", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'yes'
			]
		);
		$this->add_control(
			'feature_thumb_image_size', [
				'label' => esc_html__( "Thumbnail Image Size", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => mascot_core_ereco_elementor_get_available_image_sizes(),
				'default' => 'post-thumbnail',
				'condition' => [
						'show_thumb' => array('yes')
				]
			]
		);
		$this->add_control(
			'show_title', [
				'label' => esc_html__( "Show Title", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'yes'
			]
		);
		$this->add_control(
			'title_tag', [
				'label' => esc_html__( "Title Tag", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => ereco_mascot_heading_tag_list(),
				'default' => 'h5',
				'condition' => [
					'show_title' => array('yes')
				]
			]
		);
		$this->add_control(
			'show_excerpt', [
				'label' => esc_html__( "Show Excerpt", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'yes'
			]
		);
		$this->add_control(
			'excerpt_length', [
				'label' => esc_html__( "Excerpt Length", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				"description" => esc_html__( "Number of words to display. Example: 25. Default all", 'mascot-core-elementor' ),
				'condition' => [
					'show_excerpt' => array('yes')
				]
			]
		);
		$this->add_control(
			'show_meta', [
				'label' => esc_html__( "Show Meta", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'yes'
			]
		);
		$this->add_control(
			'meta_options',
			[
				'label' => esc_html__( "Choose Meta", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'options' => [
					'show-created-date'	=>	esc_html__( 'Show Created Date', 'mascot-core-elementor' ),
					'show-category'	=>	esc_html__( 'Show Category', 'mascot-core-elementor' ),
					'show-tag'	=>	esc_html__( 'Show Tag', 'mascot-core-elementor' ),
					'show-campaign-creator'	=>	esc_html__( 'Show Campaign Creator', 'mascot-core-elementor' )
				],
				'multiple' => true,
				'description' => esc_html__('Enable/Disabling this option will show/hide each Post Meta', 'mascot-core-elementor'),
				'default' => [ 'show-created-date' ],
				'condition' => [
					'show_meta' => array('yes')
				]
			]
		);
		$this->add_control(
			'show_progress', [
				'label' => esc_html__( "Show Progress", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'yes'
			]
		);
		$this->add_control(
			'show_donation_stats', [
				'label' => esc_html__( "Show Donation Stats", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'yes'
			]
		);

		$this->end_controls_section();






		$this->start_controls_section(
			'button_options', [
					'label' => esc_html__( 'Button Options', 'mascot-core-elementor' ),
					'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		mascot_core_ereco_elementor_get_viewdetails_button_arraylist($this, 1);
		mascot_core_ereco_elementor_get_viewdetails_button_arraylist($this, 2);
		mascot_core_ereco_elementor_get_button_arraylist($this, 1);
		mascot_core_ereco_elementor_get_button_arraylist($this, 2);
		mascot_core_ereco_elementor_get_button_arraylist($this, 3);
		mascot_core_ereco_elementor_get_button_arraylist($this, 4);
		mascot_core_ereco_elementor_get_button_arraylist($this, 5);
		mascot_core_ereco_elementor_get_button_arraylist($this, 6);
		mascot_core_ereco_elementor_get_button_arraylist($this, 7);
		mascot_core_ereco_elementor_get_button_arraylist($this, 8);
		mascot_core_ereco_elementor_get_button_arraylist($this, 9);
		mascot_core_ereco_elementor_get_button_arraylist($this, 10);
		mascot_core_ereco_elementor_get_button_arraylist($this, 11);
		mascot_core_ereco_elementor_get_button_arraylist($this, 12);

		$this->end_controls_section();






		$this->start_controls_section(
			'donate_button_options', [
					'label' => esc_html__( 'Donate Button Options', 'mascot-core-elementor' ),
					'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		mascot_core_ereco_elementor_get_viewdetails_button_arraylist($this, 1,  esc_html__( "Donate Now", 'mascot-core-elementor' ), 'donate_');
		mascot_core_ereco_elementor_get_viewdetails_button_arraylist($this, 2,  esc_html__( "Donate Now", 'mascot-core-elementor' ), 'donate_');
		mascot_core_ereco_elementor_get_button_arraylist($this, 1, 'donate_');
		mascot_core_ereco_elementor_get_button_arraylist($this, 2, 'donate_');
		mascot_core_ereco_elementor_get_button_arraylist($this, 3, 'donate_');
		mascot_core_ereco_elementor_get_button_arraylist($this, 4, 'donate_');
		mascot_core_ereco_elementor_get_button_arraylist($this, 5, 'donate_');
		mascot_core_ereco_elementor_get_button_arraylist($this, 6, 'donate_');
		mascot_core_ereco_elementor_get_button_arraylist($this, 7, 'donate_');
		mascot_core_ereco_elementor_get_button_arraylist($this, 8, 'donate_');
		mascot_core_ereco_elementor_get_button_arraylist($this, 9, 'donate_');
		mascot_core_ereco_elementor_get_button_arraylist($this, 10, 'donate_');
		mascot_core_ereco_elementor_get_button_arraylist($this, 11, 'donate_');
		mascot_core_ereco_elementor_get_button_arraylist($this, 12, 'donate_');

		$this->end_controls_section();






		$this->start_controls_section(
			'loadmore_button_options', [
					'label' => esc_html__( 'Loadmore Button Options', 'mascot-core-elementor' ),
					'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		mascot_core_ereco_elementor_get_viewdetails_button_arraylist($this, 1,  esc_html__( "Load More", 'mascot-core-elementor' ), 'loadmore_');
		mascot_core_ereco_elementor_get_viewdetails_button_arraylist($this, 2,  esc_html__( "Load More", 'mascot-core-elementor' ), 'loadmore_');
		mascot_core_ereco_elementor_get_button_arraylist($this, 1, 'loadmore_');
		mascot_core_ereco_elementor_get_button_arraylist($this, 2, 'loadmore_');
		mascot_core_ereco_elementor_get_button_arraylist($this, 3, 'loadmore_');
		mascot_core_ereco_elementor_get_button_arraylist($this, 4, 'loadmore_');
		mascot_core_ereco_elementor_get_button_arraylist($this, 5, 'loadmore_');
		mascot_core_ereco_elementor_get_button_arraylist($this, 6, 'loadmore_');
		mascot_core_ereco_elementor_get_button_arraylist($this, 7, 'loadmore_');
		mascot_core_ereco_elementor_get_button_arraylist($this, 8, 'loadmore_');
		mascot_core_ereco_elementor_get_button_arraylist($this, 9, 'loadmore_');
		mascot_core_ereco_elementor_get_button_arraylist($this, 10, 'loadmore_');
		mascot_core_ereco_elementor_get_button_arraylist($this, 11, 'loadmore_');
		mascot_core_ereco_elementor_get_button_arraylist($this, 12, 'loadmore_');

		$this->end_controls_section();

	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		
		$class_instance =  array();

		$settings['holder_id'] = ereco_mascot_get_isotope_holder_ID('give-campaigns');
		ereco_mascot_custom_loadmore_enque_script( 'give-campaigns', $settings, $class_instance );

		return mascot_core_ereco_elementor_sc_give_campaigns_render_output( $class_instance, $settings );
	}
}



if(!function_exists('mascot_core_ereco_elementor_sc_give_campaigns_render_output')) {
	/**
	 * Output render
	 */
	function mascot_core_ereco_elementor_sc_give_campaigns_render_output( $class_instance, $settings ) {
		$new_cpt_class = $class_instance;
		$paged = isset($settings['paged']) ? $settings['paged'] : '';

		if( $settings['display_type'] != 'masonry' ) {
			$settings['use_masonry_tiles_featured_image_size'] = 'false';
		}
		
		
		//query args
		$args = array(
			'post_type' => 'give_forms',
			'orderby' => $settings['order_by'],
			'order' => $settings['order'],
			'posts_per_page' => $settings['total_items'],
			'paged' => $paged,
		);

		//if order by client_author_name selected
		if( $settings['order_by'] == 'end-date' ) {
			$args['meta_key'] = '_campaign_end_date';
			$args['orderby']  = 'meta_value';
		}

		/* Specific campaign IDs */
		if ( ! empty( $settings['campaigns_id'] ) ) {
			$args['post__in'] = explode( ',', $settings['campaigns_id'] );
		}

		//if category selected
		if( ! empty( $settings['category'] ) ) {
			$args['tax_query'] = array(
				array(
					'taxonomy' => 'give_forms_category',
					'field'	=> 'slug',
					'terms'	=> explode(',', $settings['category']),
				)
			);
		}

		/* Set tag constraint */
		if ( ! empty( $settings['tag'] ) ) {
			if ( ! array_key_exists( 'tax_query', $args ) ) {
				$args['tax_query'] = array();
			}

			$args['tax_query'][] = array(
				'taxonomy' => 'give_forms_tag',
				'field'    => 'slug',
				'terms'    => explode( ',', $settings['tag'] ),
			);
		}


		$the_query = new \WP_Query( $args );
		$settings['the_query'] = $the_query;
		
		if ( !$the_query->have_posts() && isset( $settings['from_loadmore_ajax_handler'] ) && $settings['from_loadmore_ajax_handler'] === true ) {
			return;
		}
		
		//classes
		$classes = array();
		if( isset($settings['design_style']) ) {
			$classes[] = 'give-campaigns-' . $settings['design_style'];
		}
		$classes[] = $settings['custom_css_class'];
		$settings['classes'] = $classes;

		//button classes
		$settings['btn_classes'] = ereco_mascot_prepare_button_classes_from_params( $settings );
		$settings['donate_btn_classes'] = ereco_mascot_prepare_button_classes_from_params( $settings, 'donate_' );
		$settings['loadmore_btn_classes'] = ereco_mascot_prepare_button_classes_from_params( $settings, 'loadmore_' );

		//meta options
		if(!empty($settings['meta_options'])) {
			$settings['meta_options'] = implode(",", $settings['meta_options']);
			$settings['meta_options'] = explode(',', $settings['meta_options']);
		}
		
		//Owl Carousel Data
		$settings['owl_carousel_data_info'] = ereco_mascot_prepare_owlcarousel_data_from_params( $settings );

		$settings['settings'] = $settings;

		//Produce HTML version by using the parameters (filename, variation, folder name, parameters, shortcode_ob_start)
		$html = mascot_core_ereco_elementor_get_shortcode_template_part( 'campaigns', $settings['display_type'], 'give-campaigns/tpl', $settings, true );
		
		echo $html;
	}
}