<?php 
	wp_enqueue_script( 'jquery-easypiechart' );
	$size = 180;
?>
<div class="tm-sc-give-single-form <?php echo esc_attr(implode(' ', $classes)); ?>">
	<div class="tm-sc-pie-chart">
		<div class="pie-chart" 
			data-bar-color="#efc94c" 
			data-track-color="#bf402f" 
			data-scale-color="#888" 

			data-scale-length="0" 
			data-line-cap="round" 
			data-line-width="5" 
			data-size="<?php echo esc_attr($size)?>" 

			data-percent="33" 
			style="width: <?php echo esc_attr($size)?>px; height: <?php echo esc_attr($size)?>px; line-height: <?php echo esc_attr($size)?>px;" 
			>
			<span class="percent"></span>
		</div>
	</div>

	<?php if ( !empty($custom_subtitle) ) : ?>
	<h5 class="subtitle"><?php echo esc_html( $custom_subtitle ); ?></h5>
	<?php endif; ?>

	<?php if ( $show_title == 'yes' ) : ?>
	<<?php echo esc_attr( $title_tag );?> class="title"><a href="<?php the_permalink() ?>"><?php echo get_the_title($form_id) ?></a></<?php echo esc_attr( $title_tag );?>>
	<?php endif; ?>

	<?php if ( $show_excerpt == 'yes' ) : ?>
	<p class="excerpt"><?php echo get_the_excerpt($form_id) ?></p>
	<?php endif; ?>
	<?php echo do_shortcode( '[give_goal id="'. $form_id .'" show_text="true" show_bar="false"]' ); ?>
	<?php mascot_core_ereco_elementor_get_shortcode_template_part( 'button', null, 'give-single-form-custom/tpl-single', $params, false );?>
</div>