<?php
namespace MascotCoreErecoElementor\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Hello World
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class TM_Elementor_Navigation_Menu extends Widget_Base {
  public function __construct($data = [], $args = null) {
    parent::__construct($data, $args);
    wp_register_style('mascot-core-elementor-navigation-menu-css', plugins_url( '/css/navigation-menu.css', __FILE__ ), [], '1.1' );
  }

  /**
   * Retrieve the widget name.
   *
   * @since 1.0.0
   *
   * @access public
   *
   * @return string Widget name.
   */
  public function get_name() {
    return 'tm-ele-navigation-menu';
  }

  /**
   * Retrieve the widget title.
   *
   * @since 1.0.0
   *
   * @access public
   *
   * @return string Widget title.
   */
  public function get_title() {
    return esc_html__( 'TM Navigation Menu', 'mascot-core-elementor' );
  }

  /**
   * Retrieve the widget icon.
   *
   * @since 1.0.0
   *
   * @access public
   *
   * @return string Widget icon.
   */
  public function get_icon() {
    return 'tm-elementor-widget-icon';
  }

  /**
   * Retrieve the list of categories the widget belongs to.
   *
   * Used to determine where to display the widget in the editor.
   *
   * Note that currently Elementor supports only one category.
   * When multiple categories passed, Elementor uses the first one.
   *
   * @since 1.0.0
   *
   * @access public
   *
   * @return array Widget categories.
   */
  public function get_categories() {
    return [ 'tm' ];
  }

  /**
   * Retrieve the list of scripts the widget depended on.
   *
   * Used to set scripts dependencies required to run the widget.
   *
   * @since 1.0.0
   *
   * @access public
   *
   * @return array Widget scripts dependencies.
   */
  public function get_script_depends() {
    return [ 'mascot-core-hellojs' ];
  }
  
  public function get_style_depends() {
  return [ 'mascot-core-elementor-navigation-menu-css' ];
  }

  /**
   * Get all registered menus.
   *
   * @return array of menus.
   */
  private function get_simple_menus()
  {
    $menus   = wp_get_nav_menus();
    $options = [];

    if (empty($menus)) {
      return $options;
    }

    foreach ($menus as $menu) {
      $options[$menu->term_id] = $menu->name;
    }

    return $options;
  }

  /**
   * Register the widget controls.
   *
   * Adds different input fields to allow the user to change and customize the widget settings.
   *
   * @since 1.0.0
   *
   * @access protected
   */
  protected function _register_controls() {


    $this->start_controls_section(
      'general',
      [
        'label' => esc_html__( 'General', 'mascot-core-elementor' ),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'custom_css_class',
      [
        'label' => esc_html__( "Custom CSS class", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::TEXT,
      ]
    );

    $simple_menus = $this->get_simple_menus();

    if ($simple_menus) {
      $this->add_control(
        'tm_menu_selected',
        [
          'label'       => esc_html__('Select Menu', 'mascot-core-elementor'),
          'description' => sprintf(__('Go to the <a href="%s" target="_blank">Menu screen</a> to manage your menus.', 'mascot-core-elementor'), admin_url('nav-menus.php')),
          'type'        => Controls_Manager::SELECT,
          'label_block' => false,
          'options'     => $simple_menus,
          'default'     => array_keys($simple_menus)[0],
        ]
      );
          $this->add_control(
            'split_nav', [
              'label' => esc_html__( "Split This Nav Menu Into Two Columns", 'mascot-core-elementor' ),
              'type' => \Elementor\Controls_Manager::SWITCHER,
              'default' => 'no',
            ]
          );
    } else {
      $this->add_control(
        'menu',
        [
          'type'      => Controls_Manager::RAW_HTML,
          'raw'       => sprintf(__('<strong>There are no menus in your site.</strong><br>Go to the <a href="%s" target="_blank">Menus screen</a> to create one.', 'mascot-core-elementor'), admin_url('nav-menus.php?action=edit&menu=0')),
          'separator' => 'after',
        ]
      );
    }
    $this->end_controls_section();


    $this->start_controls_section(
      'horizontal_list_options',
      [
        'label' => esc_html__( 'Horizontal List Options', 'mascot-core-elementor' ),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_responsive_control(
      'list_disply_type',
      [
        'label' => esc_html__('Display Property', 'mascot-core-elementor'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => '',
        'options' => mascot_core_ereco_disply_type_list_elementor(),
        'devices' => [ 'desktop', 'tablet', 'mobile' ],
        'selectors' => [
          '{{WRAPPER}} .tm-sc-simple-nav-menu ul li' => 'display: {{UNIT}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'list_text_alignment',
      [
        'label' => esc_html__( "List Alignment", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => mascot_core_ereco_elementor_text_alignment_list(),
        'devices' => [ 'desktop', 'tablet', 'mobile' ],
        'selectors' => [
          '{{WRAPPER}} .tm-sc-simple-nav-menu ul' => 'text-align: {{VALUE}};'
        ]
      ]
    );

    $this->add_control(
      'hide_first_icon',
      [
        'label' => esc_html__( "Hide First Icon", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => [
          '' => esc_html__( 'Default', 'mascot-core-elementor' ),
          'none'  => esc_html__( 'Hide', 'mascot-core-elementor' ),
          'block'  => esc_html__( 'Show', 'mascot-core-elementor' ),
        ],
        'selectors' => [
          '{{WRAPPER}} .tm-sc-simple-nav-menu li:first-child a:before' => 'display: {{VALUE}};',
        ]
      ]
    );
    $this->add_control(
      'hide_last_icon',
      [
        'label' => esc_html__( "Hide Last Icon", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => [
          '' => esc_html__( 'Default', 'mascot-core-elementor' ),
          'none'  => esc_html__( 'Hide', 'mascot-core-elementor' ),
          'block'  => esc_html__( 'Show', 'mascot-core-elementor' ),
        ],
        'selectors' => [
          '{{WRAPPER}} .tm-sc-simple-nav-menu li:last-child a:before' => 'display: {{VALUE}};',
        ]
      ]
    );
    $this->add_control(
      'hide_all_icons',
      [
        'label' => esc_html__( "Hide All Icon", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => [
          '' => esc_html__( 'Default', 'mascot-core-elementor' ),
          'none'  => esc_html__( 'Hide', 'mascot-core-elementor' ),
          'block'  => esc_html__( 'Show', 'mascot-core-elementor' ),
        ],
        'selectors' => [
          '{{WRAPPER}} .tm-sc-simple-nav-menu li a:before' => 'display: {{VALUE}};',
        ]
      ]
    );
    $this->end_controls_section();


    //Features
    $this->start_controls_section(
      'list_icon_options',
      [
        'label' => esc_html__( 'Icons Options', 'mascot-core-elementor' ),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'custom_icon_unicode',
      [
        'label' => esc_html__( "Custom Icon Unicode(Font Awesome 5)", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'description' => sprintf(__('Example: f111. Collect unicode from <a href="%s" target="_blank">FontAwesome 5</a>', 'mascot-core-elementor'), 'https://fontawesome.com/icons'),
        'selectors' => [
          '{{WRAPPER}} .tm-sc-simple-nav-menu li a:before' => 'content: "\{{VALUE}}";'
        ]
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'breadcrumb_bullet_typography',
        'label' => esc_html__( 'Bullet Typography', 'mascot-core-elementor' ),
        'selector' => '{{WRAPPER}} .tm-sc-simple-nav-menu li a:before',
      ]
    );


    $this->start_controls_tabs('tabs_bullet_style');
    $this->start_controls_tab(
      'tab_bullet_normal',
      [
        'label' => esc_html__('Normal', 'mascot-core-elementor'),
      ]
    );
    $this->add_control(
      'list_icon_color_options',
      [
        'label' => esc_html__( 'Color Options', 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::HEADING,
      ]
    );
    $this->add_control(
      'list_icon_color',
      [
        'label' => esc_html__( "Color", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tm-sc-simple-nav-menu li a:before' => 'color: {{VALUE}};'
        ]
      ]
    );
    $this->add_control(
      'list_icon_theme_colored',
      [
        'label' => esc_html__( "Make Icon Theme Colored", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => ereco_mascot_theme_color_list(),
        'default' => '',
        'selectors' => [
          '{{WRAPPER}} .tm-sc-simple-nav-menu li a:before' => 'color: var(--theme-color{{VALUE}});'
        ],
      ]
    );
    $this->add_control(
      'list_icon_bgcolor_options',
      [
        'label' => esc_html__( 'Background Color Options', 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::HEADING,
      ]
    );
    $this->add_control(
      'list_icon_bg_color',
      [
        'label' => esc_html__( "Background Color", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tm-sc-simple-nav-menu li a:before' => 'background-color: {{VALUE}};'
        ]
      ]
    );
    $this->add_control(
      'list_icon_bg_theme_colored',
      [
        'label' => esc_html__( "Make Icon Background Theme Colored", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => ereco_mascot_theme_color_list(),
        'default' => '',
        'selectors' => [
          '{{WRAPPER}} .tm-sc-simple-nav-menu li a:before' => 'background-color: var(--theme-color{{VALUE}});'
        ],
      ]
    );
    $this->add_control(
      'list_icon_pos_options',
      [
        'label' => esc_html__( 'Postion Options', 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::HEADING,
      ]
    );
    $this->add_responsive_control(
      'list_icon_pos_top',
      [
        'label' => esc_html__( "Top", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'devices' => [ 'desktop', 'tablet', 'mobile' ],
        'selectors' => [
          '{{WRAPPER}} .tm-sc-simple-nav-menu li a:before' => 'top: {{VALUE}};bottom:auto;'
        ]
      ]
    );
    $this->add_responsive_control(
      'list_icon_pos_right',
      [
        'label' => esc_html__( "Right", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'devices' => [ 'desktop', 'tablet', 'mobile' ],
        'selectors' => [
          '{{WRAPPER}} .tm-sc-simple-nav-menu li a:before' => 'right: {{VALUE}};left:auto;'
        ]
      ]
    );
    $this->add_responsive_control(
      'list_icon_pos_bottom',
      [
        'label' => esc_html__( "Bottom", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'devices' => [ 'desktop', 'tablet', 'mobile' ],
        'selectors' => [
          '{{WRAPPER}} .tm-sc-simple-nav-menu li a:before' => 'bottom: {{VALUE}};top:auto;'
        ]
      ]
    );
    $this->add_responsive_control(
      'list_icon_pos_left',
      [
        'label' => esc_html__( "Left", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'devices' => [ 'desktop', 'tablet', 'mobile' ],
        'selectors' => [
          '{{WRAPPER}} .tm-sc-simple-nav-menu li a:before' => 'left: {{VALUE}};right:auto;'
        ]
      ]
    );
    $this->add_control(
      'list_icon_dimension_options',
      [
        'label' => esc_html__( 'Dimension Options', 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::HEADING,
      ]
    );
    $this->add_responsive_control(
      'list_icon_width',
      [
        'label' => esc_html__( "Width", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'devices' => [ 'desktop', 'tablet', 'mobile' ],
        'selectors' => [
          '{{WRAPPER}} .tm-sc-simple-nav-menu li a:before' => 'width: {{VALUE}};'
        ]
      ]
    );
    $this->add_responsive_control(
      'list_icon_height',
      [
        'label' => esc_html__( "Height", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'devices' => [ 'desktop', 'tablet', 'mobile' ],
        'selectors' => [
          '{{WRAPPER}} .tm-sc-simple-nav-menu li a:before' => 'height: {{VALUE}};'
        ]
      ]
    );
    $this->add_control(
      'list_icon_border_options',
      [
        'label' => esc_html__( 'Border/Shadow Options', 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::HEADING,
      ]
    );
    $this->add_control(
      'list_icon_border_color',
      [
        'label' => esc_html__( "Border Color", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'condition' => [
          'list_bordered' => array('yes')
        ],
        'selectors' => [
          '{{WRAPPER}} .tm-sc-simple-nav-menu li a:before' => 'border-color: {{VALUE}};'
        ]
      ]
    );
    $this->add_responsive_control(
      'list_icon_border_radius',
      [
        'label' => esc_html__( "Border Radius", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'devices' => [ 'desktop', 'tablet', 'mobile' ],
        'selectors' => [
          '{{WRAPPER}} .tm-sc-simple-nav-menu li a:before' => 'border-radius: {{VALUE}};'
        ]
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Box_Shadow::get_type(),
      [
        'name' => 'list_icon_box_shadow',
        'label' => esc_html__( 'Box Shadow', 'mascot-core-elementor' ),
        'selector' => '{{WRAPPER}} .tm-sc-simple-nav-menu li a:before',
      ]
    );
    $this->end_controls_tab();


    $this->start_controls_tab(
      'tab_bullet_hover',
      [
        'label' => esc_html__('Hover', 'mascot-core-elementor'),
      ]
    );
    $this->add_control(
      'list_icon_color_options_hover',
      [
        'label' => esc_html__( 'Color Options', 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::HEADING,
      ]
    );
    $this->add_control(
      'list_icon_color_hover',
      [
        'label' => esc_html__( "Color", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tm-sc-simple-nav-menu li a:hover:before' => 'color: {{VALUE}};',
          '{{WRAPPER}} .tm-sc-simple-nav-menu li.current-menu-item a:before' => 'color: {{VALUE}};'
        ]
      ]
    );
    $this->add_control(
      'list_icon_theme_colored_hover',
      [
        'label' => esc_html__( "Make Icon Theme Colored", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => ereco_mascot_theme_color_list(),
        'default' => '',
        'selectors' => [
          '{{WRAPPER}} .tm-sc-simple-nav-menu li a:hover:before' => 'color: var(--theme-color{{VALUE}});',
          '{{WRAPPER}} .tm-sc-simple-nav-menu li.current-menu-item a:before' => 'color: var(--theme-color{{VALUE}});'
        ],
      ]
    );
    $this->add_control(
      'list_icon_bgcolor_options_hover',
      [
        'label' => esc_html__( 'Background Color Options', 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::HEADING,
      ]
    );
    $this->add_control(
      'list_icon_bg_color_hover',
      [
        'label' => esc_html__( "Background Color", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tm-sc-simple-nav-menu li a:hover:before' => 'background-color: {{VALUE}};',
          '{{WRAPPER}} .tm-sc-simple-nav-menu li.current-menu-item a:before' => 'background-color: {{VALUE}};'
        ]
      ]
    );
    $this->add_control(
      'list_icon_bg_theme_colored_hover',
      [
        'label' => esc_html__( "Make Icon Background Theme Colored", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => ereco_mascot_theme_color_list(),
        'default' => '',
        'selectors' => [
          '{{WRAPPER}} .tm-sc-simple-nav-menu li a:hover:before' => 'background-color: var(--theme-color{{VALUE}});',
          '{{WRAPPER}} .tm-sc-simple-nav-menu li.current-menu-item a:before' => 'background-color: var(--theme-color{{VALUE}});'
        ],
      ]
    );
    $this->add_control(
      'list_icon_pos_options_hover',
      [
        'label' => esc_html__( 'Postion Options', 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::HEADING,
      ]
    );
    $this->add_responsive_control(
      'list_icon_pos_top_hover',
      [
        'label' => esc_html__( "Top", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'devices' => [ 'desktop', 'tablet', 'mobile' ],
        'selectors' => [
          '{{WRAPPER}} .tm-sc-simple-nav-menu li a:hover:before' => 'top: {{VALUE}};bottom:auto;',
          '{{WRAPPER}} .tm-sc-simple-nav-menu li.current-menu-item a:before' => 'top: {{VALUE}};bottom:auto;'
        ]
      ]
    );
    $this->add_responsive_control(
      'list_icon_pos_right_hover',
      [
        'label' => esc_html__( "Right", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'devices' => [ 'desktop', 'tablet', 'mobile' ],
        'selectors' => [
          '{{WRAPPER}} .tm-sc-simple-nav-menu li a:hover:before' => 'right: {{VALUE}};left:auto;',
          '{{WRAPPER}} .tm-sc-simple-nav-menu li.current-menu-item a:before' => 'right: {{VALUE}};left:auto;'
        ]
      ]
    );
    $this->add_responsive_control(
      'list_icon_pos_bottom_hover',
      [
        'label' => esc_html__( "Bottom", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'devices' => [ 'desktop', 'tablet', 'mobile' ],
        'selectors' => [
          '{{WRAPPER}} .tm-sc-simple-nav-menu li a:hover:before' => 'bottom: {{VALUE}};top:auto;',
          '{{WRAPPER}} .tm-sc-simple-nav-menu li.current-menu-item a:before' => 'bottom: {{VALUE}};top:auto;'
        ]
      ]
    );
    $this->add_responsive_control(
      'list_icon_pos_left_hover',
      [
        'label' => esc_html__( "Left", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'devices' => [ 'desktop', 'tablet', 'mobile' ],
        'selectors' => [
          '{{WRAPPER}} .tm-sc-simple-nav-menu li a:hover:before' => 'left: {{VALUE}};right:auto;',
          '{{WRAPPER}} .tm-sc-simple-nav-menu li.current-menu-item a:before' => 'left: {{VALUE}};right:auto;'
        ]
      ]
    );
    $this->add_control(
      'list_icon_dimension_options_hover',
      [
        'label' => esc_html__( 'Dimension Options', 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::HEADING,
      ]
    );
    $this->add_responsive_control(
      'list_icon_width_hover',
      [
        'label' => esc_html__( "Width", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'devices' => [ 'desktop', 'tablet', 'mobile' ],
        'selectors' => [
          '{{WRAPPER}} .tm-sc-simple-nav-menu li a:hover:before' => 'width: {{VALUE}};',
          '{{WRAPPER}} .tm-sc-simple-nav-menu li.current-menu-item a:before' => 'width: {{VALUE}};'
        ]
      ]
    );
    $this->add_responsive_control(
      'list_icon_height_hover',
      [
        'label' => esc_html__( "Height", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'devices' => [ 'desktop', 'tablet', 'mobile' ],
        'selectors' => [
          '{{WRAPPER}} .tm-sc-simple-nav-menu li a:hover:before' => 'height: {{VALUE}};',
          '{{WRAPPER}} .tm-sc-simple-nav-menu li.current-menu-item a:before' => 'height: {{VALUE}};'
        ]
      ]
    );
    $this->add_control(
      'list_icon_border_options_hover',
      [
        'label' => esc_html__( 'Border/Shadow Options', 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::HEADING,
      ]
    );
    $this->add_control(
      'list_icon_border_color_hover',
      [
        'label' => esc_html__( "Border Color", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'condition' => [
          'list_bordered' => array('yes')
        ],
        'selectors' => [
          '{{WRAPPER}} .tm-sc-simple-nav-menu li a:hover:before' => 'border-color: {{VALUE}};',
          '{{WRAPPER}} .tm-sc-simple-nav-menu li.current-menu-item a:before' => 'border-color: {{VALUE}};'
        ]
      ]
    );
    $this->add_responsive_control(
      'list_icon_border_radius_hover',
      [
        'label' => esc_html__( "Border Radius", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'devices' => [ 'desktop', 'tablet', 'mobile' ],
        'selectors' => [
          '{{WRAPPER}} .tm-sc-simple-nav-menu li a:hover:before' => 'border-radius: {{VALUE}};',
          '{{WRAPPER}} .tm-sc-simple-nav-menu li.current-menu-item a:before' => 'border-radius: {{VALUE}};'
        ]
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Box_Shadow::get_type(),
      [
        'name' => 'list_icon_box_shadow_hover',
        'label' => esc_html__( 'Box Shadow', 'mascot-core-elementor' ),
        'selector' => '{{WRAPPER}} .tm-sc-simple-nav-menu li a:hover:before, {{WRAPPER}} .tm-sc-simple-nav-menu li.current-menu-item a:before',
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();
    $this->end_controls_section();




    //Features
    $this->start_controls_section(
      'list_styling',
      [
        'label' => esc_html__( 'List Styling', 'mascot-core-elementor' ),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'animate_icon_on_hover',
      [
        'label' => esc_html__( "Animate Icon on Hover", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => [
          '' => esc_html__( 'None', 'mascot-core-elementor' ),
          'rotate' => esc_html__( 'Rotate', 'mascot-core-elementor' ),
          'rotate-x' => esc_html__( 'Rotate X', 'mascot-core-elementor' ),
          'rotate-y' => esc_html__( 'Rotate Y', 'mascot-core-elementor' ),
          'scale'  => esc_html__( 'Scale', 'mascot-core-elementor' ),
          'translate'  => esc_html__( 'Translate', 'mascot-core-elementor' ),
          'translate-x'  => esc_html__( 'Translate X', 'mascot-core-elementor' ),
          'translate-y'  => esc_html__( 'Translate Y', 'mascot-core-elementor' ),
        ],
      ]
    );


    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'list__typography',
        'label' => esc_html__( 'Typography', 'mascot-core-elementor' ),
        'selector' => '{{WRAPPER}} .tm-sc-simple-nav-menu li, {{WRAPPER}} .tm-sc-simple-nav-menu li a',
      ]
    );



    $this->start_controls_tabs('tabs_list_style');

    $this->start_controls_tab(
      'tab_list_normal',
      [
        'label' => esc_html__('Normal', 'mascot-core-elementor'),
      ]
    );
    $this->add_control(
      'list_text_color_options',
      [
        'label' => esc_html__( 'Text Color Options', 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::HEADING,
      ]
    );
    $this->add_control(
      'list_text_color',
      [
        'label' => esc_html__( "Text Color", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tm-sc-simple-nav-menu li' => 'color: {{VALUE}};',
          '{{WRAPPER}} .tm-sc-simple-nav-menu li a' => 'color: {{VALUE}};'
        ]
      ]
    );
    $this->add_control(
      'list_text_theme_colored',
      [
        'label' => esc_html__( "Make Text Theme Colored", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => ereco_mascot_theme_color_list(),
        'default' => '',
        'selectors' => [
          '{{WRAPPER}} .tm-sc-simple-nav-menu li' => 'color: var(--theme-color{{VALUE}});',
          '{{WRAPPER}} .tm-sc-simple-nav-menu li a' => 'color: var(--theme-color{{VALUE}});'
        ],
      ]
    );

    $this->add_control(
      'bg_color_options',
      [
        'label' => esc_html__( 'Background Color Options', 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::HEADING,
      ]
    );
    $this->add_control(
      'bg_color',
      [
        'label' => esc_html__( "Background Color", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tm-sc-simple-nav-menu li a' => 'background-color: {{VALUE}};'
        ]
      ]
    );
    $this->add_control(
      'bg_theme_colored',
      [
        'label' => esc_html__( "Background Theme Colored", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => ereco_mascot_theme_color_list(),
        'default' => '',
        'selectors' => [
          '{{WRAPPER}} .tm-sc-simple-nav-menu li a' => 'background-color: var(--theme-color{{VALUE}});'
        ],
      ]
    );

    $this->add_control(
      'border_options',
      [
        'label' => esc_html__( 'Border/Shadow Options', 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::HEADING,
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Border::get_type(),
      [
        'name' => 'list_border',
        'label' => esc_html__( 'List Border', 'mascot-core-elementor' ),
        'selector' => '{{WRAPPER}} .tm-sc-simple-nav-menu li a',
      ]
    );
    $this->add_control(
      'list_border_color_default',
      [
        'label' => esc_html__( "Border Color", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'condition' => [
          'list_bordered' => array('yes')
        ],
        'selectors' => [
          '{{WRAPPER}} .tm-sc-simple-nav-menu li a' => 'border-color: {{VALUE}};'
        ]
      ]
    );
    $this->add_responsive_control(
      'border_radius',
      [
        'label' => esc_html__( "Border Radius", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'devices' => [ 'desktop', 'tablet', 'mobile' ],
        'selectors' => [
          '{{WRAPPER}} .tm-sc-simple-nav-menu li a' => 'border-radius: {{VALUE}};'
        ]
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Box_Shadow::get_type(),
      [
        'name' => 'box_shadow',
        'label' => esc_html__( 'Box Shadow', 'mascot-core-elementor' ),
        'selector' => '{{WRAPPER}} .tm-sc-simple-nav-menu li a',
      ]
    );
    $this->end_controls_tab();






    $this->start_controls_tab(
      'tab_list_hover',
      [
        'label' => esc_html__('Hover', 'mascot-core-elementor'),
      ]
    );
    $this->add_control(
      'list_text_color_options_hover',
      [
        'label' => esc_html__( 'Text Color Options', 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::HEADING,
      ]
    );
    $this->add_control(
      'list_text_color_hover',
      [
        'label' => esc_html__( "Text Color", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tm-sc-simple-nav-menu li a:hover' => 'color: {{VALUE}};',
          '{{WRAPPER}} .tm-sc-simple-nav-menu li.current-menu-item a' => 'color: {{VALUE}};'
        ]
      ]
    );
    $this->add_control(
      'list_text_theme_colored_hover',
      [
        'label' => esc_html__( "Make Text Theme Colored", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => ereco_mascot_theme_color_list(),
        'default' => '',
        'selectors' => [
          '{{WRAPPER}} .tm-sc-simple-nav-menu li a:hover' => 'color: var(--theme-color{{VALUE}});',
          '{{WRAPPER}} .tm-sc-simple-nav-menu li.current-menu-item a' => 'color: var(--theme-color{{VALUE}});'
        ],
      ]
    );

    $this->add_control(
      'bg_color_options_hover',
      [
        'label' => esc_html__( 'Background Color Options', 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::HEADING,
      ]
    );
    $this->add_control(
      'bg_color_hover',
      [
        'label' => esc_html__( "Background Color", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tm-sc-simple-nav-menu li a:hover' => 'background-color: {{VALUE}};',
          '{{WRAPPER}} .tm-sc-simple-nav-menu li.current-menu-item a' => 'background-color: {{VALUE}};'
        ]
      ]
    );
    $this->add_control(
      'bg_theme_colored_hover',
      [
        'label' => esc_html__( "Background Theme Colored", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => ereco_mascot_theme_color_list(),
        'default' => '',
        'selectors' => [
          '{{WRAPPER}} .tm-sc-simple-nav-menu li a:hover' => 'background-color: var(--theme-color{{VALUE}});',
          '{{WRAPPER}} .tm-sc-simple-nav-menu li.current-menu-item a' => 'background-color: var(--theme-color{{VALUE}});'
        ],
      ]
    );

    $this->add_control(
      'border_options_hover',
      [
        'label' => esc_html__( 'Border/Shadow Options', 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::HEADING,
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Border::get_type(),
      [
        'name' => 'list_border_hover',
        'label' => esc_html__( 'List Border', 'mascot-core-elementor' ),
        'selector' => '{{WRAPPER}} .tm-sc-simple-nav-menu li a:hover, {{WRAPPER}} .tm-sc-simple-nav-menu li.current-menu-item a',
      ]
    );
    $this->add_control(
      'list_border_color_default_hover',
      [
        'label' => esc_html__( "Border Color", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'condition' => [
          'list_bordered' => array('yes')
        ],
        'selectors' => [
          '{{WRAPPER}} .tm-sc-simple-nav-menu li a:hover' => 'border-color: {{VALUE}};',
          '{{WRAPPER}} .tm-sc-simple-nav-menu li.current-menu-item a' => 'border-color: {{VALUE}};'
        ]
      ]
    );
    $this->add_responsive_control(
      'border_radius_hover',
      [
        'label' => esc_html__( "Border Radius", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'devices' => [ 'desktop', 'tablet', 'mobile' ],
        'selectors' => [
          '{{WRAPPER}} .tm-sc-simple-nav-menu li a:hover' => 'border-radius: {{VALUE}};',
          '{{WRAPPER}} .tm-sc-simple-nav-menu li.current-menu-item a' => 'border-radius: {{VALUE}};'
        ]
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Box_Shadow::get_type(),
      [
        'name' => 'box_shadow_hover',
        'label' => esc_html__( 'Box Shadow', 'mascot-core-elementor' ),
        'selector' => '{{WRAPPER}} .tm-sc-simple-nav-menu li a:hover, {{WRAPPER}} .tm-sc-simple-nav-menu li.current-menu-item a',
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();
    $this->end_controls_section();






    //Features
    $this->start_controls_section(
      'list_spacing',
      [
        'label' => esc_html__( 'List Spacing', 'mascot-core-elementor' ),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_responsive_control(
      'list_margin',
      [
        'label' => esc_html__( 'Margin', 'mascot-core-elementor' ),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px', '%', 'em' ],
        'selectors' => [
          '{{WRAPPER}} .tm-sc-simple-nav-menu li a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'list_padding',
      [
        'label' => esc_html__( 'Padding', 'mascot-core-elementor' ),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px', '%', 'em' ],
        'selectors' => [
          '{{WRAPPER}} .tm-sc-simple-nav-menu li a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

  }

  /**
   * Render the widget output on the frontend.
   *
   * Written in PHP and used to generate the final HTML.
   *
   * @since 1.0.0
   *
   * @access protected
   */
  protected function render() {
    $settings = $this->get_settings_for_display();

    //classes
    $classes = array();
    $classes[] = $settings['custom_css_class'];
    if( $settings['split_nav']  && $settings['split_nav'] == 'yes') {
      $classes[] = 'split-nav-menu';
    }

    $settings['classes'] = $classes;

    //Produce HTML version by using the parameters (filename, variation, folder name, parameters, shortcode_ob_start)
    $html = mascot_core_ereco_elementor_get_shortcode_template_part( 'navigation-menu', null, 'navigation-menu/tpl', $settings, true );

    echo $html;
  }
}