<?php
namespace MascotCoreErecoElementor\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Hello World
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class TM_Elementor_Opening_Hours_Compressed extends Widget_Base {

  /**
   * Retrieve the widget name.
   *
   * @since 1.0.0
   *
   * @access public
   *
   * @return string Widget name.
   */
  public function get_name() {
		return 'tm-ele-opening-hours-compressed';
  }

  /**
   * Retrieve the widget title.
   *
   * @since 1.0.0
   *
   * @access public
   *
   * @return string Widget title.
   */
  public function get_title() {
		return esc_html__( 'Opening Hours Compressed', 'mascot-core-elementor' );
  }

  /**
   * Retrieve the widget icon.
   *
   * @since 1.0.0
   *
   * @access public
   *
   * @return string Widget icon.
   */
  public function get_icon() {
		return 'tm-elementor-widget-icon';
  }

  /**
   * Retrieve the list of categories the widget belongs to.
   *
   * Used to determine where to display the widget in the editor.
   *
   * Note that currently Elementor supports only one category.
   * When multiple categories passed, Elementor uses the first one.
   *
   * @since 1.0.0
   *
   * @access public
   *
   * @return array Widget categories.
   */
  public function get_categories() {
		return [ 'tm' ];
  }

  /**
   * Retrieve the list of scripts the widget depended on.
   *
   * Used to set scripts dependencies required to run the widget.
   *
   * @since 1.0.0
   *
   * @access public
   *
   * @return array Widget scripts dependencies.
   */
  public function get_script_depends() {
		return [ 'mascot-core-hellojs' ];
  }

  /**
   * Register the widget controls.
   *
   * Adds different input fields to allow the user to change and customize the widget settings.
   *
   * @since 1.0.0
   *
   * @access protected
   */
  protected function _register_controls() {

	$this->start_controls_section(
		'general',
		[
			'label' => esc_html__( 'General', 'mascot-core-elementor' ),
			'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
		]
	);
	$this->add_control(
		'custom_css_class',
		[
			'label' => esc_html__( "Custom CSS class", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::TEXT,
			"description" => esc_html__( 'To style particular content element.', 'mascot-core-elementor' ),
		]
	);
	$this->add_control(
		'border_color',
		[
			'label' => esc_html__( "Border Color", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'options' => [
				'border-light' => esc_html__( 'Border Light', 'mascot-core-elementor' ),
				'border-dark' => esc_html__( 'Border Dark', 'mascot-core-elementor' ),
			],
			'default' => 'final-countdown-advanced-coupon'
		]
	);

	//day1
	$this->add_control(
		'day_1',
		[
			'label' => esc_html__( "Day 1:", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => 'Monday - Friday'
		]
	);
	$this->add_control(
		'day_1_time',
		[
			'label' => esc_html__( "Time for Day 1:", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => '9:00 - 17:00'
		]
	);

	//day2
	$this->add_control(
		'day_2',
		[
			'label' => esc_html__( "Day 2:", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => 'Saturday'
		]
	);
	$this->add_control(
		'day_2_time',
		[
			'label' => esc_html__( "Time for Day 2:", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => '9.00 - 16.00'
		]
	);

	//day3
	$this->add_control(
		'day_3',
		[
			'label' => esc_html__( "Day 3:", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => 'Sunday'
		]
	);
	$this->add_control(
		'day_3_time',
		[
			'label' => esc_html__( "Time for Day 3:", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => 'Closed'
		]
	);

	//day4
	$this->add_control(
		'day_4',
		[
			'label' => esc_html__( "Day 4:", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => ''
		]
	);
	$this->add_control(
		'day_4_time',
		[
			'label' => esc_html__( "Time for Day 4:", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => ''
		]
	);

	//day5
	$this->add_control(
		'day_5',
		[
			'label' => esc_html__( "Day 5:", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => ''
		]
	);
	$this->add_control(
		'day_5_time',
		[
			'label' => esc_html__( "Time for Day 5:", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => ''
		]
	);

	//day6
	$this->add_control(
		'day_6',
		[
			'label' => esc_html__( "Day 6:", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => ''
		]
	);
	$this->add_control(
		'day_6_time',
		[
			'label' => esc_html__( "Time for Day 6:", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => ''
		]
	);

	//day7
	$this->add_control(
		'day_7',
		[
			'label' => esc_html__( "Day 7:", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => ''
		]
	);
	$this->add_control(
		'day_7_time',
		[
			'label' => esc_html__( "Time for Day 7:", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => ''
		]
	);

	$this->end_controls_section();



  }

  /**
   * Render the widget output on the frontend.
   *
   * Written in PHP and used to generate the final HTML.
   *
   * @since 1.0.0
   *
   * @access protected
   */
  protected function render() {
	$settings = $this->get_settings_for_display();
	
	//classes
	$classes = array();
	$classes[] = $settings['custom_css_class'];
	$settings['classes'] = $classes;

	//Produce HTML version by using the parameters (filename, variation, folder name, parameters, shortcode_ob_start)
	$html = mascot_core_ereco_elementor_get_shortcode_template_part( 'opening-hours-compressed', null, 'opening-hours-compressed/tpl', $settings, true );

	echo $html;
  }
}
