<?php
namespace MascotCoreErecoElementor\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Hello World
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class TM_Elementor_Tabs extends Widget_Base {

	/**
	 * Retrieve the widget name.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'tm-ele-tabs';
	}

	/**
	 * Retrieve the widget title.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Tabs', 'mascot-core-elementor' );
	}

	/**
	 * Retrieve the widget icon.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'tm-elementor-widget-icon';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * Note that currently Elementor supports only one category.
	 * When multiple categories passed, Elementor uses the first one.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'tm' ];
	}

	/**
	 * Retrieve the list of scripts the widget depended on.
	 *
	 * Used to set scripts dependencies required to run the widget.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget scripts dependencies.
	 */
	public function get_script_depends() {
		return [ 'mascot-core-hellojs' ];
	}

	/**
	 * Register the widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function _register_controls() {

		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'mascot-core-elementor' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'custom_css_class',
			[
				'label' => esc_html__( "Custom CSS class", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::TEXT,
			]
		);
		$this->add_control(
			'display_type', [
				'label' => esc_html__( "Behavior", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'tabs' =>  esc_html__( 'Tabs', 'mascot-core-elementor' ),
					'toggle'  =>  esc_html__( 'Toggle', 'mascot-core-elementor' ),
				],
				'default' => 'tabs'
			]
		);
		$this->add_control(
			'design', [
				'label' => esc_html__( "Design", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'' =>  esc_html__( 'Basic', 'mascot-core-elementor' ),
					'tabs-classic'  =>  esc_html__( 'Classic', 'mascot-core-elementor' ),
					'tabs-gradient'  =>  esc_html__( 'Gradient', 'mascot-core-elementor' ),
				],
				'default' => ''
			]
		);
		$this->add_control(
			'theme-color', [
				'label' => esc_html__( "Theme Color", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'' =>  esc_html__( 'Default', 'mascot-core-elementor' ),
					'tabs-theme-colored1'  =>  esc_html__( 'Theme Color 1', 'mascot-core-elementor' ),
					'tabs-theme-colored2'  =>  esc_html__( 'Theme Color 2', 'mascot-core-elementor' ),
					'tabs-theme-colored3'  =>  esc_html__( 'Theme Color 3', 'mascot-core-elementor' ),
					'tabs-theme-colored4'  =>  esc_html__( 'Theme Color 4', 'mascot-core-elementor' ),
				],
				'default' => ''
			]
		);
		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'title',
			[
				'label' => esc_html__( "Title", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::TEXT,
			]
		);
		$repeater->add_control(
			'expand',
			[
				'label' => esc_html__( "Make Expand?", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'no'
			]
		);
		$repeater->add_control(
			'content',
			[
				'label' => esc_html__( "Description", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::WYSIWYG,
				'default' => esc_html__( "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.", 'mascot-core-elementor' ),
			]
		);


		$this->add_control(
			'tabs_items',
			[
				'label' => esc_html__( "Item", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
			]
		);
		$this->end_controls_section();




		$this->start_controls_section(
			'title_options',
			[
				'label' => esc_html__( 'Title Options', 'mascot-core-elementor' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => esc_html__( 'Typography', 'mascot-core-elementor' ),
				'selector' => '{{WRAPPER}} .nav-tabs .nav-item .nav-link',
			]
		);
		$this->add_control(
			'title_padding',
			[
				'label' => esc_html__( 'Padding', 'mascot-core-elementor' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .nav-tabs .nav-item .nav-link' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();
	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function render() {
		$html = '';
		$settings = $this->get_settings_for_display();
		
		//classes
		$classes = array();
		$classes[] = 'tm-tabs';
		$classes[] = $settings['custom_css_class'];
		$classes[] = $settings['display_type'];
		$classes[] = $settings['design'];
		$classes[] = $settings['theme-color'];

		$settings['classes'] = $classes;

		$settings['holder_id'] = ereco_mascot_get_isotope_holder_ID('tabs');
		$settings['rand'] = rand(10,100);
	?>
		<div id="<?php echo esc_attr( $settings['holder_id'] ) ?>" class="<?php echo esc_attr(implode(' ', $classes)); ?>">
		<?php
			if ( $settings['tabs_items'] ) {
				$tab_id_list = array();
				$i=1;
		?>
			<ul class="nav nav-tabs" id="myTab-<?php echo esc_attr($settings['holder_id']); ?>" role="tablist">
			<?php
				foreach (  $settings['tabs_items'] as $item ) {
					$tab_id_list[$i] = 'tab-'.$settings['holder_id'].'-'.$i;
					$settings['title'] = $item['title'];
					$settings['expand'] = $item['expand'];
					$settings['i'] = $i;
					$settings['tab_id_list'] = $tab_id_list;
					//Produce HTML version by using the parameters (filename, variation, folder name, parameters, shortcode_ob_start)
					$html .= mascot_core_ereco_elementor_get_shortcode_template_part( 'tabs', null, 'tabs/tpl', $settings, false );
					$i++;
				}
			?>
			</ul>
		<?php
			}
		?>


		<?php
			if ( $settings['tabs_items'] ) {
				$tab_id_list2 = array();
				$i=1;
		?>
			<div class="tab-content" id="myTabContent-<?php echo esc_attr($settings['holder_id']); ?>">
			<?php
				foreach (  $settings['tabs_items'] as $item ) {
					$tab_id_list2[$i] = 'tab-'.$settings['holder_id'].'-'.$i;
					$settings['expand'] = $item['expand'];
					$settings['i'] = $i;
					$settings['content'] = $item['content'];
					$settings['tab_id_list2'] = $tab_id_list2;
					//Produce HTML version by using the parameters (filename, variation, folder name, parameters, shortcode_ob_start)
					$html .= mascot_core_ereco_elementor_get_shortcode_template_part( 'content', null, 'tabs/tpl', $settings, false );
					$i++;
				}
			?>
			</div>
		<?php
			}
		?>




		<?php
			/*if ( $settings['tabs_items'] ) { 
				$tab_id_list = array();
				$i=1;
				foreach (  $settings['tabs_items'] as $item ) {
					$tab_id_list[$i] = 'tab-'.$settings['holder_id'].'-'.$i;
					$i++;
				}
				$settings['tab_id_list'] = $tab_id_list;
				//Produce HTML version by using the parameters (filename, variation, folder name, parameters, shortcode_ob_start)
				$html .= mascot_core_ereco_elementor_get_shortcode_template_part( $settings['display_type'], null, 'tabs/tpl', $settings, true );
			} 
			echo $html;*/
		?>
		</div>
	<?php
	}
}