
<?php if ( $the_query->have_posts() ) : ?>
	<div class="tm-sc-tribe-events tm-sc-tribe-events-current-theme <?php echo esc_attr(implode(' ', $classes)); ?>">
		<!-- the loop -->
		<?php while ( $the_query->have_posts() ) : $the_query->the_post(); ?>
		<div id="post-<?php the_ID() ?>" class="event d-flex align-items-center <?php tribe_events_event_classes() ?>">
			
			<?php if ( has_post_thumbnail() && $show_thumb == 'yes' ) : ?>
			<div class="event-thumb">
				<?php echo tribe_event_featured_image( null, $feature_thumb_image_size ); ?>
				<div class="event-date">
					<span class="day"><?php echo tribe_get_start_date( get_the_ID(), false, 'd' ) ?></span>
					<span class="month"><?php echo tribe_get_start_date( get_the_ID(), false, 'M' ) ?></span>
					<!-- <span class="year"><?php echo tribe_get_start_date( get_the_ID(), false, 'Y' ) ?></span> -->
				</div>
			</div>
			<?php endif; ?>
			<div class="event-text">
        <div class="event-date">
          <?php if ( in_array('show-full-date', $meta_options) ) : ?>
          <div class="each-meta event-schedule-details">
            <i class="fa fa-clock-o"></i> <?php echo tribe_events_event_schedule_details() ?>
          </div>
          <?php endif; ?>

          <?php if ( in_array('show-time', $meta_options) ) : ?>
          <div class="each-meta event-schedule-details">
            <i class="fa fa-clock-o"></i> <?php echo tribe_get_start_date(null, false, get_option( 'time_format' ) ) . tribe_get_option( 'timeRangeSeparator', ' - ' ) . tribe_get_end_date(null, false, get_option( 'time_format' ) ) ;?>
          </div>
          <?php endif; ?>
        </div>

				<?php if ( $show_title == 'yes' ) : ?>
				<<?php echo esc_attr( $title_tag );?> class="event-title">
					<a href="<?php echo esc_url( tribe_get_event_link() ); ?>" title="<?php the_title_attribute(); ?>">
						<?php the_title() ?>
					</a>
				</<?php echo esc_attr( $title_tag );?>>
				<?php endif; ?>

				<?php if ( in_array('show-venue', $meta_options) ) { ?>
				<?php $venue_details = tribe_get_venue_details(); if ( $venue_details ) { ?>
				<div class="event-venue">
					<?php echo esc_html( $venue_details['linked_name'] ); ?>
				</div>
				<?php } ?>
				<?php } ?>

			</div>
			<div class="clearfix"></div>
		</div>
		<?php endwhile; ?>
		<!-- end of the loop -->
	</div>
	<?php wp_reset_postdata(); ?>
		
	<?php mascot_core_ereco_elementor_get_shortcode_template_part( 'show-more-btn', null, 'tribe-events/tpl', $params, false ); ?>

<?php else : ?>
	<?php ereco_mascot_no_posts_match_criteria_text(); ?>
<?php endif; ?>