<?php
namespace MascotCoreErecoElementor\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Hello World
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class TM_Elementor_Tribe_Events extends Widget_Base {

	/**
	 * Retrieve the widget name.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'tm-ele-tribe-events';
	}

	/**
	 * Retrieve the widget title.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Tribe Events', 'mascot-core-elementor' );
	}

	/**
	 * Retrieve the widget icon.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'tm-elementor-widget-icon';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * Note that currently Elementor supports only one category.
	 * When multiple categories passed, Elementor uses the first one.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'tm' ];
	}

	/**
	 * Retrieve the list of scripts the widget depended on.
	 *
	 * Used to set scripts dependencies required to run the widget.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget scripts dependencies.
	 */
	public function get_script_depends() {
		return [ 'mascot-core-hellojs' ];
	}

	/**
	 * Register the widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function _register_controls() {
		$categories_array = ereco_mascot_category_list_array( 'tribe_events_cat' );
		$orderby_parameters_list1 = mascot_core_ereco_orderby_parameters_list();
		$orderby_parameters_list2 = array(
		);
		$orderby_parameters_list = array_merge( $orderby_parameters_list2, $orderby_parameters_list1 );

		$this->start_controls_section(
				'general',
				[
						'label' => esc_html__( 'General', 'mascot-core-elementor' ),
						'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
				]
		);
		$this->add_control(
			'custom_css_class', [
				'label' => esc_html__( "Custom CSS class", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::TEXT,
			]
		);
		$this->add_control(
			'display_type', [
				'label' => esc_html__( "Display Type", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'list-vertical'	=>	esc_html__( 'List - Vertical ', 'mascot-core-elementor' ),
					'list-vertical-slide'	=>	esc_html__( 'List - Vertical Slide', 'mascot-core-elementor' ),
					'grid'	=>	esc_html__( 'Grid', 'mascot-core-elementor' ),
					'masonry'	=>	esc_html__( 'Masonry', 'mascot-core-elementor' ),
					'carousel'	=>	esc_html__( 'Carousel', 'mascot-core-elementor' ),
					'fullwidth'	=>	esc_html__( 'Fullwidth', 'mascot-core-elementor' ),
					'current-theme'	=>	esc_html__( 'Current Theme Style', 'mascot-core-elementor' )
				],
				'default' => 'grid'
			]
		);
		$this->add_control(
			'columns', [
				'label' => esc_html__( "Columns Layout", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'1'  =>  '1',
					'2'  =>  '2',
					'3'  =>  '3',
					'4'  =>  '4',
					'5'  =>  '5',
					'6'  =>  '6',
				],
				'default' => '3',
				'condition' => [
					'display_type' => array('grid', 'masonry', 'carousel')
				]
			]
		);
		$this->add_control(
			'gutter',
			[
				'label' => esc_html__( "Gutter", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => mascot_core_ereco_isotope_gutter_list_elementor(),
				'default' => 'gutter-15',
				'condition' => [
					'display_type' => array('grid', 'masonry', 'masonry-tiles')
				]
			]
		);

		$this->end_controls_section();



		//List - Vertical Options
		$this->start_controls_section(
			'list_vertical_options', [
				'label' => esc_html__( 'List - Vertical Options', 'mascot-core-elementor' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
				'condition' => [
					'display_type' => array('list-vertical', 'list-vertical-slide')
				]
			]
		);
		$this->add_control(
			'vertical_show_left_thumb', [
				'label' => esc_html__( "Show Left Thumbnail", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'no'
			]
		);
		$this->add_control(
			'vertical_left_thumb_image_size', [
				'label' => esc_html__( "Left Thumbnail Image Size", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => mascot_core_ereco_elementor_get_available_image_sizes(),
				'default' => 'ereco_mascot_square_120',
				'condition' => [
					'vertical_show_left_thumb' => array('yes')
				]
			]
		);
		$this->add_control(
			'vertical_show_left_date', [
				'label' => esc_html__( "Show Left Date", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'yes'
			]
		);
		$this->add_control(
			'vertical_left_date_block_theme_colored',
			[
				'label' => esc_html__( "Make Left Block Theme Colored?", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => ereco_mascot_theme_color_list(),
				'default' => '',
				'condition' => [
					'vertical_show_left_date' => array('yes')
				]
			]
		);
		$this->add_control(
			'vertical_left_date_block_size', [
				'label' => esc_html__( "Left Block Style", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'left-block-big'	=>	esc_html__( 'Default - Big Size', 'mascot-core-elementor' ),
					'left-block-medium'	=>	esc_html__( 'Medium Size', 'mascot-core-elementor' ),
					'left-block-small'	=>	esc_html__( 'Small Size', 'mascot-core-elementor' ),
				],
				'default' => 'left-block-big'
			]
		);
		$this->add_control(
			'vertical_left_date_block_border', [
				'label' => esc_html__( "Make Left Block Bordered?", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
			]
		);
		$this->end_controls_section();



		//List - Vertical Slide Options
		$this->start_controls_section(
			'list_vertical_slide_options', [
				'label' => esc_html__( 'List - Vertical Slide Options', 'mascot-core-elementor' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
				'condition' => [
					'display_type' => array('list-vertical-slide')
				]
			]
		);
		$this->add_control(
			'vertical_slide_minslides', [
				'label' => esc_html__( "Number of Minimum Sliding Items", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '3'
			]
		);
		$this->add_control(
			'vertical_slide_autoplay', [
				'label' => esc_html__( "Autoplay", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'yes'
			]
		);
		$this->add_control(
			'vertical_slide_show_navigation', [
				'label' => esc_html__( "Show Navigation Arrow", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'yes'
			]
		);
		$this->add_control(
			'vertical_slide_navigation_arrow_position', [
				'label' => esc_html__( "Navigation Arrow Position", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'bottom'	=>	esc_html__( 'Bottom', 'mascot-core-elementor' ),
					'top'	=>	esc_html__( 'Top', 'mascot-core-elementor' )
				],
				'default' => 'top',
				'condition' => [
					'vertical_slide_show_navigation' => array('yes')
				]
			]
		);
		$this->end_controls_section();











		//Carousel Options
		$this->start_controls_section(
			'carousel_options', [
				'label' => esc_html__( 'Carousel Options', 'mascot-core-elementor' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
				'condition' => [
					'display_type' => array('carousel')
				]
			]
		);
		mascot_core_ereco_elementor_get_owl_carousel_arraylist( $this, 1, '', array('display_type' => array('carousel') ) );
		mascot_core_ereco_elementor_get_owl_carousel_arraylist( $this, 2, '', array('display_type' => array('carousel') ) );
		mascot_core_ereco_elementor_get_owl_carousel_arraylist( $this, 3, '', array('display_type' => array('carousel') ) );
		mascot_core_ereco_elementor_get_owl_carousel_arraylist( $this, 4, '', array('display_type' => array('carousel') ) );
		mascot_core_ereco_elementor_get_owl_carousel_arraylist( $this, 5, '', array('display_type' => array('carousel') ) );
		mascot_core_ereco_elementor_get_owl_carousel_arraylist( $this, 6, '', array('display_type' => array('carousel') ) );
		mascot_core_ereco_elementor_get_owl_carousel_arraylist( $this, 7, '', array('display_type' => array('carousel') ) );
		mascot_core_ereco_elementor_get_owl_carousel_arraylist( $this, 8, '', array('display_type' => array('carousel') ) );
		mascot_core_ereco_elementor_get_owl_carousel_arraylist( $this, 9, '', array('display_type' => array('carousel') ) );
		mascot_core_ereco_elementor_get_owl_carousel_arraylist( $this, 10, '', array('display_type' => array('carousel') ) );
		mascot_core_ereco_elementor_get_owl_carousel_arraylist( $this, 11, '', array('display_type' => array('carousel') ) );
		mascot_core_ereco_elementor_get_owl_carousel_arraylist( $this, 12, '', array('display_type' => array('carousel') ) );
		mascot_core_ereco_elementor_get_owl_carousel_arraylist( $this, 13, '', array('display_type' => array('carousel') ) );
		mascot_core_ereco_elementor_get_owl_carousel_arraylist( $this, 14, '', array('display_type' => array('carousel') ) );
		$this->end_controls_section();

		//Carousel Arrow Navigation Options
		$this->start_controls_section(
			'carousel_arrow_nav_options', [
				'label' => esc_html__( 'Carousel Arrow Navigation Options', 'mascot-core-elementor' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 1, '', array('display_type' => array('carousel') ) );
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 2, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 3, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 4, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 5, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 6, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 7, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 8, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 9, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 10, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 11, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 12, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 13, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 14, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 15, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 16, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 17, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 18, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 19, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 20, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 21, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 22, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 23, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 24, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 25, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 26, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 27, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 28, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 29, '');
		$this->end_controls_section();




		

		//Carousel Arrow Navigation Options
		$this->start_controls_section(
			'carousel_arrow_nav_bs5_breakpoints_options', [
				'label' => esc_html__( 'Carousel Arrow Nav Bootstrap5 Breakpoints', 'mascot-core-elementor' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		mascot_core_ereco_elementor_get_owl_carousel_nav_bs5_breakpoints_arraylist( $this, 1, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_bs5_breakpoints_arraylist( $this, 2, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_bs5_breakpoints_arraylist( $this, 3, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_bs5_breakpoints_arraylist( $this, 4, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_bs5_breakpoints_arraylist( $this, 5, '');

		mascot_core_ereco_elementor_get_owl_carousel_nav_bs5_breakpoints_arraylist( $this, 6, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_bs5_breakpoints_arraylist( $this, 7, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_bs5_breakpoints_arraylist( $this, 8, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_bs5_breakpoints_arraylist( $this, 9, '');
		mascot_core_ereco_elementor_get_owl_carousel_nav_bs5_breakpoints_arraylist( $this, 10, '');
		$this->end_controls_section();






		//Carousel Bullets/Dots Options
		$this->start_controls_section(
			'carousel_arrow_dots_options', [
				'label' => esc_html__( 'Carousel Bullets/Dots Options', 'mascot-core-elementor' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 1, '', array('display_type' => array('carousel') ) );
		mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 2, '');
		mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 3, '');
		mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 4, '');
		mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 5, '');
		mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 6, '');
		mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 7, '');
		mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 8, '');
		mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 9, '');
		mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 10, '');
		mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 11, '');
		mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 12, '');
		mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 13, '');
		mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 14, '');
		mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 15, '');
		mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 16, '');
		mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 17, '');
		$this->end_controls_section();




		$this->start_controls_section(
			'query', [
				'label' => esc_html__( 'Query', 'mascot-core-elementor' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'total_items', [
				'label' => esc_html__( "Number of Items to Query from Database", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				"description" => esc_html__( "How many items do you wish to show? Put -1 to show all. Default 3", 'mascot-core-elementor' ),
				'default' => '3'
			]
		);
		$this->add_control(
			'category', [
				'label' => esc_html__( "Category", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => $categories_array,
			]
		);
		$this->add_control(
			'order_by', [
				'label' => esc_html__( "Order By", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => $orderby_parameters_list,
			]
		);
		$this->add_control(
			'order', [
				'label' => esc_html__( "Order", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'DESC' => esc_html__( 'Descending', 'mascot-core-elementor' ),
					'ASC' => esc_html__( 'Ascending', 'mascot-core-elementor' ),
				],
			]
		);

		$this->end_controls_section();




		//Category Filter
		$this->start_controls_section(
			'cat_filter_section', [
				'label' => esc_html__( 'Category Filter', 'mascot-core-elementor' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		mascot_core_ereco_elementor_get_cat_filter_arraylist( $this, 1, array('display_type' => array('grid', 'masonry', 'carousel') ) );
		mascot_core_ereco_elementor_get_cat_filter_arraylist( $this, 2 );
		mascot_core_ereco_elementor_get_cat_filter_arraylist( $this, 3 );
		mascot_core_ereco_elementor_get_cat_filter_arraylist( $this, 4 );

		$this->end_controls_section();








		//Content Options
		$this->start_controls_section(
			'content',
			[
				'label' => esc_html__( 'Content', 'mascot-core-elementor' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'show_thumb', [
				'label' => esc_html__( "Show Thumbnail", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'yes',
				'condition' => [
					'display_type' => array('grid', 'masonry', 'carousel', 'current-theme')
				]
			]
		);
		$this->add_control(
			'feature_thumb_image_size', [
				'label' => esc_html__( "Thumbnail Image Size", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => mascot_core_ereco_elementor_get_available_image_sizes(),
				'default' => 'post-thumbnail',
				'condition' => [
					'show_thumb' => array('yes'),
					'display_type' => array('grid', 'masonry', 'carousel', 'current-theme')
				]
			]
		);
		$this->add_control(
			'show_title',
			[
				'label' => esc_html__( "Show Title", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'yes'
			]
		);
		$this->add_control(
			'title_tag',
			[
				'label' => esc_html__( "Title Tag", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => mascot_core_ereco_heading_tag_list(),
				'default' => 'h5',
				'condition' => [
					'show_title' => array('yes')
				]
			]
		);
		$this->add_control(
			'show_excerpt',
			[
				'label' => esc_html__( "Show Excerpt", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'yes'
			]
		);
		$this->add_control(
			'excerpt_length', [
				'label' => esc_html__( "Excerpt Length", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				"description" => esc_html__( "Number of words to display. Example: 25. Default all", 'mascot-core-elementor' ),
				'condition' => [
					'show_excerpt' => array('yes')
				]
			]
		);
		$this->add_control(
			'show_meta',
			[
				'label' => esc_html__( "Show Post Meta", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'yes'
			]
		);
		$this->add_control(
			'meta_options',
			[
				'label' => esc_html__( "Choose Meta", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'options' => [
					'show-date-over-image'	=>	esc_html__( 'Show Date Over Image', 'mascot-core-elementor' ),
					'show-full-date'	=>	esc_html__( 'Show Full Date & Time', 'mascot-core-elementor' ),
					'show-time'	=>	esc_html__( 'Show Only Time', 'mascot-core-elementor' ),
					'show-venue'	=>	esc_html__( 'Show Venue', 'mascot-core-elementor' ),
					'show-organizer'	=>	esc_html__( 'Show Organizer', 'mascot-core-elementor' ),
				],
				'multiple' => true,
				'description' => esc_html__('Enable/Disabling this option will show/hide each Post Meta', 'mascot-core-elementor'),
				'default' => [ 'show-date-over-image', 'show-time' ],
				'condition' => [
					'show_meta' => array('yes')
				]
			]
		);
		$this->end_controls_section();



		$this->start_controls_section(
			'button_options', [
					'label' => esc_html__( 'Button Options', 'mascot-core-elementor' ),
					'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		mascot_core_ereco_elementor_get_viewdetails_button_arraylist($this, 1);
		mascot_core_ereco_elementor_get_viewdetails_button_arraylist($this, 2);
		mascot_core_ereco_elementor_get_button_arraylist($this, 1);
		mascot_core_ereco_elementor_get_button_arraylist($this, 2);
		mascot_core_ereco_elementor_get_button_arraylist($this, 3);
		mascot_core_ereco_elementor_get_button_arraylist($this, 4);
		mascot_core_ereco_elementor_get_button_arraylist($this, 5);
		mascot_core_ereco_elementor_get_button_arraylist($this, 6);
		mascot_core_ereco_elementor_get_button_arraylist($this, 7);
		mascot_core_ereco_elementor_get_button_arraylist($this, 8);
		mascot_core_ereco_elementor_get_button_arraylist($this, 9);
		mascot_core_ereco_elementor_get_button_arraylist($this, 10);
		mascot_core_ereco_elementor_get_button_arraylist($this, 11);
		mascot_core_ereco_elementor_get_button_arraylist($this, 12);

		$this->end_controls_section();






		$this->start_controls_section(
			'loadmore_button_options', [
					'label' => esc_html__( 'Loadmore Button Options', 'mascot-core-elementor' ),
					'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		mascot_core_ereco_elementor_get_viewdetails_button_arraylist($this, 1,  esc_html__( "Load More", 'mascot-core-elementor' ), 'loadmore_');
		mascot_core_ereco_elementor_get_viewdetails_button_arraylist($this, 2,  esc_html__( "Load More", 'mascot-core-elementor' ), 'loadmore_');
		mascot_core_ereco_elementor_get_button_arraylist($this, 1, 'loadmore_');
		mascot_core_ereco_elementor_get_button_arraylist($this, 2, 'loadmore_');
		mascot_core_ereco_elementor_get_button_arraylist($this, 3, 'loadmore_');
		mascot_core_ereco_elementor_get_button_arraylist($this, 4, 'loadmore_');
		mascot_core_ereco_elementor_get_button_arraylist($this, 5, 'loadmore_');
		mascot_core_ereco_elementor_get_button_arraylist($this, 6, 'loadmore_');
		mascot_core_ereco_elementor_get_button_arraylist($this, 7, 'loadmore_');
		mascot_core_ereco_elementor_get_button_arraylist($this, 8, 'loadmore_');
		mascot_core_ereco_elementor_get_button_arraylist($this, 9, 'loadmore_');
		mascot_core_ereco_elementor_get_button_arraylist($this, 10, 'loadmore_');
		mascot_core_ereco_elementor_get_button_arraylist($this, 11, 'loadmore_');
		mascot_core_ereco_elementor_get_button_arraylist($this, 12, 'loadmore_');

		$this->end_controls_section();
	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		$class_instance =  '';

		$settings['holder_id'] = ereco_mascot_get_isotope_holder_ID('events');

		if (  $settings['loadmore_show_view_details_button'] === 'yes' ) {
			$holder_id = str_replace('-', '_', $settings['holder_id']);
			$settings['holder_id_underline'] = $holder_id;
			$settings['wp_ajax_load_for_cpt'] = 'tribe_events';

			wp_localize_script( 'ereco-custom', 'tm_loadmore_params_'.$holder_id, array(
				'ajaxurl' => site_url() . '/wp-admin/admin-ajax.php',

				'class_instance' => $class_instance,
				'params' => $settings,

				'current_page' => get_query_var( 'paged' ) ? get_query_var('paged') : 1,
			) );
			wp_enqueue_script( 'ereco-custom' );
		}


		return mascot_core_ereco_elementor_sc_tribe_events_render_output( $class_instance, $settings );

	}
}



if(!function_exists('mascot_core_ereco_elementor_sc_tribe_events_render_output')) {
	/**
	 * Output render
	 */
	function mascot_core_ereco_elementor_sc_tribe_events_render_output( $class_instance, $settings ) {
		$new_cpt_class = $class_instance;
		$paged = isset($settings['paged']) ? $settings['paged'] : '';

		//query args
		$args = array(
			'post_type' => 'tribe_events',
			'orderby' => $settings['order_by'],
			'order' => $settings['order'],
			'posts_per_page' => $settings['total_items'],
			'paged' => $paged,
		);

		//if category selected
		if( ! empty( $settings['category'] ) ) {
			$args['tax_query'] = array(
				array(
					'taxonomy' => 'tribe_events_cat',
					'field'	=> 'slug',
					'terms'	=> explode(',', $settings['category']),
				)
			);
		}

		$the_query = new \WP_Query( $args );
		$settings['the_query'] = $the_query;
		
		if ( !$the_query->have_posts() && isset( $settings['from_loadmore_ajax_handler'] ) && $settings['from_loadmore_ajax_handler'] === true ) {
			return;
		}


		//classes
		$classes = array();
		if( $settings['display_type'] == 'list-vertical-slide' && $settings['vertical_slide_show_navigation'] != 'false' ) {
			$classes[] = 'has-nav-arrow nav-arrow-position-' . $settings['vertical_slide_navigation_arrow_position'];
		}
		$classes[] = $settings['custom_css_class'];
		$settings['classes'] = $classes;

		//button classes
		$settings['btn_classes'] = ereco_mascot_prepare_button_classes_from_params( $settings );
		$settings['loadmore_btn_classes'] = ereco_mascot_prepare_button_classes_from_params( $settings, 'loadmore_' );


		//event-date classes
		$event_left_classes = array();
		if( $settings['vertical_left_date_block_size'] ) {
			$event_left_classes[] = $settings['vertical_left_date_block_size'];
		}
		if( $settings['vertical_left_date_block_border'] ) {
			$event_left_classes[] = 'left-block-bordered';
		}
		if( $settings['vertical_left_date_block_theme_colored'] ) {
			$event_left_classes[] = 'has-bg-theme-colored theme-colored'.$settings['vertical_left_date_block_theme_colored'];
		}
		$settings['event_left_classes'] = $event_left_classes;
		
		//Owl Carousel Data
		$settings['owl_carousel_data_info'] = ereco_mascot_prepare_owlcarousel_data_from_params( $settings );

		//Produce HTML version by using the parameters (filename, variation, folder name, parameters, shortcode_ob_start)
		$html = mascot_core_ereco_elementor_get_shortcode_template_part( 'tribe-events', $settings['display_type'], 'tribe-events/tpl', $settings, true );
		
		echo $html;
	}
}