<?php
namespace MascotCoreErecoElementor\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Hello World
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class TM_Elementor_Working_Steps extends Widget_Base {

	/**
	 * Retrieve the widget name.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'tm-ele-working-steps';
	}

	/**
	 * Retrieve the widget title.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Working Steps', 'mascot-core-elementor' );
	}

	/**
	 * Retrieve the widget icon.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'tm-elementor-widget-icon';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * Note that currently Elementor supports only one category.
	 * When multiple categories passed, Elementor uses the first one.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'tm' ];
	}

	/**
	 * Retrieve the list of scripts the widget depended on.
	 *
	 * Used to set scripts dependencies required to run the widget.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget scripts dependencies.
	 */
	public function get_script_depends() {
		return [ 'mascot-core-hellojs' ];
	}

	/**
	 * Register the widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function _register_controls() {

		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'mascot-core-elementor' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'custom_css_class',
			[
				'label' => esc_html__( "Custom CSS class", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::TEXT,
			]
		);
		
		
		$repeater = new \Elementor\Repeater();
		$repeater->add_control(
			'custom_css_class',
			[
				'label' => esc_html__( "Custom CSS class of this Item", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::TEXT,
			]
		);
		$repeater->add_control(
			'animation_effect', [
				'label' => esc_html__( "On Appeared Animation Effect", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => mascot_core_ereco_tm_custom_animation_class_list(),
			]
		);
		$repeater->add_control(
			'highlighted',
			[
				'label' => esc_html__( "Highlight Item?", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'no'
			]
		);



		$repeater->add_control(
			'hr_image_options',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);
		$repeater->add_control(
			'image_options',
			[
				'label' => esc_html__( 'Image Options', 'mascot-core-elementor' ),
				'type'   => \Elementor\Controls_Manager::HEADING,
			]
		);
		$repeater->add_control(
			'image',
			[
				'label' => esc_html__( "Featured Image", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				"description" => esc_html__( "Upload featured image", 'mascot-core-elementor' ),
			]
		);
		$repeater->add_control(
			'image_size',
			[
				'label' => esc_html__( "Choose Featured Image Size", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => mascot_core_ereco_elementor_get_available_image_sizes(),
				'default' => 'thumbnail',
			]
		);
		$repeater->add_control(
			'image_placement',
			[
				'label' => esc_html__( "Image Placement", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'image-in-center'	=>	esc_html__( "In center of Circle", 'mascot-core-elementor' ),
					'image-full-bg'	=>	esc_html__( "Full Background Image", 'mascot-core-elementor' )
				],
				'default' => 'image-in-center',
			]
		);
		$repeater->add_control(
			'img_width',
			[
				'label' => esc_html__( "Image Dimension (Width and Height)", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}} .image-holder-wrapper .image-holder' => 'width: {{VALUE}}; height: {{VALUE}}; max-width: {{VALUE}};'
				]
			]
		);
		$repeater->add_control(
			'img_border_radius',
			[
				'label' => esc_html__( "Border Radius", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}} .image-holder-wrapper .image-holder' => 'border-radius: {{VALUE}};',
					'{{WRAPPER}} {{CURRENT_ITEM}} .image-holder-wrapper .image-holder .image-holder-inner img' => 'border-radius: {{VALUE}};'
				]
			]
		);
		$repeater->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'img_box_shadow',
				'label' => esc_html__( 'Box Shadow', 'mascot-core-elementor' ),
				'selector' => '{{WRAPPER}} {{CURRENT_ITEM}} .image-holder-wrapper .image-holder',
			]
		);
		$repeater->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'img_border',
				'label' => esc_html__( 'Border', 'mascot-core-elementor' ),
				'selector' => '{{WRAPPER}} {{CURRENT_ITEM}} .image-holder-wrapper .image-holder',
			]
		);
		$repeater->add_control(
			'img_border_theme_colored',
			[
				'label' => esc_html__( "Make Border Theme Colored", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => ereco_mascot_theme_color_list(),
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}} .image-holder-wrapper .image-holder' => 'border-color: var(--theme-color{{VALUE}});'
				],
			]
		);
		$repeater->add_control(
			'img_border_theme_colored_hover',
			[
				'label' => esc_html__( "Make Border Theme Colored (Hover)", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => ereco_mascot_theme_color_list(),
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}}:hover .image-holder-wrapper .image-holder' => 'border-color: var(--theme-color{{VALUE}});'
				],
			]
		);
		$repeater->add_control(
			'img_border_custom_color',
			[
				'label' => esc_html__( "Border Custom Color", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}} .image-holder-wrapper .image-holder' => 'border-color: {{VALUE}};'
				]
			]
		);
		$repeater->add_control(
			'img_border_custom_color_hover',
			[
				'label' => esc_html__( "Border Custom Color (Hover)", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}}:hover .image-holder-wrapper .image-holder' => 'border-color: {{VALUE}};'
				]
			]
		);
		$repeater->add_control(
			'img_wrapper_custom_bg_color',
			[
				'label' => esc_html__( "Image Wrapper BG Color", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}} .image-holder-wrapper .image-holder' => 'background-color: {{VALUE}};'
				]
			]
		);
		$repeater->add_control(
			'img_wrapper_custom_bg_color_hover',
			[
				'label' => esc_html__( "Image Wrapper BG Color (Hover)", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}}:hover .image-holder-wrapper .image-holder' => 'background-color: {{VALUE}};'
				]
			]
		);
		$repeater->add_responsive_control(
			'img_padding',
			[
				'label' => esc_html__( 'Image Padding', 'mascot-core-elementor' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}} .image-holder-wrapper .image-holder' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);




		$repeater->add_control(
			'hr_img_opacity_options',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);
		$repeater->add_control(
			'img_opacity_options',
			[
				'label' => esc_html__( 'Opacity Options', 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::HEADING,
			]
		);
		$repeater->add_control(
			'img_opacity',
			[
				'label' => esc_html__( "Opacity (between 0 to 1)", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}} .image-holder .icon-bg-img' => 'opacity: {{VALUE}};'
				]
			]
		);
		$repeater->add_control(
			'img_opacity_hover',
			[
				'label' => esc_html__( "Opacity Hover (between 0 to 1)", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}}:hover .image-holder .icon-bg-img' => 'opacity: {{VALUE}};'
				]
			]
		);



		$repeater->add_control(
			'hr_tag_options',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);
		$repeater->add_control(
			'tag_options',
			[
				'label' => esc_html__( 'Tag Options', 'mascot-core-elementor' ),
				'type'   => \Elementor\Controls_Manager::HEADING,
			]
		);
		$repeater->add_control(
			'tag',
			[
				'label' => esc_html__( "Tag On Image", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::TEXT,
			]
		);
		$repeater->add_control(
			'tag_theme_colored',
			[
				'label' => esc_html__( "Make Tag Theme Colored", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => ereco_mascot_theme_color_list(),
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}} .image-holder-wrapper .image-holder .tag' => 'color: var(--theme-color{{VALUE}});'
				],
			]
		);
		$repeater->add_control(
			'tag_theme_colored_hover',
			[
				'label' => esc_html__( "Make Tag Theme Colored (Hover)", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => ereco_mascot_theme_color_list(),
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}}:hover .image-holder-wrapper .image-holder .tag' => 'color: var(--theme-color{{VALUE}});'
				],
			]
		);
		$repeater->add_control(
			'tag_text_color',
			[
				'label' => esc_html__( "Tag Custom Color", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}} .image-holder-wrapper .image-holder .tag' => 'color: {{VALUE}};'
				]
			]
		);
		$repeater->add_control(
			'tag_text_color_hover',
			[
				'label' => esc_html__( "Tag Custom Color (Hover)", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}}:hover .image-holder-wrapper .image-holder .tag' => 'color: {{VALUE}};'
				]
			]
		);
		$repeater->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'tag_typography',
				'label' => esc_html__( 'Typography', 'mascot-core-elementor' ),
				'selector' => '{{WRAPPER}} {{CURRENT_ITEM}} .image-holder-wrapper .image-holder .tag',
			]
		);
		$repeater->add_control(
			'tag_bg_theme_colored',
			[
				'label' => esc_html__( "Make Tag Bg Theme Colored", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => ereco_mascot_theme_color_list(),
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}} .image-holder-wrapper .image-holder .tag' => 'background-color: var(--theme-color{{VALUE}});'
				],
			]
		);
		$repeater->add_control(
			'tag_bg_theme_colored_hover',
			[
				'label' => esc_html__( "Make Tag Bg Theme Colored (Hover)", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => ereco_mascot_theme_color_list(),
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}}:hover .image-holder-wrapper .image-holder .tag' => 'background-color: var(--theme-color{{VALUE}});'
				],
			]
		);
		$repeater->add_control(
			'tag_bg_color',
			[
				'label' => esc_html__( "Tag Bg Custom Color", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}} .image-holder-wrapper .image-holder .tag' => 'background-color: {{VALUE}};'
				]
			]
		);
		$repeater->add_control(
			'tag_bg_color_hover',
			[
				'label' => esc_html__( "Tag Bg Custom Color (Hover)", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}}:hover .image-holder-wrapper .image-holder .tag' => 'background-color: {{VALUE}};'
				]
			]
		);
		$repeater->add_control(
			'tag_width',
			[
				'label' => esc_html__( "Dimension (Width and Height)", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}} .image-holder-wrapper .image-holder .tag' => 'width: {{VALUE}}; height: {{VALUE}};',
				]
			]
		);
		$repeater->add_control(
			'tag_border_radius',
			[
				'label' => esc_html__( "Border Radius", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}} .image-holder-wrapper .image-holder .tag' => 'border-radius: {{VALUE}};'
				]
			]
		);
		$repeater->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'tag_box_shadow',
				'label' => esc_html__( 'Box Shadow', 'mascot-core-elementor' ),
				'selector' => '{{WRAPPER}} {{CURRENT_ITEM}} .image-holder-wrapper .image-holder .tag',
			]
		);
		$repeater->add_control(
			'tag_pos_top',
			[
				'label' => esc_html__( "Top", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}} .image-holder-wrapper .image-holder .tag' => 'top: {{VALUE}}; bottom: auto;'
				]
			]
		);
		$repeater->add_control(
			'tag_pos_right',
			[
				'label' => esc_html__( "Right", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}} .image-holder-wrapper .image-holder .tag' => 'right: {{VALUE}}; left: auto;'
				]
			]
		);
		$repeater->add_control(
			'tag_pos_bottom',
			[
				'label' => esc_html__( "Bottom", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}} .image-holder-wrapper .image-holder .tag' => 'bottom: {{VALUE}}; top: auto;'
				]
			]
		);
		$repeater->add_control(
			'tag_pos_left',
			[
				'label' => esc_html__( "Left", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}} .image-holder-wrapper .image-holder .tag' => 'left: {{VALUE}}; right: auto;'
				]
			]
		);
		$repeater->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'tag_border',
				'label' => esc_html__( 'Border', 'mascot-core-elementor' ),
				'selector' => '{{WRAPPER}} {{CURRENT_ITEM}} .image-holder-wrapper .image-holder .tag',
			]
		);






		$repeater->add_control(
			'hr_title_options',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);
		$repeater->add_control(
			'title_options',
			[
				'label' => esc_html__( 'Title Options', 'mascot-core-elementor' ),
				'type'   => \Elementor\Controls_Manager::HEADING,
			]
		);
		$repeater->add_control(
			'title',
			[
				'label' => esc_html__( "Title", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( "This is a title", 'mascot-core-elementor' ),
			]
		);
		$repeater->add_control(
			'title_tag',
			[
				'label' => esc_html__( "Title Tag", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => ereco_mascot_heading_tag_list(),
				'default' => 'h4'
			]
		);
		$repeater->add_control(
			'title_theme_colored',
			[
				'label' => esc_html__( "Make Text Theme Colored", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => ereco_mascot_theme_color_list(),
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}} .title' => 'color: var(--theme-color{{VALUE}});'
				],
			]
		);
		$repeater->add_control(
			'title_theme_colored_hover',
			[
				'label' => esc_html__( "Make Text Theme Colored (Hover)", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => ereco_mascot_theme_color_list(),
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}}:hover .title' => 'color: var(--theme-color{{VALUE}});'
				],
			]
		);
		$repeater->add_control(
			'title_text_color',
			[
				'label' => esc_html__( "Text Color", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}} .title' => 'color: {{VALUE}};'
				]
			]
		);
		$repeater->add_control(
			'title_text_color_hover',
			[
				'label' => esc_html__( "Text Color (Hover)", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}}:hover .title' => 'color: {{VALUE}};'
				]
			]
		);
		$repeater->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => esc_html__( 'Typography', 'mascot-core-elementor' ),
				'selector' => '{{WRAPPER}} {{CURRENT_ITEM}} .title',
			]
		);
		$repeater->add_responsive_control(
			'title_margin',
			[
				'label' => esc_html__( 'Title Margin', 'mascot-core-elementor' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}} .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);





		// Add predefined developer tab content for each shortcode element
		$repeater->add_control(
			'item_wrapper_options',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);
		$repeater->add_control(
			'item_wrapper_styling',
			[
				'label' => esc_html__( 'Item Wrapper Style', 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::HEADING,
			]
		);
		$repeater->add_responsive_control(
			'item_wrapper_margin',
			[
				'label' => esc_html__( 'Wrapper Margin', 'mascot-core-elementor' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}} .working-steps-item-inner' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$repeater->add_responsive_control(
			'item_wrapper_padding',
			[
				'label' => esc_html__( 'Wrapper Padding', 'mascot-core-elementor' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}} .working-steps-item-inner' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$repeater->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'border',
				'label' => esc_html__( 'Border', 'mascot-core-elementor' ),
				'selector' => '{{WRAPPER}} {{CURRENT_ITEM}} .working-steps-item-inner',
			]
		);
		$repeater->add_responsive_control(
			'iconbox_wrapper_border_radius',
			[
				'label' => esc_html__( "Border Radius", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}} .working-steps-item-inner' => 'border-radius: {{VALUE}};'
				]
			]
		);
		$repeater->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'iconbox_wrapper_boxshadow',
				'label' => esc_html__( 'Box Shadow', 'mascot-core-elementor' ),
				'selector' => '{{WRAPPER}} {{CURRENT_ITEM}} .working-steps-item-inner',
			]
		);
		$repeater->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'iconbox_wrapper_boxshadow_hover',
				'label' => esc_html__( 'Box Shadow(Hover)', 'mascot-core-elementor' ),
				'selector' => '{{WRAPPER}} {{CURRENT_ITEM}}:hover .working-steps-item-inner',
			]
		);



		$repeater->add_control(
			'hr_paragraph_options',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);
		$repeater->add_control(
			'paragraph_options',
			[
				'label' => esc_html__( 'Paragraph Options', 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::HEADING,
			]
		);
		$repeater->add_control(
			'content_color',
			[
				'label' => esc_html__( "Content Color", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}} .text-holder' => 'color: {{VALUE}};',
					'{{WRAPPER}} {{CURRENT_ITEM}} .text-holder *' => 'color: {{VALUE}};'
				],
			]
		);
		$repeater->add_control(
			'content_color_hover',
			[
				'label' => esc_html__( "Content Color (Hover)", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}}:hover .text-holder' => 'color: {{VALUE}};',
					'{{WRAPPER}} {{CURRENT_ITEM}}:hover .text-holder *' => 'color: {{VALUE}};'
				],
			]
		);
		$repeater->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'content_typography',
				'label' => esc_html__( 'Typography', 'mascot-core-elementor' ),
				'selector' => '{{WRAPPER}} {{CURRENT_ITEM}} .text-holder, {{WRAPPER}} {{CURRENT_ITEM}} .text-holder *',
			]
		);
		$repeater->add_control(
			'text',
			[
				'label' => esc_html__( "Paragraph", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::WYSIWYG,
				'default' => esc_html__( 'Lorem ipsum is simply free text', 'mascot-core-elementor' ),
			]
		);






		$this->add_control(
			'working_steps_item_array',
			[
				'label' => esc_html__( "Working Steps - Item", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
			]
		);

		$this->end_controls_section();

	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		$html = '';
		//classes
		$classes = array();
		$classes[] = 'tm-sc-working-steps working-steps-horizontal working-steps-items-' . count($settings['working_steps_item_array']);
		$classes[] = $settings['custom_css_class'];
		$params['classes'] = $classes;
	?>
		<div class="<?php echo esc_attr(implode(' ', $classes)); ?>">
			<div class="working-steps-bg-holder" ></div>
			<div class="working-steps-inner clearfix">
	<?php
		if ( $settings['working_steps_item_array'] ) { 
			$settings['iter'] = 1;
			foreach (  $settings['working_steps_item_array'] as $item ) {
				$iter = $settings['iter']++;


				//classes
				$classes = array();
				$classes[] = 'tm-sc-working-steps-item';
				$classes[] = $item['custom_css_class'];
				if( !empty($item['animation_effect']) ) {
					$classes[] = 'tm-animation '.$item['animation_effect'];
				}
				if( $item['image_placement'] ) {
					$classes[] = $item['image_placement'];
				}
				if($item['highlighted'] === 'yes') {
					$classes[] = 'working-steps-item-highlighted';
				}
				$classes[] = 'elementor-repeater-item-' . $item['_id'];
				
				$item['classes'] = $classes;
				$item['item'] = $item;

				//Produce HTML version by using the parameters (filename, variation, folder name, parameters, shortcode_ob_start)
				$html .= mascot_core_ereco_elementor_get_shortcode_template_part( 'working-steps', null, 'working-steps/tpl', $item, true );
			}
		} 
		echo $html;
	?>
			</div>
		</div>
	<?php
	}
}
