<?php

/*
 * Adds Mascot_Core_Ereco_Widget_GoogleMap widget.
 */
if( !class_exists( 'Mascot_Core_Ereco_Widget_GoogleMap' ) ) {
class Mascot_Core_Ereco_Widget_GoogleMap extends Mascot_Core_Ereco_Widget_Loader {

	/**
	 * Register widget with WordPress.
	 */
	function __construct() {
		$this->widgetOptions = array( 
			'classname'		=> 'widget-gallery-images clearfix',
			'description'	=> esc_html__( 'The widget lets you easily displays Google Map.', 'mascot-core' ),
		);
		parent::__construct( 'tm_widget_google_map', esc_html__( '(TM) Google Map', 'mascot-core' ), $this->widgetOptions );
		$this->getFormFields();
	}

	
	/**
	 * Get form fields of the widget.
	 */
	protected function getFormFields() {
		$this->formFields = array(
			array(
				'id'		=> 'title',
				'type'		=> 'text',
				'title'		=> esc_html__( 'Widget Title:', 'mascot-core' ),
				'desc'		=> '',
				'default'	=> esc_html__( 'Google Map', 'mascot-core' ),
			),
			array(
				'id'		=> 'lat',
				'type'		=> 'text',
				'title'		=> esc_html__( 'Latitude:', 'mascot-core' ),
				'desc'		=> sprintf( esc_html__( 'Collect your Latitude from %1$shere%2$s.', 'mascot-core' ), '<a target="_blank" href="' . esc_url( 'http://www.latlong.net/' ) . '">', '</a>' ),
			),
			array(
				'id'		=> 'long',
				'type'		=> 'text',
				'title'		=> esc_html__( 'Longitude:', 'mascot-core' ),
				'desc'		=> sprintf( esc_html__( 'Collect your Longitude from %1$shere%2$s.', 'mascot-core' ), '<a target="_blank" href="' . esc_url( 'http://www.latlong.net/' ) . '">', '</a>' ),
			),
			array(
				'id'		=> 'zoom',
				'type'		=> 'text',
				'title'		=> esc_html__( 'Zoom Level:', 'mascot-core' ),
				'desc'		=> esc_html__( 'Zoom levels between 0 (the lowest zoom level, in which the entire world can be seen on one map) and 21+ (down to streets and individual buildings)', 'mascot-core' ),
				'default'	=> esc_html__( '14', 'mascot-core' ),
			),
			array(
				'id'		=> 'height',
				'type'		=> 'text',
				'title'		=> esc_html__( 'Height of the Map Canvas:', 'mascot-core' ),
				'desc'		=> esc_html__( 'Default: 300', 'mascot-core' ),
			),
			array(
				'id'		=> 'marker_url',
				'type'		=> 'text',
				'title'		=> esc_html__( 'Custom Pin Marker URL:', 'mascot-core' ),
				'desc'		=> '',
			),
			array(
				'id'		=> 'marker_text_title',
				'type'		=> 'text',
				'title'		=> esc_html__( 'Title Text for Marker Popup:', 'mascot-core' ),
				'default'	=> esc_html__( 'Envato', 'mascot-core' ),
				'desc'		=> '',
			),
			array(
				'id'		=> 'marker_text_desc',
				'type'		=> 'text',
				'title'		=> esc_html__( 'Short Description for Marker Popup:', 'mascot-core' ),
				'desc'		=> '',
				'default'	=> esc_html__( 'The world\'s leading marketplace and community for creative assets and creative people.', 'mascot-core' ),
			),
			array(
				'id'		=> 'mapstyle',
				'type'		=> 'dropdown',
				'title'		=> esc_html__( 'Google Map Style', 'mascot-core' ),
				'desc'		=> esc_html__( 'Please choose one from different predefined map styles.', 'mascot-core' ),
				'options'	=> array(
					'default'	=> esc_html__( 'Default', 'mascot-core' ),
					'style1'	 => esc_html__( 'Style 1', 'mascot-core' ),
					'style2'	 => esc_html__( 'Style 2', 'mascot-core' ),
					'style3'	 => esc_html__( 'Style 3', 'mascot-core' ),
					'style4'	 => esc_html__( 'Style 4', 'mascot-core' ),
					'style5'	 => esc_html__( 'Style 5', 'mascot-core' ),
					'style6'	 => esc_html__( 'Style 6', 'mascot-core' ),
					'style7'	 => esc_html__( 'Style 7', 'mascot-core' ),
					'style8'	 => esc_html__( 'Style 8', 'mascot-core' ),
					'style9'	 => esc_html__( 'Style 9', 'mascot-core' ),
					'dark'		=> esc_html__( 'Dark', 'mascot-core' ),
					'greyscale1' => esc_html__( 'Greyscale 1', 'mascot-core' ),
					'greyscale2' => esc_html__( 'Greyscale 2', 'mascot-core' ),
				)
			),
		);
	}



	/**
	 * Front-end display of widget.
	 *
	 * @see WP_Widget::widget()
	 *
	 * @param array $args	 Widget arguments.
	 * @param array $instance Saved values from database.
	 */
	public function widget( $args, $instance ) {

		echo wp_kses_post($args['before_widget']);

		if ( ! empty( $instance['title'] ) ) {
			echo wp_kses_post( $args['before_title'] . apply_filters( 'widget_title', $instance['title'] ) . $args['after_title'] );
		}

		if( $instance['lat'] == '' ) $instance['lat'] = '-37.817314';
		if( $instance['long'] == '' ) $instance['long'] = '144.955431';
		if( $instance['zoom'] == '' ) $instance['zoom'] = '10';
		if( $instance['height'] == '' ) $instance['height'] = '300';
		if( $instance['marker_url'] == '' ) $instance['marker_url'] = ERECO_MASCOT_ASSETS_URI . '/images/map-marker1.png';


		//Enque Google Map Scripts
		wp_enqueue_script( array( 'google-maps-api', 'google-maps-init' ) );
		

		//Produce HTML version by using the parameters (filename, variation, folder name, parameters, widget_ob_start)
		$html = mascot_core_ereco_get_widget_template_part( 'google-map', null, 'google-map/tpl', $instance, false );

		echo wp_kses_post($args['after_widget']);

	}
}
}