<?php

/*
 * Adds Mascot_Core_Ereco_Widget_PinterestBoard widget.
 */
if( !class_exists( 'Mascot_Core_Ereco_Widget_PinterestBoard' ) ) {
class Mascot_Core_Ereco_Widget_PinterestBoard extends Mascot_Core_Ereco_Widget_Loader {

	/**
	 * Register widget with WordPress.
	 */
	function __construct() {
		$this->widgetOptions = array( 
			'classname'		=> 'widget-pinterest-board clearfix',
			'description'	=> esc_html__( 'The Widget lets you easily embed Pinterest Board on your site.', 'mascot-core' ),
		);
		parent::__construct( 'tm_widget_pinterest_board', esc_html__( '(TM) Pinterest Board', 'mascot-core' ), $this->widgetOptions );
		$this->getFormFields();
	}

	
	/**
	 * Get form fields of the widget.
	 */
	protected function getFormFields() {
		$this->formFields = array(
			array(
				'id'		=> 'title',
				'type'		=> 'text',
				'title'		=> esc_html__( 'Widget Title:', 'mascot-core' ),
				'desc'		=> '',
				'default'	=> esc_html__( 'Pinterest Board', 'mascot-core' ),
			),
			array(
				'id'		=> 'board_url',
				'type'		=> 'text',
				'title'		=> esc_html__( 'Pinterest Board URL:', 'mascot-core' ),
				'default'	=> 'https://www.pinterest.com/pinterest/official-news/',
			),
			array(
				'id'		=> 'board_size',
				'type'		=> 'dropdown',
				'title'		=> esc_html__( 'Board Size:', 'mascot-core' ),
				'desc'		=> '',
				'options'	=> array(
					'400-240-80'	=> esc_html__( 'Square', 'mascot-core' ),
					'150-800-60'	=> esc_html__( 'Sidebar', 'mascot-core' ),
					'900-120-115'   => esc_html__( 'Header', 'mascot-core' ),
					'custom'		=> esc_html__( 'Custom', 'mascot-core' ),
				)
			),
			array(
				'id'		=> 'board_custom_description',
				'type'		=> 'description',
				'title'		=> esc_html__( 'The following values will be used only for custom "Board Size" selected from above dropdown menu.', 'mascot-core' ),
			),
			array(
				'id'		=> 'board_custom_line',
				'type'		=> 'line',
			),
			array(
				'id'		=> 'image_width',
				'type'		=> 'text',
				'title'		=> esc_html__( 'Image Width:', 'mascot-core' ),
				'default'	=> '80',
			),
			array(
				'id'		=> 'board_height',
				'type'		=> 'text',
				'title'		=> esc_html__( 'Board Height:', 'mascot-core' ),
				'default'	=> '240',
			),
			array(
				'id'		=> 'board_width',
				'type'		=> 'text',
				'title'		=> esc_html__( 'Board Width:', 'mascot-core' ),
				'default'	=> '400',
			),
		);
	}



	/**
	 * Front-end display of widget.
	 *
	 * @see WP_Widget::widget()
	 *
	 * @param array $args	 Widget arguments.
	 * @param array $instance Saved values from database.
	 */
	public function widget( $args, $instance ) {
		echo wp_kses_post($args['before_widget']);

		if ( ! empty( $instance['title'] ) ) {
			echo wp_kses_post( $args['before_title'] . apply_filters( 'widget_title', $instance['title'] ) . $args['after_title'] );
		}

		//Register Pinterest Script
		wp_register_script( 'pinterest-pinit-js', '//assets.pinterest.com/js/pinit.js', array('jquery'), null, true );
		wp_enqueue_script( array( 'pinterest-pinit-js' ) );


		//Produce HTML version by using the parameters (filename, variation, folder name, parameters, widget_ob_start)
		$html = mascot_core_ereco_get_widget_template_part( 'pinterest-board', null, 'pinterest-board/tpl', $instance, false );

		echo wp_kses_post($args['after_widget']);
	}
}
}