<?php

if(!function_exists('mascot_core_ereco_theme_color_list_vc')) {
	/**
	 * Theme Color list for VC
	 */
	function mascot_core_ereco_theme_color_list_vc() {
		$theme_color_list = array();
		if( function_exists('ereco_mascot_theme_color_list_vc') ) {
			$theme_color_list = ereco_mascot_theme_color_list_vc();
		}
		return $theme_color_list;
	}
}

if(!function_exists('mascot_core_ereco_theme_color_list')) {
	/**
	 * Theme Color list
	 */
	function mascot_core_ereco_theme_color_list() {
		$theme_color_list = array();
		if( function_exists('ereco_mascot_theme_color_list') ) {
			$theme_color_list = ereco_mascot_theme_color_list();
		}
		return $theme_color_list;
	}
}

if(!function_exists('mascot_core_ereco_number_of_theme_colors')) {
	/**
	 * Number of Theme Colors Used in this theme
	 */
	function mascot_core_ereco_number_of_theme_colors() {
		$number_of_theme_colors = 2;
		if( function_exists('ereco_mascot_number_of_theme_colors') ) {
			$number_of_theme_colors = ereco_mascot_number_of_theme_colors();
		}
		return $number_of_theme_colors;
	}
}

if(!function_exists('mascot_core_ereco_icon_font_packs')) {
	/**
	 * Theme Color list
	 */
	function mascot_core_ereco_icon_font_packs( $icon_type = 'font_awesome' ) {
		$icon_font_packs = array();
		if( function_exists('ereco_mascot_icon_font_packs') ) {
			$icon_font_packs = ereco_mascot_icon_font_packs()->getIconFontPackByKey($icon_type)->getFileTypeIconList();
		}
		return $icon_font_packs;
	}
}

if(!function_exists('mascot_core_ereco_animate_css_animation_list')) {
	/**
	 * animate.css animation list https://daneden.github.io/animate.css/
	 */
	function mascot_core_ereco_animate_css_animation_list() {
		if( mascot_core_ereco_theme_installed() ) {
			return ereco_mascot_animate_css_animation_list();
		} else {
			return array();
		}
	}
}

if(!function_exists('mascot_core_ereco_tm_custom_animation_class_list')) {
	/**
	 * custom made animation list
	 */
	function mascot_core_ereco_tm_custom_animation_class_list() {
		if( mascot_core_ereco_theme_installed() ) {
			return ereco_mascot_tm_custom_animation_class_list();
		} else {
			return array();
		}
	}
}

if(!function_exists('mascot_core_ereco_jquery_easings_list')) {
	/**
	 * easings list http://api.jqueryui.com/easings/
	 */
	function mascot_core_ereco_jquery_easings_list() {
		if( mascot_core_ereco_theme_installed() ) {
			return ereco_mascot_jquery_easings_list();
		} else {
			return array();
		}
	}
}

if(!function_exists('mascot_core_ereco_orderby_parameters_list')) {
	/**
	 * Orderby Parameters list
	 */
	function mascot_core_ereco_orderby_parameters_list() {
		if( mascot_core_ereco_theme_installed() ) {
			return ereco_mascot_orderby_parameters_list();
		} else {
			return array(
				esc_html__( 'Date', 'mascot-core' ) 				=> 'date',
			);
		}
	}
}

if(!function_exists('mascot_core_ereco_category_orderby_parameters_list')) {
	/**
	 * Category Orderby Parameters list
	 */
	function mascot_core_ereco_category_orderby_parameters_list() {
		$orderby_parameters_list = array(
			esc_html__( 'name', 'mascot-core' ) 	=> 'name',
			esc_html__( 'id', 'mascot-core' ) 		=> 'id',
			esc_html__( 'count', 'mascot-core' ) 	=> 'count',
			esc_html__( 'slug', 'mascot-core' ) 	=> 'slug',
		);
		return $orderby_parameters_list;
	}
}

if(!function_exists('mascot_core_ereco_masonry_image_sizes')) {
	/**
	 * Return Masonry Image Sizes
	 */
	function mascot_core_ereco_masonry_image_sizes() {
		if( mascot_core_ereco_theme_installed() ) {
			return ereco_mascot_masonry_image_sizes();
		} else {
			return array();
		}
	}
}

if(!function_exists('mascot_core_ereco_list_hover_effects')) {
	/**
	 * Hover Effect list
	 */
	function mascot_core_ereco_list_hover_effects() {
		if( mascot_core_ereco_theme_installed() ) {
			return ereco_mascot_list_hover_effects();
		} else {
			return array();
		}
	}
}

if(!function_exists('mascot_core_ereco_isotope_gutter_list')) {
	/**
	 * Gutter list
	 */
	function mascot_core_ereco_isotope_gutter_list() {
		if( mascot_core_ereco_theme_installed() ) {
			return ereco_mascot_isotope_gutter_list();
		} else {
			return array();
		}
	}
}

if(!function_exists('mascot_core_ereco_different_size_list')) {
	/**
	 * Size list
	 */
	function mascot_core_ereco_different_size_list() {
		if( mascot_core_ereco_theme_installed() ) {
			return ereco_mascot_different_size_list();
		} else {
			return array();
		}
	}
}

if(!function_exists('mascot_core_ereco_text_alignment_list')) {
	/**
	 * Text Alignment List
	 */
	function mascot_core_ereco_text_alignment_list() {
		if( mascot_core_ereco_theme_installed() ) {
			return ereco_mascot_text_alignment_list();
		} else {
			return array();
		}
	}
}

if(!function_exists('mascot_core_ereco_heading_tag_list')) {
	/**
	 * Heading Tag List
	 */
	function mascot_core_ereco_heading_tag_list() {
		if( mascot_core_ereco_theme_installed() ) {
			return ereco_mascot_heading_tag_list();
		} else {
			return array();
		}
	}
}

if(!function_exists('mascot_core_ereco_heading_tag_list_all')) {
	/**
	 * Heading Tag List
	 */
	function mascot_core_ereco_heading_tag_list_all() {
		if( mascot_core_ereco_theme_installed() ) {
			return ereco_mascot_heading_tag_list_all();
		} else {
			return array();
		}
	}
}

if(!function_exists('mascot_core_ereco_open_link_in')) {
	/**
	 * Open Link In
	 */
	function mascot_core_ereco_open_link_in() {
		if( mascot_core_ereco_theme_installed() ) {
			return ereco_mascot_open_link_in();
		} else {
			return array();
		}
	}
}

if(!function_exists('mascot_core_ereco_vc_font_style_list')) {
	/**
	 * Font Style List
	 */
	function mascot_core_ereco_vc_font_style_list() {
		if( mascot_core_ereco_theme_installed() ) {
			return ereco_mascot_vc_font_style_list();
		} else {
			return array();
		}
	}
}

if(!function_exists('mascot_core_ereco_vc_font_weight_list')) {
	/**
	 * Font weight List
	 */
	function mascot_core_ereco_vc_font_weight_list() {
		if( mascot_core_ereco_theme_installed() ) {
			return ereco_mascot_vc_font_weight_list();
		} else {
			return array();
		}
	}
}

if(!function_exists('mascot_core_ereco_vc_text_transform_list')) {
	/**
	 * Text Transform List
	 */
	function mascot_core_ereco_vc_text_transform_list() {
		if( mascot_core_ereco_theme_installed() ) {
			return ereco_mascot_vc_text_transform_list();
		} else {
			return array();
		}
	}
}

if(!function_exists('mascot_core_ereco_get_post_all_categories_array')) {
	/**
	 * Category List of Blog Posts as an Array
	 */
	function mascot_core_ereco_get_post_all_categories_array() {
		$categories = get_categories( array(
			'orderby' => 'name',
			'order'   => 'ASC'
		) );
		$cats = array();
		$cats[''] = 'All';
		foreach($categories as $cat){
			$cats[$cat->term_id] = $cat->name;
		}
		return $cats;
	}
}

if(!function_exists('mascot_core_ereco_get_page_list_array')) {
	/**
	 * Category List of Pages as an Array
	 */
	function mascot_core_ereco_get_page_list_array() {
		$all_pages = get_pages();
		$pages = array();
		foreach($all_pages as $each_page){
			$pages[$each_page->ID] = $each_page->post_title;
		}
		return $pages;
	}
}

if ( ! function_exists( 'mascot_core_ereco_metabox_get_list_of_predefined_theme_color_css_files' ) ) {
	/**
	 * Get list of Predefined Theme Color css files
	 */
	function mascot_core_ereco_metabox_get_list_of_predefined_theme_color_css_files() {
		$predefined_theme_colors = array();

		if( $handle = opendir( MASCOT_TEMPLATE_DIR . '/assets/css/colors/' ) ) {
			while( false !== ($entry = readdir($handle)) ) {
				if( $entry != "." && $entry != ".." ) {
					$predefined_theme_colors[$entry] = $entry;
				}
			}
			closedir($handle);
		}
		return $predefined_theme_colors;
	}
}

if ( ! function_exists( 'mascot_core_ereco_category_list_array' ) ) {
	/**
	 * Return category list array
	 */
	function mascot_core_ereco_category_list_array( $taxonomy ) {
		$list_categories = array(
			'' => esc_html__( 'All', 'mascot-core' )
		);
		$terms = get_terms( $taxonomy );

		if ( $terms && !is_wp_error( $terms ) ) :
			foreach ( $terms as $term ) {
				$list_categories[ $term->slug ] = $term->name;
			}
		endif;

		return $list_categories;
	}
}


if ( ! function_exists( 'mascot_core_ereco_get_available_image_sizes_for_vc' ) ) {
	/**
	 * Get information about available image sizes for VC
	 */
	function mascot_core_ereco_get_available_image_sizes_for_vc() {
		if( mascot_core_ereco_theme_installed() ) {
			return ereco_mascot_get_available_image_sizes_for_vc();
		} else {
			return array();
		}
	}
}

if ( ! function_exists( 'mascot_core_ereco_load_styles' ) ) {
	/**
	 * Get style array
	 */
	function mascot_core_ereco_load_styles( $qty = 1, $param_name = 'design_style', $admin_label = false ) {
		$options = array();
		for ($i = 1; $i <= $qty; $i++) {
			$options[sprintf(esc_html__("Style %s", 'mascot-core'), $i)] = "style{$i}";
		}

		$array = array(
			'type'       => 'dropdown',
			'heading'    => esc_html__('Design Style', 'mascot-core'),
			'param_name' => $param_name,
			'value'      => $options,
			'std'        => 'style1'
		);

		if ($admin_label) $array['admin_label'] = true;

		return $array;
	}
}

if(!function_exists('mascot_core_ereco_get_btn_design_style')) {
	/**
	 * Return Design Style
	 */
	function mascot_core_ereco_get_btn_design_style() {
		if( mascot_core_ereco_theme_installed() ) {
			return ereco_mascot_get_btn_design_style();
		} else {
			return array();
		}
	}
}

if(!function_exists('mascot_core_ereco_get_button_size')) {
	/**
	 * Return Button Size
	 */
	function mascot_core_ereco_get_button_size() {
		if( mascot_core_ereco_theme_installed() ) {
			return ereco_mascot_get_button_size();
		} else {
			return array();
		}
	}
}

if(!function_exists('mascot_core_ereco_get_button_arraylist')) {
	/**
	 * Return Button Array List
	 */
	function mascot_core_ereco_get_button_arraylist( $serial, $group = 'Button Options', $prefix = '' ) {
		$array = array();

		switch ( $serial ) {
			case '1':
				$array = array(
					'type'			=> 'dropdown',
					"heading"		=> esc_html__( "Button Design Style", 'mascot-core' ),
					"param_name"	=> $prefix . "btn_design_style",
					"description"	=> "",
					'value'			=> mascot_core_ereco_get_btn_design_style(),
					'std'   		=> 'btn-theme-colored1',
					'save_always'   => true,
					'admin_label'   => true,
					'group'			=> $group
				);
				break;

			case '2':
				$array = array(
					'type'			=> 'dropdown',
					"heading"		=> esc_html__( "Button Size", 'mascot-core' ),
					"param_name"	=> $prefix . "button_size",
					"description"	=> "",
					'value'			=> mascot_core_ereco_get_button_size(),
					'save_always'   => true,
					'admin_label'   => true,
					'group'			=> $group
				);
				break;

			case '3':
				$array = array(
					'type'			=> 'dropdown',
					"heading"		=> esc_html__( "Button Alignment", 'mascot-core' ),
					"param_name"	=> $prefix . "button_alignment",
					"description"	=> "",
					'value'			=> mascot_core_ereco_text_alignment_list(),
					'group'			=> $group
				);
				break;

			case '4':
				$array = array(
					'type'			=> 'dropdown',
					"heading"		=> esc_html__( "Animation Effect", 'mascot-core' ),
					"param_name"	=> $prefix . "button_hover_animation_effect",
					"description"	=> "",
					'value'			=> array(
						esc_html__( 'None', 'mascot-core' )	=> '',
						esc_html__( 'Sweep To Right', 'mascot-core' )			=> 'hvr-sweep-to-right',
						esc_html__( 'Bounce To Right', 'mascot-core' )			=> 'hvr-bounce-to-right',
						esc_html__( 'Shutter Out Horizontal', 'mascot-core' )	=> 'hvr-shutter-out-horizontal',
						esc_html__( 'Arrow Hover Animation', 'mascot-core' )	=> 'btn-arrow-hover-animation',
					),
					'group'			=> $group
				);
				break;

			case '5':
				$array = array(
					'type'			=> 'textfield',
					"heading"		=> esc_html__( "Custom CSS Class", 'mascot-core' ),
					"param_name"	=> $prefix . "btn_class",
					"description"	=> esc_html__( 'To style button', 'mascot-core' ),
					'admin_label'   => true,
					'group'			=> $group
				);
				break;

			case '6':
				$array = array(
					'type'			=> 'checkbox',
					"heading"		=> esc_html__( "Make Button Outlined", 'mascot-core' ),
					"param_name"	=> $prefix . "btn_outlined",
					'description'   => '',
					'group'			=> $group
				);
				break;

			case '7':
				$array = array(
					'type'			=> 'checkbox',
					"heading"		=> esc_html__( "Make Button Round", 'mascot-core' ),
					"param_name"	=> $prefix . "btn_round",
					'description'   => '',
					'group'			=> $group
				);
				break;

			case '8':
				$array = array(
					'type'			=> 'checkbox',
					"heading"		=> esc_html__( "Make Button Flat", 'mascot-core' ),
					"param_name"	=> $prefix . "btn_flat",
					'description'   => '',
					'group'			=> $group
				);
				break;

			case '9':
				$array = array(
					'type'			=> 'checkbox',
					"heading"		=> esc_html__( "Button Fullwidth (Block Level Button)", 'mascot-core' ),
					"param_name"	=> $prefix . "btn_block",
					'description'   => '',
					'group'			=> $group
				);
				break;

			case '10':
				$array = array(
					'type'			=> 'checkbox',
					"heading"		=> esc_html__( "3D Effect", 'mascot-core' ),
					"param_name"	=> $prefix . "btn_threed_effect",
					'description'   => '',
					'group'			=> $group
				);
				break;

			case '11':
				$array = array(
					'type'			=> 'checkbox',
					"heading"		=> esc_html__( "Gradient Effect", 'mascot-core' ),
					"param_name"	=> $prefix . "btn_gradient_effect",
					'description'   => '',
					'group'			=> $group
				);
				break;
			
			default:
				# code...
				break;
		}

		return $array;
	}
}

if(!function_exists('mascot_core_ereco_get_viewdetails_button_arraylist')) {
	/**
	 * Return Button Show Array List
	 */
	function mascot_core_ereco_get_viewdetails_button_arraylist( $serial, $group = 'Button Options', $btn_text = '', $prefix = '', $std = 'true' ) {
		$array = array();
		if( $btn_text == '' ) $btn_text = esc_html__( 'View Details', 'mascot-core' );

		switch ( $serial ) {
			case '1':
				$array = array(
					'type'			=> 'dropdown',
					"heading"		=> sprintf( esc_html__( "Show %s Button", 'mascot-core' ), $btn_text ),
					"param_name"	=> $prefix . "show_view_details_button",
					'description'   => '',
					'value'			=> array(
						esc_html__( 'Yes', 'mascot-core' )	=> 'true',
						esc_html__( 'No', 'mascot-core' )	=> 'false'
					),
					'std'			=> $std,
					'group'			=> $group
				);
				break;

			case '2':
				$array = array(
					'type'			=> 'textfield',
					"heading"		=> sprintf( esc_html__( "%s Button Text", 'mascot-core' ), $btn_text ),
					"param_name"	=> $prefix . "view_details_button_text",
					'std'			=> $btn_text,
					'save_always'   => true,
					'group'			=> $group
				);
				break;
			
			default:
				# code...
				break;
		}

		return $array;
	}
}

if(!function_exists('mascot_core_ereco_get_owl_carousel_arraylist')) {
	/**
	 * Return Owl Carousel Array List
	 */
	function mascot_core_ereco_get_owl_carousel_arraylist( $serial, $group = 'Carousel Options', $prefix = '', $dependency = array() ) {
		$array = array();

		switch ( $serial ) {
			case '1':
				$array = array(
					'type'			=> 'dropdown',
					"heading"		=> esc_html__( "Show Arrow Navigation", 'mascot-core' ),
					"param_name"	=> $prefix . "show_navigation",
					"description"	=> esc_html__( 'Show Left Right Navigation Arrow for Carousel', 'mascot-core' ),
					'value'			=> array(
						esc_html__( 'Yes', 'mascot-core' )	=> 'true',
						esc_html__( 'No', 'mascot-core' )	=> 'false'
					),
					'admin_label'   => true,
					'dependency'	=> $dependency,
					'group'			=> $group
				);
				break;

			case '2':
				$array = array(
					'type'			=> 'dropdown',
					"heading"		=> esc_html__( "Show Bullets/Dots Navigation", 'mascot-core' ),
					"param_name"	=> $prefix . "show_bullets",
					"description"	=> esc_html__( 'Show Bottom Bullets for Carousel', 'mascot-core' ),
					'value'			=> array(
						esc_html__( 'Yes', 'mascot-core' )	=> 'true',
						esc_html__( 'No', 'mascot-core' )	=> 'false'
					),
					'admin_label'   => true,
					'dependency'	=> $dependency,
					'group'			=> $group
				);
				break;

			case '3':
				$array = array(
					'type'			=> 'dropdown',
					"heading"		=> esc_html__( "Bullets/Dots Skin", 'mascot-core' ),
					"param_name"	=> $prefix . "bullets_skin",
					"description"	=> esc_html__( 'Bottom Bullets Skin', 'mascot-core' ),
					'value'			=> array(
						esc_html__( 'Light Bullets', 'mascot-core' )	=> 'owl-dots-light-skin',
						esc_html__( 'Dark Bullets', 'mascot-core' )		=> 'owl-dots-dark-skin',
					),
					'dependency'	=> $dependency,
					'group'			=> $group
				);
				break;

			case '4':
				$array = array(
					'type'			=> 'dropdown',
					"heading"		=> esc_html__( "Bullets/Dots Alignment", 'mascot-core' ),
					"param_name"	=> $prefix . "bullets_alignment",
					"description"	=> esc_html__( 'Bottom Bullets Alignment', 'mascot-core' ),
					'value'			=> array(
						esc_html__( 'Center', 'mascot-core' )	=> 'owl-dots-center',
						esc_html__( 'Left', 'mascot-core' )		=> 'owl-dots-left',
						esc_html__( 'Right', 'mascot-core' )	=> 'owl-dots-right'
					),
					'dependency'	=> $dependency,
					'group'			=> $group
				);
				break;

			case '5':
				$array = array(
					'type'			=> 'dropdown',
					"heading"		=> esc_html__( "Autoplay", 'mascot-core' ),
					"param_name"	=> $prefix . "carousel_autoplay",
					"description"	=> esc_html__( 'Autoplay Carousel', 'mascot-core' ),
					'value'			=> array(
						esc_html__( 'Yes', 'mascot-core' )	=> 'true',
						esc_html__( 'No', 'mascot-core' )	=> 'false'
					),
					'dependency'	=> $dependency,
					'group'			=> $group
				);
				break;

			case '6':
				$array = array(
					'type'			=> 'dropdown',
					"heading"		=> esc_html__( "Loop", 'mascot-core' ),
					"param_name"	=> $prefix . "carousel_loop",
					"description"	=> esc_html__( 'Infinity loop. Duplicate last and first items to get loop illusion.', 'mascot-core' ),
					'value'			=> array(
						esc_html__( 'Yes', 'mascot-core' )	=> 'true',
						esc_html__( 'No', 'mascot-core' )	=> 'false'
					),
					'dependency'	=> $dependency,
					'group'			=> $group
				);
				break;

			case '7':
				$array = array(
					'type'			=> 'textfield',
					"heading"		=> esc_html__( "Autoplay Interval Timeout", 'mascot-core' ),
					"param_name"	=> $prefix . "animation_speed",
					"description"	=> esc_html__( 'Autoplay interval timeout in milliseconds. Default value is 6000', 'mascot-core' ),
					'dependency'	=> $dependency,
					'group'			=> $group
				);
				break;

			case '8':
				$array = array(
					'type'			=> 'textfield',
					"heading"		=> esc_html__( "Smart Speed", 'mascot-core' ),
					"param_name"	=> $prefix . "smart_speed",
					"description"	=> esc_html__( 'Autoplay Smart Speed in milliseconds. Default value is 300', 'mascot-core' ),
					'dependency'	=> $dependency,
					'group'			=> $group
				);
				break;

			case '9':
				$array = array(
					'type'			=> 'textfield',
					"heading"		=> esc_html__( "Margin", 'mascot-core' ),
					"param_name"	=> $prefix . "margin",
					"description"	=> esc_html__( 'Margin between two slides. Default 30', 'mascot-core' ),
					'dependency'	=> $dependency,
					'group'			=> $group
				);
				break;

			case '10':
				$array = array(
					'type'			=> 'textfield',
					"heading"		=> esc_html__( "Stage Padding", 'mascot-core' ),
					"param_name"	=> $prefix . "stagepadding",
					"description"	=> esc_html__( 'Stage padding option adds left and right padding style onto stage-wrapper. Example: 50', 'mascot-core' ),
					'dependency'	=> $dependency,
					'group'			=> $group
				);
				break;

			case '11':
				$array = array(
					'type'			=> 'textfield',
					"heading"		=> esc_html__( "Responsive Slider Columns in Laptop / Small Desktop", 'mascot-core' ),
					"param_name"	=> $prefix . "laptop",
					"description"	=> esc_html__( 'Number of Visible Sliding Items in Laptop or Small Desktop', 'mascot-core' ),
					'dependency'	=> $dependency,
					'group'			=> $group
				);
				break;

			case '12':
				$array = array(
					'type'			=> 'textfield',
					"heading"		=> esc_html__( "Responsive Slider Columns in Tablet", 'mascot-core' ),
					"param_name"	=> $prefix . "tablet",
					"description"	=> esc_html__( 'Number of Visible Sliding Items in Tablet', 'mascot-core' ),
					'dependency'	=> $dependency,
					'group'			=> $group
				);
				break;

			case '13':
				$array = array(
					'type'			=> 'checkbox',
					"heading"		=> esc_html__( "Carousel Center Feature?", 'mascot-core' ),
					"param_name"	=> $prefix . "center",
					"description"	=> esc_html__( 'This feature adds a class called "center" into the middle image. Keep in mind that dots are not working here like a pagination', 'mascot-core' ),
					'dependency'	=> $dependency,
					'group'			=> $group
				);
				break;

			case '14':
				$array = array(
					'type'			=> 'checkbox',
					"heading"		=> esc_html__( "Focused Center Image?", 'mascot-core' ),
					"param_name"	=> $prefix . "focused-center-image",
					"description"	=> esc_html__( 'Focus Center Image and Blur Other Images', 'mascot-core' ),
					'dependency'	=> array('element' => $prefix . 'center', 'value' => 'true'),
					'group'			=> $group
				);
				break;

			case '15':
				$array = array(
					'type'			=> 'checkbox',
					"heading"		=> esc_html__( "ZoomIn Center Image?", 'mascot-core' ),
					"param_name"	=> $prefix . "zoomin-center-image",
					"description"	=> esc_html__( 'Zoon In Center Images', 'mascot-core' ),
					'dependency'	=> array('element' => $prefix . 'center', 'value' => 'true'),
					'group'			=> $group
				);
				break;
			
			default:
				# code...
				break;
		}

		return $array;
	}
}

if(!function_exists('mascot_core_ereco_get_cat_filter_arraylist')) {
	/**
	 * Return Category Filter Array List
	 */
	function mascot_core_ereco_get_cat_filter_arraylist( $serial, $group = 'Content Options', $dependency = array() ) {
		$array = array();

		switch ( $serial ) {
			case '1':
				$array = array(
					'type'			=> 'dropdown',
					"heading"		=> esc_html__( "Show Category Filter?", 'mascot-core' ),
					"param_name"	=> "show_cat_filter",
					'description'   => '',
					'value'			=> array(
						esc_html__( 'No', 'mascot-core' )	=> 'false',
						esc_html__( 'Yes', 'mascot-core' )	=> 'true'
					),
					'dependency'	=> $dependency,
					'group'			=> $group
				);
				break;

			case '2':
				$array = array(
					'type'			=> 'dropdown',
					"heading"		=> esc_html__( "Filter Style", 'mascot-core' ),
					"param_name"	=> "cat_filter_style",
					"description"	=> "",
					'value'			=> array(
						esc_html__( 'Style 1', 'mascot-core' )	=> 'filter-style-1',
						esc_html__( 'Style 2', 'mascot-core' )	=> 'filter-style-2',
						esc_html__( 'Style 3', 'mascot-core' )	=> 'filter-style-3',
						esc_html__( 'Style 4', 'mascot-core' )	=> 'filter-style-4',
						esc_html__( 'Style 5', 'mascot-core' )	=> 'filter-style-5',
						esc_html__( 'Style 6', 'mascot-core' )	=> 'filter-style-6',
						esc_html__( 'Style 7', 'mascot-core' )	=> 'filter-style-7',
						esc_html__( 'Style 8', 'mascot-core' )	=> 'filter-style-8',
						esc_html__( 'Style 9', 'mascot-core' )	=> 'filter-style-9',
						esc_html__( 'Style 10', 'mascot-core' )	=> 'filter-style-10',
						esc_html__( 'Style 11', 'mascot-core' )	=> 'filter-style-11',
						esc_html__( 'Style 12', 'mascot-core' )	=> 'filter-style-12',
						esc_html__( 'Style 13', 'mascot-core' )	=> 'filter-style-13',
						esc_html__( 'Style 14', 'mascot-core' )	=> 'filter-style-14',
						esc_html__( 'Style 15', 'mascot-core' )	=> 'filter-style-15',
						esc_html__( 'Style 16', 'mascot-core' )	=> 'filter-style-16',
						esc_html__( 'Style flat', 'mascot-core' )	=> 'filter-style-flat',
					),
					'save_always'   => true,
					'dependency'	=> array('element' => 'show_cat_filter', 'value' => 'true'),
					'group'			=> $group
				);
				break;

			case '3':
				$array = array(
					'type'			=> 'dropdown',
					"heading"		=> esc_html__( "Filter Alignment", 'mascot-core' ),
					"param_name"	=> "cat_filter_alignment",
					"description"	=> "",
					'value'			=> mascot_core_ereco_text_alignment_list(),
					'save_always'   => true,
					'dependency'	=> array('element' => 'show_cat_filter', 'value' => 'true'),
					'group'			=> $group
				);
				break;

			case '4':
				$array = array(
					'type'			=> 'dropdown',
					"heading"		=> esc_html__( "Filter Theme Colored", 'mascot-core' ),
					"param_name"	=> "cat_filter_theme_colored",
					"description"	=> "",
					'value'			=> array(
						'Default'					=> 'cat-filter-default',
						'Theme Color 1'	=> 'cat-filter-theme-colored1',
						'Theme Color 2'	=> 'cat-filter-theme-colored2',
					),
					'save_always'   => true,
					'dependency'	=> array('element' => 'show_cat_filter', 'value' => 'true'),
					'group'			=> $group
				);
				break;
			
			default:
				# code...
				break;
		}

		return $array;
	}
}

if(!function_exists('mascot_core_ereco_get_post_list_array_by_post_type_old')) {
	/**
	 * Return Post List Array By Post Type
	 */
	function mascot_core_ereco_get_post_list_array_by_post_type_old( $cpt = '', $for_vc = false ) {
		$post_list = array();
		$args = array(
			'post_type'			=> $cpt,
			'posts_per_page'	=> -1,
			'orderby'			=> 'title',
			'order'				=> 'ASC'
		);

		$the_query = new WP_Query( $args );

		// The Loop
		if ( $the_query->have_posts() ) {
			while ( $the_query->have_posts() ) {
				$the_query->the_post();
				if( $for_vc ) {
					$post_list[ get_the_title() ] = get_the_ID();
				} else {
					$post_list[ get_the_ID() ] = get_the_title();
				}
			}
			wp_reset_postdata();
		}

		return $post_list;
	}
}

if(!function_exists('mascot_core_ereco_get_post_list_array_by_post_type')) {
	/**
	 * Return Post List Array By Post Type
	 */
	function mascot_core_ereco_get_post_list_array_by_post_type( $cpt = '', $for_vc = false ) {
		$post_list = array();
		$post_list[''] = esc_html__( "Select Item", 'mascot-core' );
		$args = array(
			'post_type'			=> $cpt,
			'numberposts'		=> -1,
			'orderby'			=> 'title',
			'order'				=> 'ASC'
		);

		$myposts = get_posts($args);
		if($myposts) {
			foreach ($myposts as $mypost) {
				if( $for_vc ) {
					$post_list[ get_the_title($mypost->ID) ] = $mypost->ID;
				} else {
					$post_list[ $mypost->ID ] = get_the_title($mypost->ID);
				}
			}
			wp_reset_postdata();
		}

		return $post_list;
	}
}

if(!function_exists('mascot_core_ereco_set_admin_ajax_url')){
	/**
	 * Set admin ajax url via javascript
	 * 
	 */
	function mascot_core_ereco_set_admin_ajax_url() {
		echo '<script type="application/javascript">var MascotCoreAjaxUrl = "'.admin_url('admin-ajax.php').'"</script>';
	}
	add_action('wp_enqueue_scripts', 'mascot_core_ereco_set_admin_ajax_url');
}

if(!function_exists('mascot_core_ereco_row_typography')){
	/**
	 * Return Row Typography Array
	 * 
	 */
	function mascot_core_ereco_row_typography() {
		$array = array();
					
		$array = array(
			"type"			=> 'dropdown',
			"heading"		=> esc_html__( "Row Typography", 'mascot-core' ) ,
			"param_name"	=> "section_typo",
			"description"	=> esc_html__( "Define the color typography of the text of this row.", 'mascot-core' ) ,
			"value" => array(
				esc_html__( 'Default', 'mascot-core' ) => '',
				esc_html__( 'Light Typography - on Dark Background', 'mascot-core' ) => 'section-typo-light',
				esc_html__( 'Dark Typography - on White Background', 'mascot-core' ) => 'section-typo-dark',
			) ,
			"weight" => "99"
		);

		return $array;
	}
}

if(!function_exists('mascot_core_ereco_base_64_decode')){
	/**
	 * Return urldecode base64_decode
	 * 
	 */
	function mascot_core_ereco_base_64_decode($code) {
		return urldecode(base64_decode($code));
	}
}

if(!function_exists('mascot_core_ereco_base_64_decode_raw_html')){
	/**
	 * Return rawurldecode base64_decode
	 * 
	 */
	function mascot_core_ereco_base_64_decode_raw_html($code) {
		return rawurldecode( base64_decode( wp_strip_all_tags( $code ) ) );
	}
}

if(!function_exists('mascot_core_ereco_get_animation_type')) {
	/**
	 * Return animation type
	 */
	function mascot_core_ereco_get_animation_type() {
		$array = array(
			esc_html__( 'None', 'mascot-core-elementor' )	=>	'',

			esc_html__( 'Floating Animation', 'mascot-core-elementor' )	=>	'tm-animation-floating',
			esc_html__( 'Horizontal Slide Animation', 'mascot-core-elementor' )	=>	'tm-animation-slide-horizontal',
			esc_html__( 'Scaling Animation', 'mascot-core-elementor' )	=>	'tm-animation-scaling',

			esc_html__( 'Flicker Animation', 'mascot-core-elementor' )	=>	'tm-animation-flicker',
			esc_html__( 'Spin Animation', 'mascot-core-elementor' )	=>	'tm-animation-spin',
			esc_html__( 'Rotated Half Animation', 'mascot-core-elementor' )	=>	'tm-animation-rotated-half',
			esc_html__( 'Jump Animation', 'mascot-core-elementor' )	=>	'tm-animation-jump',

			esc_html__( 'Run Animation', 'mascot-core-elementor' )	=>	'tm-animation-run',
			esc_html__( 'Scale Right Animation', 'mascot-core-elementor' )	=>	'tm-animation-scale-right',

			esc_html__( 'Random Animation 1', 'mascot-core-elementor' )	=>	'tm-animation-random-animation1',
			esc_html__( 'Random Animation 2', 'mascot-core-elementor' )	=>	'tm-animation-random-animation2',
			esc_html__( 'Random Animation 3', 'mascot-core-elementor' )	=>	'tm-animation-random-animation3',
			esc_html__( 'Random Animation 4', 'mascot-core-elementor' )	=>	'tm-animation-random-animation4',
			esc_html__( 'Random Animation 5', 'mascot-core-elementor' )	=>	'tm-animation-random-animation5',
		);
		return $array;
	}
}