<?php
/*
Plugin Name: Mascot Core - Ereco WP
Plugin URI:  https://themeforest.net/user/thememascot/portfolio
Description: Mascot Core Plugin for Mascot Framework. It includes all the required Custom Post Types and Shortcodes needed by Mascot Framework.
Version:     1.0
Author:      ThemeMascot
Author URI:  https://themeforest.net/user/thememascot/portfolio
Text Domain: mascot-core
Domain Path: /languages/
*/

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

define( 'MASCOT_CORE_ERECO_VERSION', '1.0' );

global $mascot_core_ereco_plugin_dir_path, $mascot_core_ereco_plugin_dir_url;
$mascot_core_ereco_plugin_dir_path = plugin_dir_path( __FILE__ );
$mascot_core_ereco_plugin_dir_url = plugin_dir_url( __FILE__ );

define( 'MASCOT_ADMIN_ASSETS_URI', $mascot_core_ereco_plugin_dir_url. 'assets/' );


if(!function_exists('mascot_core_ereco_enque_scripts')) {
	/**
	 * enque style
	 */
	function mascot_core_ereco_enque_scripts() {
		global $mascot_core_ereco_plugin_dir_url;
		wp_enqueue_style( 'mascot-core-custom-admin', $mascot_core_ereco_plugin_dir_url . 'assets/css/custom-admin.css' );
	}
}
add_action( 'admin_enqueue_scripts',	'mascot_core_ereco_enque_scripts' );



if(!function_exists('mascot_core_ereco_text_domain')) {
	/**
	* Loads plugin text domain for translation
	*/
	function mascot_core_ereco_text_domain() {
		load_plugin_textdomain( 'mascot-core', false, basename( dirname( __FILE__ ) ) . '/languages' );
	}
	add_action('plugins_loaded', 'mascot_core_ereco_text_domain');
}

if( !function_exists('mascot_core_ereco_theme_installed') ) {
	/**
	* Checks whether theme is installed or not
	* @return bool
	*/
	function mascot_core_ereco_theme_installed() {
		return defined('ERECO_MASCOT_FRAMEWORK_VERSION');
	}
}
if( !function_exists('mascot_core_ereco_theme_installed') ) {
	define( 'MASCOT_CORE_TEMPLATE_URI', $mascot_core_ereco_plugin_dir_path );
} else {
	define( 'MASCOT_CORE_TEMPLATE_URI', get_template_directory_uri() );
}

require_once $mascot_core_ereco_plugin_dir_path . 'load-lib-ext-plugins.php';
require_once $mascot_core_ereco_plugin_dir_path . 'load-cpt-sc.php';
require_once $mascot_core_ereco_plugin_dir_path . 'load-other.php';