<?php

if ( ! function_exists( 'ereco_mascot_get_isotope_holder_ID' ) ) {
	/**
	 * Returns Portfolio Holder ID
	 *
	 */
	function ereco_mascot_get_isotope_holder_ID( $id_prefix = 'id' ) {
		$random_number = wp_rand( 111111, 999999 );
		$holder_id = $id_prefix . '-holder-' . $random_number;
		return $holder_id;
	}
}

if(!function_exists('ereco_mascot_random_word')) {
	/**
	 * Return Random Word
	 */
	function ereco_mascot_random_word( $len = 5 ) {
		$word = array_merge( range( 'a', 'z' ), range( 'A', 'Z' ));
		shuffle( $word );
		return substr( implode( $word ), 0, $len );
	}
}

if(!function_exists('ereco_mascot_number_of_theme_colors')) {
	/**
	 * Number of Theme Colors Used in this theme
	 */
	function ereco_mascot_number_of_theme_colors() {
		return 4;
	}
}

if(!function_exists('ereco_mascot_theme_color_list_vc')) {
	/**
	 * Theme Color list for VC
	 */
	function ereco_mascot_theme_color_list_vc() {
		$theme_color_list = array(
			esc_html__( 'No', 'ereco-wp' )	=>  '',
			esc_html__( 'Theme Color 1', 'ereco-wp' )	=>  '1',
			esc_html__( 'Theme Color 2', 'ereco-wp' )	=>  '2',
			esc_html__( 'Theme Color 3', 'ereco-wp' )	=>  '3',
			esc_html__( 'Theme Color 4', 'ereco-wp' )	=>  '4',
		);
		return $theme_color_list;
	}
}

if(!function_exists('ereco_mascot_theme_color_list')) {
	/**
	 * Theme Color list
	 */
	function ereco_mascot_theme_color_list() {
		$theme_color_list = array(
			'' => esc_html__( 'No', 'ereco-wp' ),
			'1' => esc_html__( 'Theme Color 1', 'ereco-wp' ),
			'2' => esc_html__( 'Theme Color 2', 'ereco-wp' ),
			'3' => esc_html__( 'Theme Color 3', 'ereco-wp' ),
			'4' => esc_html__( 'Theme Color 4', 'ereco-wp' )
		);
		return $theme_color_list;
	}
}

if(!function_exists('ereco_mascot_tm_custom_animation_class_list')) {
	/**
	 * custom made animation list
	 */
	function ereco_mascot_tm_custom_animation_class_list() {
		$class_list = array(
			''	=>	esc_html__( "None", 'ereco-wp' ),
			'fade-in'	=>	esc_html__( "fade-in", 'ereco-wp' ),
			'move-up'	=>	esc_html__( "move-up", 'ereco-wp' ),
			'move-down'	=>	esc_html__( "move-down", 'ereco-wp' ),
			'move-left'	=>	esc_html__( "move-left", 'ereco-wp' ),
			'move-right'	=>	esc_html__( "move-right", 'ereco-wp' ),
			'scale-up'	=>	esc_html__( "scale-up", 'ereco-wp' ),
			'fall-perspective'	=>	esc_html__( "fall-perspective", 'ereco-wp' ),
			'fly'	=>	esc_html__( "fly", 'ereco-wp' ),
			'flip'	=>	esc_html__( "flip", 'ereco-wp' ),
			'helix'	=>	esc_html__( "helix", 'ereco-wp' ),
			'pop-up'	=>	esc_html__( "pop-up", 'ereco-wp' )
		);
		return $class_list;
	}
}

if(!function_exists('ereco_mascot_animate_css_animation_list')) {
	/**
	 * animate.css animation list https://daneden.github.io/animate.css/
	 */
	function ereco_mascot_animate_css_animation_list() {
		$animate_css_animation_list = array(
			'' => '',
			'fadeIn' => 'fadeIn',
			'fadeInDown' => 'fadeInDown',
			'fadeInDownBig' => 'fadeInDownBig',
			'fadeInLeft' => 'fadeInLeft',
			'fadeInLeftBig' => 'fadeInLeftBig',
			'fadeInRight' => 'fadeInRight',
			'fadeInRightBig' => 'fadeInRightBig',
			'fadeInUp' => 'fadeInUp',
			'fadeInUpBig' => 'fadeInUpBig',
			'fadeOut' => 'fadeOut',
			'fadeOutDown' => 'fadeOutDown',
			'fadeOutDownBig' => 'fadeOutDownBig',
			'fadeOutLeft' => 'fadeOutLeft',
			'fadeOutLeftBig' => 'fadeOutLeftBig',
			'fadeOutRight' => 'fadeOutRight',
			'fadeOutRightBig' => 'fadeOutRightBig',
			'fadeOutUp' => 'fadeOutUp',
			'fadeOutUpBig' => 'fadeOutUpBig',
			'bounce' => 'bounce',
			'flash' => 'flash',
			'pulse' => 'pulse',
			'rubberBand' => 'rubberBand',
			'shake' => 'shake',
			'swing' => 'swing',
			'tada' => 'tada',
			'wobble' => 'wobble',
			'jello' => 'jello',
			'bounceIn' => 'bounceIn',
			'bounceInDown' => 'bounceInDown',
			'bounceInLeft' => 'bounceInLeft',
			'bounceInRight' => 'bounceInRight',
			'bounceInUp' => 'bounceInUp',
			'bounceOut' => 'bounceOut',
			'bounceOutDown' => 'bounceOutDown',
			'bounceOutLeft' => 'bounceOutLeft',
			'bounceOutRight' => 'bounceOutRight',
			'bounceOutUp' => 'bounceOutUp',
			'flip' => 'flip',
			'flipInX' => 'flipInX',
			'flipInY' => 'flipInY',
			'flipOutX' => 'flipOutX',
			'flipOutY' => 'flipOutY',
			'lightSpeedIn' => 'lightSpeedIn',
			'lightSpeedOut' => 'lightSpeedOut',
			'rotateIn' => 'rotateIn',
			'rotateInDownLeft' => 'rotateInDownLeft',
			'rotateInDownRight' => 'rotateInDownRight',
			'rotateInUpLeft' => 'rotateInUpLeft',
			'rotateInUpRight' => 'rotateInUpRight',
			'rotateOut' => 'rotateOut',
			'rotateOutDownLeft' => 'rotateOutDownLeft',
			'rotateOutDownRight' => 'rotateOutDownRight',
			'rotateOutUpLeft' => 'rotateOutUpLeft',
			'rotateOutUpRight' => 'rotateOutUpRight',
			'slideInUp' => 'slideInUp',
			'slideInDown' => 'slideInDown',
			'slideInLeft' => 'slideInLeft',
			'slideInRight' => 'slideInRight',
			'slideOutUp' => 'slideOutUp',
			'slideOutDown' => 'slideOutDown',
			'slideOutLeft' => 'slideOutLeft',
			'slideOutRight' => 'slideOutRight',
			'zoomIn' => 'zoomIn',
			'zoomInDown' => 'zoomInDown',
			'zoomInLeft' => 'zoomInLeft',
			'zoomInRight' => 'zoomInRight',
			'zoomInUp' => 'zoomInUp',
			'zoomOut' => 'zoomOut',
			'zoomOutDown' => 'zoomOutDown',
			'zoomOutLeft' => 'zoomOutLeft',
			'zoomOutRight' => 'zoomOutRight',
			'zoomOutUp' => 'zoomOutUp',
			'hinge' => 'hinge',
			'rollIn' => 'rollIn',
			'rollOut' => 'rollOut'
		);
		return $animate_css_animation_list;
	}
}

if(!function_exists('ereco_mascot_jquery_easings_list')) {
	/**
	 * easings list http://api.jqueryui.com/easings/
	 */
	function ereco_mascot_jquery_easings_list() {
		$jquery_easings_list = array(
			'linear' => 'linear',
			'swing' => 'swing',
			'_default' => '_default',
			'easeInQuad' => 'easeInQuad',
			'easeOutQuad' => 'easeOutQuad',
			'easeInOutQuad' => 'easeInOutQuad',
			'easeInCubic' => 'easeInCubic',
			'easeOutCubic' => 'easeOutCubic',
			'easeInOutCubic' => 'easeInOutCubic',
			'easeInQuart' => 'easeInQuart',
			'easeOutQuart' => 'easeOutQuart',
			'easeInOutQuart' => 'easeInOutQuart',
			'easeInQuint' => 'easeInQuint',
			'easeOutQuint' => 'easeOutQuint',
			'easeInOutQuint' => 'easeInOutQuint',
			'easeInExpo' => 'easeInExpo',
			'easeOutExpo' => 'easeOutExpo',
			'easeInOutExpo' => 'easeInOutExpo',
			'easeInSine' => 'easeInSine',
			'easeOutSine' => 'easeOutSine',
			'easeInOutSine' => 'easeInOutSine',
			'easeInCirc' => 'easeInCirc',
			'easeOutCirc' => 'easeOutCirc',
			'easeInOutCirc' => 'easeInOutCirc',
			'easeInElastic' => 'easeInElastic',
			'easeOutElastic' => 'easeOutElastic',
			'easeInOutElastic' => 'easeInOutElastic',
			'easeInBack' => 'easeInBack',
			'easeOutBack' => 'easeOutBack',
			'easeInOutBack' => 'easeInOutBack',
			'easeInBounce' => 'easeInBounce',
			'easeOutBounce' => 'easeOutBounce',
			'easeInOutBounce' => 'easeInOutBounce',
		);
		return $jquery_easings_list;
	}
}

if(!function_exists('ereco_mascot_wp_admin_dashicons_list')) {
	/**
	 * WordPress admin Dashicons https://developer.wordpress.org/resource/dashicons
	 */
	function ereco_mascot_wp_admin_dashicons_list() {
		$animate_css_animation_list = array(
			'' => '',
			'dashicons-mascot' => 'dashicons-mascot',
			'dashicons-admin-appearance' => 'dashicons-admin-appearance',
			'dashicons-admin-collapse' => 'dashicons-admin-collapse',
			'dashicons-admin-comments' => 'dashicons-admin-comments',
			'dashicons-admin-customizer' => 'dashicons-admin-customizer',
			'dashicons-admin-generic' => 'dashicons-admin-generic',
			'dashicons-admin-home' => 'dashicons-admin-home',
			'dashicons-admin-links' => 'dashicons-admin-links',
			'dashicons-admin-media' => 'dashicons-admin-media',
			'dashicons-admin-multisite' => 'dashicons-admin-multisite',
			'dashicons-admin-network' => 'dashicons-admin-network',
			'dashicons-admin-page' => 'dashicons-admin-page',
			'dashicons-admin-plugins' => 'dashicons-admin-plugins',
			'dashicons-admin-post' => 'dashicons-admin-post',
			'dashicons-admin-settings' => 'dashicons-admin-settings',
			'dashicons-admin-site' => 'dashicons-admin-site',
			'dashicons-admin-tools' => 'dashicons-admin-tools',
			'dashicons-admin-users' => 'dashicons-admin-users',
			'dashicons-album' => 'dashicons-album',
			'dashicons-align-center' => 'dashicons-align-center',
			'dashicons-align-full-width' => 'dashicons-align-full-width',
			'dashicons-align-left' => 'dashicons-align-left',
			'dashicons-align-none' => 'dashicons-align-none',
			'dashicons-align-right' => 'dashicons-align-right',
			'dashicons-align-wide' => 'dashicons-align-wide',
			'dashicons-analytics' => 'dashicons-analytics',
			'dashicons-archive' => 'dashicons-archive',
			'dashicons-arrow-down-alt' => 'dashicons-arrow-down-alt',
			'dashicons-arrow-down-alt2' => 'dashicons-arrow-down-alt2',
			'dashicons-arrow-down' => 'dashicons-arrow-down',
			'dashicons-arrow-left-alt' => 'dashicons-arrow-left-alt',
			'dashicons-arrow-left-alt2' => 'dashicons-arrow-left-alt2',
			'dashicons-arrow-left' => 'dashicons-arrow-left',
			'dashicons-arrow-right-alt' => 'dashicons-arrow-right-alt',
			'dashicons-arrow-right-alt2' => 'dashicons-arrow-right-alt2',
			'dashicons-arrow-right' => 'dashicons-arrow-right',
			'dashicons-arrow-up-alt' => 'dashicons-arrow-up-alt',
			'dashicons-arrow-up-alt2' => 'dashicons-arrow-up-alt2',
			'dashicons-arrow-up' => 'dashicons-arrow-up',
			'dashicons-art' => 'dashicons-art',
			'dashicons-awards' => 'dashicons-awards',
			'dashicons-backup' => 'dashicons-backup',
			'dashicons-book-alt' => 'dashicons-book-alt',
			'dashicons-book' => 'dashicons-book',
			'dashicons-building' => 'dashicons-building',
			'dashicons-businessman' => 'dashicons-businessman',
			'dashicons-button' => 'dashicons-button',
			'dashicons-calendar-alt' => 'dashicons-calendar-alt',
			'dashicons-calendar' => 'dashicons-calendar',
			'dashicons-camera' => 'dashicons-camera',
			'dashicons-carrot' => 'dashicons-carrot',
			'dashicons-cart' => 'dashicons-cart',
			'dashicons-category' => 'dashicons-category',
			'dashicons-chart-area' => 'dashicons-chart-area',
			'dashicons-chart-bar' => 'dashicons-chart-bar',
			'dashicons-chart-line' => 'dashicons-chart-line',
			'dashicons-chart-pie' => 'dashicons-chart-pie',
			'dashicons-clipboard' => 'dashicons-clipboard',
			'dashicons-clock' => 'dashicons-clock',
			'dashicons-cloud' => 'dashicons-cloud',
			'dashicons-controls-back' => 'dashicons-controls-back',
			'dashicons-controls-forward' => 'dashicons-controls-forward',
			'dashicons-controls-pause' => 'dashicons-controls-pause',
			'dashicons-controls-play' => 'dashicons-controls-play',
			'dashicons-controls-repeat' => 'dashicons-controls-repeat',
			'dashicons-controls-skipback' => 'dashicons-controls-skipback',
			'dashicons-controls-skipforward' => 'dashicons-controls-skipforward',
			'dashicons-controls-volumeoff' => 'dashicons-controls-volumeoff',
			'dashicons-controls-volumeon' => 'dashicons-controls-volumeon',
			'dashicons-dashboard' => 'dashicons-dashboard',
			'dashicons-desktop' => 'dashicons-desktop',
			'dashicons-dismiss' => 'dashicons-dismiss',
			'dashicons-download' => 'dashicons-download',
			'dashicons-edit' => 'dashicons-edit',
			'dashicons-editor-aligncenter' => 'dashicons-editor-aligncenter',
			'dashicons-editor-alignleft' => 'dashicons-editor-alignleft',
			'dashicons-editor-alignright' => 'dashicons-editor-alignright',
			'dashicons-editor-bold' => 'dashicons-editor-bold',
			'dashicons-editor-break' => 'dashicons-editor-break',
			'dashicons-editor-code' => 'dashicons-editor-code',
			'dashicons-editor-contract' => 'dashicons-editor-contract',
			'dashicons-editor-customchar' => 'dashicons-editor-customchar',
			'dashicons-editor-expand' => 'dashicons-editor-expand',
			'dashicons-editor-help' => 'dashicons-editor-help',
			'dashicons-editor-indent' => 'dashicons-editor-indent',
			'dashicons-editor-insertmore' => 'dashicons-editor-insertmore',
			'dashicons-editor-italic' => 'dashicons-editor-italic',
			'dashicons-editor-justify' => 'dashicons-editor-justify',
			'dashicons-editor-kitchensink' => 'dashicons-editor-kitchensink',
			'dashicons-editor-ol' => 'dashicons-editor-ol',
			'dashicons-editor-outdent' => 'dashicons-editor-outdent',
			'dashicons-editor-paragraph' => 'dashicons-editor-paragraph',
			'dashicons-editor-paste-text' => 'dashicons-editor-paste-text',
			'dashicons-editor-paste-word' => 'dashicons-editor-paste-word',
			'dashicons-editor-quote' => 'dashicons-editor-quote',
			'dashicons-editor-removeformatting' => 'dashicons-editor-removeformatting',
			'dashicons-editor-rtl' => 'dashicons-editor-rtl',
			'dashicons-editor-spellcheck' => 'dashicons-editor-spellcheck',
			'dashicons-editor-strikethrough' => 'dashicons-editor-strikethrough',
			'dashicons-editor-table' => 'dashicons-editor-table',
			'dashicons-editor-textcolor' => 'dashicons-editor-textcolor',
			'dashicons-editor-ul' => 'dashicons-editor-ul',
			'dashicons-editor-underline' => 'dashicons-editor-underline',
			'dashicons-editor-unlink' => 'dashicons-editor-unlink',
			'dashicons-editor-video' => 'dashicons-editor-video',
			'dashicons-ellipsis' => 'dashicons-ellipsis',
			'dashicons-email-alt' => 'dashicons-email-alt',
			'dashicons-email-alt2' => 'dashicons-email-alt2',
			'dashicons-email' => 'dashicons-email',
			'dashicons-exerpt-view' => 'dashicons-exerpt-view',
			'dashicons-external' => 'dashicons-external',
			'dashicons-facebook-alt' => 'dashicons-facebook-alt',
			'dashicons-facebook' => 'dashicons-facebook',
			'dashicons-feedback' => 'dashicons-feedback',
			'dashicons-filter' => 'dashicons-filter',
			'dashicons-flag' => 'dashicons-flag',
			'dashicons-format-aside' => 'dashicons-format-aside',
			'dashicons-format-audio' => 'dashicons-format-audio',
			'dashicons-format-chat' => 'dashicons-format-chat',
			'dashicons-format-gallery' => 'dashicons-format-gallery',
			'dashicons-format-image' => 'dashicons-format-image',
			'dashicons-format-quote' => 'dashicons-format-quote',
			'dashicons-format-status' => 'dashicons-format-status',
			'dashicons-format-video' => 'dashicons-format-video',
			'dashicons-forms' => 'dashicons-forms',
			'dashicons-googleplus' => 'dashicons-googleplus',
			'dashicons-grid-view' => 'dashicons-grid-view',
			'dashicons-groups' => 'dashicons-groups',
			'dashicons-hammer' => 'dashicons-hammer',
			'dashicons-heading' => 'dashicons-heading',
			'dashicons-heart' => 'dashicons-heart',
			'dashicons-hidden' => 'dashicons-hidden',
			'dashicons-id-alt' => 'dashicons-id-alt',
			'dashicons-id' => 'dashicons-id',
			'dashicons-image-crop' => 'dashicons-image-crop',
			'dashicons-image-filter' => 'dashicons-image-filter',
			'dashicons-image-flip-horizontal' => 'dashicons-image-flip-horizontal',
			'dashicons-image-flip-vertical' => 'dashicons-image-flip-vertical',
			'dashicons-image-rotate-left' => 'dashicons-image-rotate-left',
			'dashicons-image-rotate-right' => 'dashicons-image-rotate-right',
			'dashicons-image-rotate' => 'dashicons-image-rotate',
			'dashicons-images-alt' => 'dashicons-images-alt',
			'dashicons-images-alt2' => 'dashicons-images-alt2',
			'dashicons-index-card' => 'dashicons-index-card',
			'dashicons-info' => 'dashicons-info',
			'dashicons-insert' => 'dashicons-insert',
			'dashicons-laptop' => 'dashicons-laptop',
			'dashicons-layout' => 'dashicons-layout',
			'dashicons-leftright' => 'dashicons-leftright',
			'dashicons-lightbulb' => 'dashicons-lightbulb',
			'dashicons-list-view' => 'dashicons-list-view',
			'dashicons-location-alt' => 'dashicons-location-alt',
			'dashicons-location' => 'dashicons-location',
			'dashicons-lock' => 'dashicons-lock',
			'dashicons-marker' => 'dashicons-marker',
			'dashicons-media-archive' => 'dashicons-media-archive',
			'dashicons-media-audio' => 'dashicons-media-audio',
			'dashicons-media-code' => 'dashicons-media-code',
			'dashicons-media-default' => 'dashicons-media-default',
			'dashicons-media-document' => 'dashicons-media-document',
			'dashicons-media-interactive' => 'dashicons-media-interactive',
			'dashicons-media-spreadsheet' => 'dashicons-media-spreadsheet',
			'dashicons-media-text' => 'dashicons-media-text',
			'dashicons-media-video' => 'dashicons-media-video',
			'dashicons-megaphone' => 'dashicons-megaphone',
			'dashicons-menu-alt' => 'dashicons-menu-alt',
			'dashicons-menu' => 'dashicons-menu',
			'dashicons-microphone' => 'dashicons-microphone',
			'dashicons-migrate' => 'dashicons-migrate',
			'dashicons-minus' => 'dashicons-minus',
			'dashicons-money' => 'dashicons-money',
			'dashicons-move' => 'dashicons-move',
			'dashicons-nametag' => 'dashicons-nametag',
			'dashicons-networking' => 'dashicons-networking',
			'dashicons-no-alt' => 'dashicons-no-alt',
			'dashicons-no' => 'dashicons-no',
			'dashicons-palmtree' => 'dashicons-palmtree',
			'dashicons-paperclip' => 'dashicons-paperclip',
			'dashicons-performance' => 'dashicons-performance',
			'dashicons-phone' => 'dashicons-phone',
			'dashicons-playlist-audio' => 'dashicons-playlist-audio',
			'dashicons-playlist-video' => 'dashicons-playlist-video',
			'dashicons-plus-alt' => 'dashicons-plus-alt',
			'dashicons-plus-light' => 'dashicons-plus-light',
			'dashicons-plus' => 'dashicons-plus',
			'dashicons-portfolio' => 'dashicons-portfolio',
			'dashicons-post-status' => 'dashicons-post-status',
			'dashicons-pressthis' => 'dashicons-pressthis',
			'dashicons-products' => 'dashicons-products',
			'dashicons-randomize' => 'dashicons-randomize',
			'dashicons-redo' => 'dashicons-redo',
			'dashicons-rss' => 'dashicons-rss',
			'dashicons-saved' => 'dashicons-saved',
			'dashicons-schedule' => 'dashicons-schedule',
			'dashicons-screenoptions' => 'dashicons-screenoptions',
			'dashicons-search' => 'dashicons-search',
			'dashicons-share-alt' => 'dashicons-share-alt',
			'dashicons-share-alt2' => 'dashicons-share-alt2',
			'dashicons-share' => 'dashicons-share',
			'dashicons-shield-alt' => 'dashicons-shield-alt',
			'dashicons-shield' => 'dashicons-shield',
			'dashicons-slides' => 'dashicons-slides',
			'dashicons-smartphone' => 'dashicons-smartphone',
			'dashicons-smiley' => 'dashicons-smiley',
			'dashicons-sort' => 'dashicons-sort',
			'dashicons-sos' => 'dashicons-sos',
			'dashicons-star-empty' => 'dashicons-star-empty',
			'dashicons-star-filled' => 'dashicons-star-filled',
			'dashicons-star-half' => 'dashicons-star-half',
			'dashicons-sticky' => 'dashicons-sticky',
			'dashicons-store' => 'dashicons-store',
			'dashicons-tablet' => 'dashicons-tablet',
			'dashicons-tag' => 'dashicons-tag',
			'dashicons-tagcloud' => 'dashicons-tagcloud',
			'dashicons-testimonial' => 'dashicons-testimonial',
			'dashicons-text' => 'dashicons-text',
			'dashicons-thumbs-down' => 'dashicons-thumbs-down',
			'dashicons-thumbs-up' => 'dashicons-thumbs-up',
			'dashicons-tickets-alt' => 'dashicons-tickets-alt',
			'dashicons-tickets' => 'dashicons-tickets',
			'dashicons-translation' => 'dashicons-translation',
			'dashicons-trash' => 'dashicons-trash',
			'dashicons-twitter' => 'dashicons-twitter',
			'dashicons-undo' => 'dashicons-undo',
			'dashicons-universal-access-alt' => 'dashicons-universal-access-alt',
			'dashicons-universal-access' => 'dashicons-universal-access',
			'dashicons-unlock' => 'dashicons-unlock',
			'dashicons-update' => 'dashicons-update',
			'dashicons-upload' => 'dashicons-upload',
			'dashicons-vault' => 'dashicons-vault',
			'dashicons-video-alt' => 'dashicons-video-alt',
			'dashicons-video-alt2' => 'dashicons-video-alt2',
			'dashicons-video-alt3' => 'dashicons-video-alt3',
			'dashicons-visibility' => 'dashicons-visibility',
			'dashicons-warning' => 'dashicons-warning',
			'dashicons-welcome-add-page' => 'dashicons-welcome-add-page',
			'dashicons-welcome-comments' => 'dashicons-welcome-comments',
			'dashicons-welcome-learn-more' => 'dashicons-welcome-learn-more',
			'dashicons-welcome-view-site' => 'dashicons-welcome-view-site',
			'dashicons-welcome-widgets-menus' => 'dashicons-welcome-widgets-menus',
			'dashicons-welcome-write-blog' => 'dashicons-welcome-write-blog',
			'dashicons-wordpress-alt' => 'dashicons-wordpress-alt',
			'dashicons-wordpress' => 'dashicons-wordpress',
			'dashicons-yes' => 'dashicons-yes'
		);
		return $animate_css_animation_list;
	}
}

if(!function_exists('ereco_mascot_orderby_parameters_list')) {
	/**
	 * Orderby Parameters list
	 */
	function ereco_mascot_orderby_parameters_list() {
		$orderby_parameters_list = array(
			esc_html__( 'Date', 'ereco-wp' ) 					=> 'date',
			esc_html__( 'Post Name', 'ereco-wp' ) 			=> 'name',
			esc_html__( 'Random Order', 'ereco-wp' ) 			=> 'rand',
			esc_html__( 'Last Modified Date', 'ereco-wp' ) 	=> 'modified',
			esc_html__( 'Author', 'ereco-wp' ) 				=> 'author',
			esc_html__( 'Title', 'ereco-wp' ) 				=> 'title',
			esc_html__( 'ID', 'ereco-wp' ) 					=> 'ID',
			esc_html__( 'Post/Page Parent ID', 'ereco-wp' ) 	=> 'parent',
			esc_html__( 'Number of Comments', 'ereco-wp' ) 	=> 'comment_count',
			esc_html__( 'Page Order', 'ereco-wp' ) 			=> 'menu_order'
		);
		return $orderby_parameters_list;
	}
}

if(!function_exists('ereco_mascot_list_hover_effects')) {
	/**
	 * Hover Effect list
	 */
	function ereco_mascot_list_hover_effects() {
		$hover_effects_list = array(
			esc_html__( 'Default', 'ereco-wp' )			=> '',
			esc_html__( 'Effect London', 'ereco-wp' )		=> 'effect-london',
			esc_html__( 'Effect Rome', 'ereco-wp' )		=> 'effect-rome',
			esc_html__( 'Effect Paris', 'ereco-wp' )		=> 'effect-paris',
			esc_html__( 'Effect Barlin', 'ereco-wp' )		=> 'effect-barlin'
		);
		return $hover_effects_list;
	}
}

if(!function_exists('ereco_mascot_isotope_gutter_list')) {
	/**
	 * Portfolio Gutter list
	 */
	function ereco_mascot_isotope_gutter_list() {
		$gutter_list = array(
			esc_html__( 'Default', 'ereco-wp' )  	=>  'gutter',
			'0'			=>  'gutter-0',
			'2px'  		=>  'gutter-2',
			'5px'  		=>  'gutter-5',
			'10px'  	=>  'gutter-10',
			'15px'  	=>  'gutter-15',
			'20px'  	=>  'gutter-20',
			'30px'  	=>  'gutter-30',
			'40px'  	=>  'gutter-40',
			'50px'  	=>  'gutter-50',
			'60px'  	=>  'gutter-60',
		);
		return $gutter_list;
	}
}

if(!function_exists('ereco_mascot_isotope_gutter_list_redux')) {
	/**
	 * Portfolio Gutter list
	 */
	function ereco_mascot_isotope_gutter_list_redux() {
		$gutter_list = array(
			'gutter' 		=>  esc_html__( 'Default', 'ereco-wp' ),
			'gutter-0'		=>  '0',
			'gutter-2'  	=>  '2px',
			'gutter-5'  	=>  '5px',
			'gutter-10'  	=>  '10px',
			'gutter-15'  	=>  '15px',
			'gutter-20'  	=>  '20px',
			'gutter-30'  	=>  '30px',
			'gutter-40'  	=>  '40px',
			'gutter-50'  	=>  '50px',
			'gutter-60'  	=>  '60px',
		);
		return $gutter_list;
	}
}

if(!function_exists('ereco_mascot_different_size_list')) {
	/**
	 * Size list
	 */
	function ereco_mascot_different_size_list() {
		$size_list = array(
			''  	=>  '',
			'xl'  	=>  'xl',
			'lg'  	=>  'lg',
			'md'  	=>  'md',
			'sm'  	=>  'sm',
			'xs'  	=>  'xs',
		);
		return $size_list;
	}
}

if(!function_exists('ereco_mascot_masonry_image_sizes')) {
	/**
	 * Masonry Image Size list
	 */
	function ereco_mascot_masonry_image_sizes() {
		$masonry_image_sizes = array(
			'ereco_mascot_square'			=> esc_html__( 'Default', 'ereco-wp' ),
			'ereco_mascot_wide'			=> esc_html__( 'Width', 'ereco-wp' ),
			'ereco_mascot_height'			=> esc_html__( 'Height', 'ereco-wp' ),
			'ereco_mascot_width_height'	=> esc_html__( 'Both Width & Height', 'ereco-wp' ),
		);
		return $masonry_image_sizes;
	}
}

if(!function_exists('ereco_mascot_text_alignment_list')) {
	/**
	 * Text Alignment List
	 */
	function ereco_mascot_text_alignment_list() {
		$alignment_list = array(
			esc_html__( 'Default', 'ereco-wp' )		=> '',
			esc_html__( 'Left', 'ereco-wp' )		=> 'text-left',
			esc_html__( 'Center', 'ereco-wp' )	=> 'text-center',
			esc_html__( 'Right', 'ereco-wp' )		=> 'text-right'
		);
		return $alignment_list;
	}
}

if(!function_exists('ereco_mascot_redux_text_alignment_list')) {
	/**
	 * Text Alignment List - Redux
	 */
	function ereco_mascot_redux_text_alignment_list() {
		$alignment_list = array(
			''	 	=> esc_html__( 'Default', 'ereco-wp' ),
			'text-left'	 	=> esc_html__( 'Left', 'ereco-wp' ),
			'text-center'   => esc_html__( 'Center', 'ereco-wp' ),
			'text-right'	=> esc_html__( 'Right', 'ereco-wp' ),
		);
		return $alignment_list;
	}
}

if(!function_exists('ereco_mascot_redux_text_alignment_single_word_list')) {
	/**
	 * Text Alignment List Only Single Word- Redux
	 */
	function ereco_mascot_redux_text_alignment_single_word_list() {
		$alignment_list = array(
			'left'	 	=> esc_html__( 'Left', 'ereco-wp' ),
			'center'  	=> esc_html__( 'Center', 'ereco-wp' ),
			'right'		=> esc_html__( 'Right', 'ereco-wp' ),
		);
		return $alignment_list;
	}
}

if(!function_exists('ereco_mascot_redux_text_alignment_elementor')) {
	/**
	 * Text Alignment Elementor
	 */
	function ereco_mascot_redux_text_alignment_elementor() {
		$alignment_list = array(
			esc_html__( 'Left', 'ereco-wp' ) => 'left',
			esc_html__( 'Center', 'ereco-wp' ) => 'center',
			esc_html__( 'Right', 'ereco-wp' ) => 'right'
		);
		return $alignment_list;
	}
}

if(!function_exists('ereco_mascot_heading_tag_list')) {
	/**
	 * Heading Tag List
	 */
	function ereco_mascot_heading_tag_list() {
		$heading_tag_list = array(
			''  	=>  '',
			'h1' => 'h1',
			'h2' => 'h2',
			'h3' => 'h3',
			'h4' => 'h4',
			'h5' => 'h5',
			'h6' => 'h6',
			'p'  => 'p',
			'a'  => 'a',
			'span'  => 'span',
			'div'  => 'div',
		);
		return $heading_tag_list;
	}
}

if(!function_exists('ereco_mascot_heading_tag_list_all')) {
	/**
	 * Heading Tag List
	 */
	function ereco_mascot_heading_tag_list_all() {
		$heading_tag_list_all = array(
			'h1' => 'h1',
			'h2' => 'h2',
			'h3' => 'h3',
			'h4' => 'h4',
			'h5' => 'h5',
			'h6' => 'h6',
			'p'  => 'p',
			'a'  => 'a',
			'span'  => 'span',
			'div'  => 'div',
		);
		return $heading_tag_list_all;
	}
}

if(!function_exists('ereco_mascot_open_link_in')) {
	/**
	 * Open Link In
	 */
	function ereco_mascot_open_link_in() {
		$open_link_in = array(
			esc_html__( 'New Window', 'ereco-wp' )   => '_blank',
			esc_html__( 'Same Window', 'ereco-wp' )  => '_self'
		);
		return $open_link_in;
	}
}

if(!function_exists('ereco_mascot_vc_font_style_list')) {
	/**
	 * Font Style List
	 */
	function ereco_mascot_vc_font_style_list() {
		$font_style_list = array(
			esc_html__( 'Normal', 'ereco-wp' )   	=> '',
			esc_html__( 'Italic', 'ereco-wp' )  	=> 'italic'
		);
		return $font_style_list;
	}
}

if(!function_exists('ereco_mascot_vc_font_weight_list')) {
	/**
	 * Font weight List
	 */
	function ereco_mascot_vc_font_weight_list() {
		$font_weight_list = array(
			esc_html__( 'Default', 'ereco-wp' )   => '',
			'100'   => '100',
			'200'   => '200',
			'300'   => '300',
			'400'   => '400',
			'500'   => '500',
			'600'   => '600',
			'700'   => '700',
			'800'   => '800',
		);
		return $font_weight_list;
	}
}

if(!function_exists('ereco_mascot_vc_text_transform_list')) {
	/**
	 * Text Transform List
	 */
	function ereco_mascot_vc_text_transform_list() {
		$text_transform_list = array(
			esc_html__( 'Default', 'ereco-wp' )   	=> '',
			esc_html__( 'None', 'ereco-wp' )  		=> 'none',
			esc_html__( 'Capitalize', 'ereco-wp' )  	=> 'capitalize',
			esc_html__( 'Uppercase', 'ereco-wp' )  	=> 'uppercase',
			esc_html__( 'Lowercase', 'ereco-wp' )  	=> 'lowercase',
			esc_html__( 'Initial', 'ereco-wp' )  		=> 'initial',
			esc_html__( 'Inherit', 'ereco-wp' )  		=> 'inherit'
		);
		return $text_transform_list;
	}
}

if(!function_exists('ereco_mascot_get_post_all_categories_array')) {
	/**
	 * Category List of Blog Posts as an Array
	 */
	function ereco_mascot_get_post_all_categories_array() {
		$categories = get_categories( array(
			'orderby' => 'name',
			'order'   => 'ASC'
		) );
		$cats = array();
		$cats[''] = 'All';
		foreach($categories as $cat){
			$cats[$cat->term_id] = $cat->name;
		}
		return $cats;
	}
}

if(!function_exists('ereco_mascot_get_page_list_array')) {
	/**
	 * Category List of Pages as an Array
	 */
	function ereco_mascot_get_page_list_array() {
		$all_pages = get_pages();
		$pages = array();
		foreach($all_pages as $each_page){
			$pages[$each_page->ID] = $each_page->post_title;
		}
		return $pages;
	}
}

if ( ! function_exists( 'ereco_mascot_metabox_get_list_of_predefined_theme_color_css_files' ) ) {
	/**
	 * Get list of Predefined Theme Color css files
	 */
	function ereco_mascot_metabox_get_list_of_predefined_theme_color_css_files() {
		$predefined_theme_colors = array();

		if( $handle = opendir( ERECO_MASCOT_TEMPLATE_DIR . '/assets/css/colors/' ) ) {
			while( false !== ($entry = readdir($handle)) ) {
				if( $entry != "." && $entry != ".."  && substr( $entry, 0, 6 ) === "theme-") {
					$predefined_theme_colors[$entry] = $entry;
				}
			}
			closedir($handle);
		}
		return $predefined_theme_colors;
	}
}

if ( ! function_exists( 'ereco_mascot_metabox_get_list_of_premade_sitewise_css_files' ) ) {
	/**
	 * Get list of Premade Sitewise css files
	 */
	function ereco_mascot_metabox_get_list_of_premade_sitewise_css_files() {
		$premade_css_files = array();

		if( $handle = opendir( ERECO_MASCOT_TEMPLATE_DIR . '/assets/css/sites/' ) ) {
			while( false !== ($entry = readdir($handle)) ) {
				if( $entry != "." && $entry != ".."  && substr( $entry, 0, 5 ) === "main-") {
					$premade_css_files[$entry] = $entry;
				}
			}
			closedir($handle);
		}
		return $premade_css_files;
	}
}


if ( ! function_exists( 'ereco_mascot_get_available_image_sizes' ) ) {
	/**
	 * Get information about available image sizes
	 */
	function ereco_mascot_get_available_image_sizes( $size = '' ) {
	
		global $_wp_additional_image_sizes;
	
		$sizes = array();
		$get_intermediate_image_sizes = get_intermediate_image_sizes();
	
		// Create the full array with sizes and crop info
		foreach( $get_intermediate_image_sizes as $_size ) {
			if ( in_array( $_size, array( 'thumbnail', 'medium', 'medium_large', 'large', 'full' ) ) ) {
				$sizes[ $_size ]['width'] = get_option( $_size . '_size_w' );
				$sizes[ $_size ]['height'] = get_option( $_size . '_size_h' );
				$sizes[ $_size ]['crop'] = (bool) get_option( $_size . '_crop' );
				if ( $_size == 'large' ) {
					$sizes[ 'full' ] ['width'] = 0;
					$sizes[ 'full' ] ['height'] = 0;
					$sizes[ 'full' ] ['crop'] = false;
				}
			} elseif ( isset( $_wp_additional_image_sizes[ $_size ] ) ) {
				$sizes[ $_size ] = array( 
					'width' => $_wp_additional_image_sizes[ $_size ]['width'],
					'height' => $_wp_additional_image_sizes[ $_size ]['height'],
					'crop' =>  $_wp_additional_image_sizes[ $_size ]['crop']
				);
			}
		}
	
		// Get only 1 size if found
		if ( $size ) {
			if( isset( $sizes[ $size ] ) ) {
				return $sizes[ $size ];
			} else {
				return false;
			}
		}
		return $sizes;
	}
}


if ( ! function_exists( 'ereco_mascot_get_available_image_sizes_for_vc' ) ) {
	/**
	 * Get information about available image sizes for VC
	 */
	function ereco_mascot_get_available_image_sizes_for_vc() {
		$size = array();
		$available_image_sizes = ereco_mascot_get_available_image_sizes();
	
		// Create the full array with sizes and crop info
		foreach( $available_image_sizes as $key => $value ) {
			$sizes[ $key . ( ($value['crop'] == 1) ? ' - cropped' : '') . ' - (' .$value['width'] . 'x' . $value['height'] . ')' ] = $key;
		}
		return $sizes;
	}
}

if(!function_exists('ereco_mascot_get_btn_design_style')) {
	/**
	 * Return Design Style
	 */
	function ereco_mascot_get_btn_design_style() {
		$array = array(
			esc_html__( 'Button Primary', 'ereco-wp' )				=> 'btn-primary',
			esc_html__( 'Button Secondary', 'ereco-wp' )				=> 'btn-secondary',
			esc_html__( 'Button Success', 'ereco-wp' )				=> 'btn-success',
			esc_html__( 'Button Danger', 'ereco-wp' )					=> 'btn-danger',
			esc_html__( 'Button Warning', 'ereco-wp' )				=> 'btn-warning',
			esc_html__( 'Button Info', 'ereco-wp' )					=> 'btn-info',
			esc_html__( 'Button Light', 'ereco-wp' )					=> 'btn-light',
			esc_html__( 'Button Dark', 'ereco-wp' )					=> 'btn-dark',
			esc_html__( 'Button Gray', 'ereco-wp' )					=> 'btn-gray',
			esc_html__( 'Button Light Gray', 'ereco-wp' )					=> 'btn-light-gray',
			esc_html__( 'Plain Text', 'ereco-wp' )					=> 'btn-plain-text',
			esc_html__( 'Plain Text + Arrow', 'ereco-wp' )			=> 'btn-plain-text-with-arrow',
			esc_html__( 'Button Modern White', 'ereco-wp' )			=> 'btn-modern-white',
			esc_html__( 'Button Modern Theme Colored', 'ereco-wp' )	=> 'btn-modern-theme-colored'
		);

		$array_theme_color = array();
		for ($i=1; $i <= ereco_mascot_number_of_theme_colors(); $i++) { 
			$array_theme_color[ esc_html__( 'Button Theme Colored', 'ereco-wp' ) . ' ' . $i ] = 'btn-theme-colored' . $i;
		}

		$array = array_merge($array, $array_theme_color);
		return $array;
	}
}

if(!function_exists('ereco_mascot_get_button_size')) {
	/**
	 * Return Button Size
	 */
	function ereco_mascot_get_button_size() {
		$array = array(
			esc_html__( 'Default', 'ereco-wp' )		=> '',
			esc_html__( 'Large', 'ereco-wp' )			=> 'btn-lg',
			esc_html__( 'Small', 'ereco-wp' )			=> 'btn-sm',
			esc_html__( 'Extra Small', 'ereco-wp' )	=> 'btn-xs',
		);
		return $array;
	}
}


if ( ! function_exists( 'ereco_mascot_prepare_button_classes_from_params' ) ) {
	/**
	 * Return Button Classes Collecting From Params
	 */
	function ereco_mascot_prepare_button_classes_from_params( $params = array(), $prefix = '' ) {
		$btn_classes = array();

		$btn_classes[] = 'btn';
		if( filter_var( $params[$prefix . 'btn_outlined'], FILTER_VALIDATE_BOOLEAN ) == true ) {
			$oldstr = $params[$prefix . 'btn_design_style'];
			$newstr = substr_replace($oldstr, 'outline-', 4, 0);
			$btn_classes[] = $newstr;
			$btn_classes[] = 'btn-outline';
		} else if( filter_var( $params[$prefix . 'btn_gradient_effect'], FILTER_VALIDATE_BOOLEAN ) == true ) {
			$oldstr = $params[$prefix . 'btn_design_style'];
			$newstr = substr_replace($oldstr, 'gradient-', 4, 0);
			$btn_classes[] = $newstr;
			$btn_classes[] = 'btn-outline';
		} else if ( $params[$prefix . 'btn_design_style'] ) {
			$btn_classes[] = $params[$prefix . 'btn_design_style'];
		}

		if( $params[$prefix . 'button_size'] != "" ) {
			$btn_classes[] = $params[$prefix . 'button_size'];
		}
		if( filter_var( $params[$prefix . 'btn_round'], FILTER_VALIDATE_BOOLEAN ) == true ) {
			$btn_classes[] = 'btn-round';
		}
		if( filter_var( $params[$prefix . 'btn_flat'], FILTER_VALIDATE_BOOLEAN ) == true ) {
			$btn_classes[] = 'btn-flat';
		}
		if( filter_var( $params[$prefix . 'btn_block'], FILTER_VALIDATE_BOOLEAN ) == true ) {
			$btn_classes[] = 'btn-block';
		}
		if( filter_var( $params[$prefix . 'btn_threed_effect'], FILTER_VALIDATE_BOOLEAN ) == true ) {
			$btn_classes[] = 'btn-3d';
		}
		if( $params[$prefix . 'button_hover_animation_effect'] != "" ) {
			$btn_classes[] = $params[$prefix . 'button_hover_animation_effect'];
		}
		if( $params[$prefix . 'btn_class'] != "" ) {
			$btn_classes[] = $params[$prefix . 'btn_class'];
		}

		return $btn_classes;
	}
}


if ( ! function_exists( 'ereco_mascot_prepare_header_button_classes_from_params' ) ) {
	/**
	 * Return Header Button Classes Collecting From Params
	 */
	function ereco_mascot_prepare_header_button_classes_from_params( $params = array(), $prefix = '' ) {
		$btn_classes = array();

		$btn_classes[] = 'btn';
		if( $params[$prefix . 'custom_button_outlined'] ) {
			$oldstr = $params[$prefix . 'custom_button_design_style'];
			$newstr = substr_replace($oldstr, 'outline-', 4, 0);
			$btn_classes[] = $newstr;
			$btn_classes[] = 'btn-outline';
		} else if ( $params[$prefix . 'custom_button_design_style'] ) {
			$btn_classes[] = $params[$prefix . 'custom_button_design_style'];
		}
		if( $params[$prefix . 'custom_button_size'] ) {
			$btn_classes[] = $params[$prefix . 'custom_button_size'];
		}
		if( $params[$prefix . 'custom_button_flat'] ) {
			$btn_classes[] = 'btn-flat';
		}
		if( $params[$prefix . 'custom_button_round'] ) {
			$btn_classes[] = 'btn-round';
		}
		if( isset( $params[$prefix . 'custom_button_custom_css'] ) ) {
			$btn_classes[] = $params[$prefix . 'custom_button_custom_css'];
		}

		$btn_classes[] = 'custom-button';
		return $btn_classes;
	}
}


if ( ! function_exists( 'ereco_mascot_no_posts_match_criteria_text' ) ) {
	/**
	 * Return no posts matched your criteria text
	 */
	function ereco_mascot_no_posts_match_criteria_text() {
		return '<p>' . esc_html_e( 'Sorry, no posts matched your criteria.', 'ereco-wp' ) . '</p>';
	}
}


if ( ! function_exists( 'ereco_mascot_prepare_owlcarousel_data_from_params' ) ) {
	/**
	 * Return Owl Carousel Data Collecting From Params
	 */
	function ereco_mascot_prepare_owlcarousel_data_from_params( $params = array(), $prefix = '' ) {
		$owlcarousel_data = array();

		if( filter_var( $params[$prefix . 'show_navigation'], FILTER_VALIDATE_BOOLEAN ) == true ) {
			$owlcarousel_data[] = 'data-nav="true"';
		}
		if( filter_var( $params[$prefix . 'show_bullets'], FILTER_VALIDATE_BOOLEAN ) == true ) {
			$owlcarousel_data[] = 'data-dots="true"';
		}
		if( filter_var( $params[$prefix . 'carousel_autoplay'], FILTER_VALIDATE_BOOLEAN ) == true ) {
			$owlcarousel_data[] = 'data-autoplay="true"';
		}
		if( filter_var( $params[$prefix . 'carousel_loop'], FILTER_VALIDATE_BOOLEAN ) == true ) {
			$owlcarousel_data[] = 'data-loop="true"';
		}

		if( !empty( $params[$prefix . 'animation_speed'] ) ) {
			$owlcarousel_data[] = 'data-duration="' . esc_attr( $params[$prefix . 'animation_speed'] ) . '"';
		}

		if( !empty( $params[$prefix . 'smart_speed'] ) ) {
			$owlcarousel_data[] = 'data-smartspeed="' . esc_attr( $params[$prefix . 'smart_speed'] ) . '"';
		}
		if( $params[$prefix . 'margin'] > -1 ) {
			$owlcarousel_data[] = 'data-margin="' . esc_attr( $params[$prefix . 'margin'] ) . '"';
		}
		if( $params[$prefix . 'stagepadding'] > -1 ) {
			$owlcarousel_data[] = 'data-stagepadding="' . esc_attr( $params[$prefix . 'stagepadding'] ) . '"';
		}
		if( !empty( $params[$prefix . 'laptop'] ) ) {
			$owlcarousel_data[] = 'data-laptop="' . esc_attr( $params[$prefix . 'laptop'] ) . '"';
		}
		if( !empty( $params[$prefix . 'tablet'] ) ) {
			$owlcarousel_data[] = 'data-tablet="' . esc_attr( $params[$prefix . 'tablet'] ) . '"';
		}
		if( filter_var( $params[$prefix . 'center'], FILTER_VALIDATE_BOOLEAN ) == true ) {
			$owlcarousel_data[] = 'data-center="true"';
		}
		if( filter_var( $params[$prefix . 'focused-center-image'], FILTER_VALIDATE_BOOLEAN ) == true ) {
			$owlcarousel_data[] = 'data-focused-center-image="true"';
		}
		if( filter_var( $params[$prefix . 'zoomin-center-image'], FILTER_VALIDATE_BOOLEAN ) == true ) {
			$owlcarousel_data[] = 'data-zoomin-center-image="true"';
		}

		return $owlcarousel_data;
	}
}


if ( ! function_exists( 'ereco_mascot_get_wpml_languages' ) ) {
	/**
	 * Return wpml_languages
	 */
	function ereco_mascot_get_wpml_languages() {
		$wpml = array();
		if(defined('ICL_LANGUAGE_CODE')) {
			$current_language_code = ICL_LANGUAGE_CODE;
			$langs = icl_get_languages('skip_missing=0');

			if(!empty($langs)) {
				if(!empty($langs[$current_language_code])) {
					$current_language = $langs[$current_language_code];
					$wpml[] = array(
						'label' => $current_language['native_name'],
						'url' => $current_language['url'],
						'country_flag_url' => $current_language['country_flag_url'],
					);
				}

				foreach($langs as $lang_key => $lang_info) {
					if($lang_key !== $current_language_code) {
						$wpml[] = array(
							'label' => $lang_info['native_name'],
							'url' => $lang_info['url'],
							'country_flag_url' => $lang_info['country_flag_url'],
						);
					}
				}
			}
		}

		return apply_filters('ereco_mascot_get_wpml_languages', $wpml);
	}
}


if ( ! function_exists( 'ereco_mascot_get_wpml_language_switcher' ) ) {
	/**
	 * Return wpml_language_switcher
	 */
	function ereco_mascot_get_wpml_language_switcher() {

		$element['dropdown'] = ereco_mascot_get_wpml_languages();

		$element_id = ereco_mascot_random_word();

		if( !empty( $element['dropdown'] ) ) {
			$dropdown = ereco_mascot_get_dropdown( $element['dropdown'] );
		}

		if( !empty( $dropdown ) ): ?>
			<div class="dropdown tm-wpml-language-switcher">
				<?php if( !empty( $dropdown['first'] ) ): ?>
					<div class="dropdown-toggle"
						 id="<?php echo esc_attr( $element_id ); ?>"
						 data-toggle="dropdown"
						 aria-haspopup="true"
						 aria-expanded="true"
						 >
						 <img src="<?php echo esc_url( $dropdown['first']['country_flag_url'] ); ?>" height="12" alt="<?php echo esc_attr( $dropdown['first']['label'] ); ?>" width="18" />
						<?php echo esc_html( $dropdown['first']['label'] ); ?>
						<span class="caret"></span>
					</div>
				<?php endif; ?>

				<?php if( !empty( $dropdown['others'] ) ): ?>
					<ul class="dropdown-list dropdown-menu dropdown-menu-right"
						aria-labelledby="<?php echo esc_attr( $element_id ); ?>">
						<?php foreach( $dropdown['others'] as $key => $value): ?>
							<li>
								<a class="dropdown-item" href="<?php echo esc_url( $value['url'] ) ?>">
									<img src="<?php echo esc_url( $value['country_flag_url'] ); ?>" height="12" alt="<?php echo esc_attr( $value['label'] ); ?>" width="18" />
									<?php echo esc_html( $value['label'] ); ?>
								</a>
							</li>
						<?php endforeach; ?>
					</ul>
				<?php endif; ?>
			</div>
		<?php endif; ?>
		<?php
		
	}
}


if ( ! function_exists( 'ereco_mascot_get_dropdown' ) ) {
	/**
	 * Return dropdown
	 */
	function ereco_mascot_get_dropdown( $dropdown ) {
		$choices = array(
			'first' => array(),
			'others' => array()
		);

		if(!empty($dropdown[0]) and !empty($dropdown[0]['label'])) {
			$choices['first'] = $dropdown[0];
		}

		array_shift($dropdown);

		if(!empty($dropdown)) {
			$choices['others'] = $dropdown;
		}

		return $choices;
	}
}


if ( ! function_exists( 'ereco_mascot_get_vc_sidebar_widget_title_line_bottom_style' ) ) {
	/**
	 * Return Sidebar Widget Title Line Bottom Classes
	 */
	function ereco_mascot_get_vc_sidebar_widget_title_line_bottom_style() {
		$classes = array();

		if( ereco_mascot_get_redux_option( 'footer-settings-footer-widget-title-show-line-bottom' ) ) {
			$classes[] = 'widget-title-line-bottom line-bottom-footer-widget';
			$line_bottom_theme_colored = ereco_mascot_get_redux_option( 'footer-settings-footer-widget-title-line-bottom-theme-colored', 1 );
			if( $line_bottom_theme_colored != '' ) {
				$classes[] .= 'line-bottom-theme-colored' . $line_bottom_theme_colored;
			}
		}

		return implode(' ', $classes);
	}
}


if ( ! function_exists( 'ereco_mascot_wp_enqueue_script_lightgallery' ) ) {
	/**
	 * wp_enqueue_script for lightgallery
	 */
	function ereco_mascot_wp_enqueue_script_lightgallery() {
		wp_enqueue_script( 'lightgallery' );
		wp_enqueue_style( 'lightgallery' );
		wp_enqueue_script( 'jquery-mousewheel' );
		wp_enqueue_script( 'ereco-custom-lightgallery' );
	}
}



if ( ! function_exists( 'ereco_mascot_wp_enqueue_script_owl_carousel' ) ) {
	/**
	 * wp_enqueue_script for owl_carousel
	 */
	function ereco_mascot_wp_enqueue_script_owl_carousel() {
		wp_enqueue_script( 'owl-carousel' );
		wp_enqueue_script( 'jquery-owl-filter' );
		wp_enqueue_script( 'owl-carousel2-thumbs' );
	}
}



if ( ! function_exists( 'ereco_mascot_wp_enqueue_script_slick' ) ) {
	/**
	 * wp_enqueue_script for slick
	 */
	function ereco_mascot_wp_enqueue_script_slick() {
		wp_enqueue_script( 'slick' );
		wp_enqueue_style( 'slick' );
		wp_enqueue_style( 'slick-theme' );
	}
}



if ( ! function_exists( 'ereco_mascot_wp_enqueue_script_menuzord_navigation_skin' ) ) {
	/**
	 * wp_enqueue_script for menuzord-navigation-skin
	 */
	function ereco_mascot_wp_enqueue_script_menuzord_navigation_skin() {
		wp_enqueue_style( 'ereco-mascot-menuzord-navigation-skin' );
	}
}



if(!function_exists('ereco_mascot_social_links_colors')) {
	/**
	 * Return Social Links Colors
	 */
	function ereco_mascot_social_links_colors() {
		$social_links_color = array(
			'twitter' => array(
				"name" => "Twitter",
				"icon" => "twitter",
				"color" => "#02B0E8",
			),
			'facebook' => array(
				"name" => "Facebook",
				"icon" => "facebook",
				"color" => "#3B5998",
			),
			'youtube' => array(
				"name" => "Youtube",
				"icon" => "youtube",
				"color" => "#C71F1E",
			),
			'instagram' => array(
				"name" => "Instagram",
				"icon" => "instagram",
				"color" => "#E2002B",
			),
			'google-plus' => array(
				"name" => "Google Plus",
				"icon" => "google-plus",
				"color" => "#D71619",
			),
			'linkedin' => array(
				"name" => "Linkedin",
				"icon" => "linkedin",
				"color" => "#007BB6",
			),
			'tumblr' => array(
				"name" => "Tumblr",
				"icon" => "tumblr",
				"color" => "#35455C",
			),
			'vk' => array(
				"name" => "VK",
				"icon" => "vk",
				"color" => "#4C75A3",
				"target" => "_blank",
			),
			'pinterest' => array(
				"name" => "Pinterest",
				"icon" => "pinterest",
				"color" => "#E71F28",
			),
			'reddit' => array(
				"name" => "Reddit",
				"icon" => "reddit",
				"color" => "#6CC0FF",
			),
			'envelope' => array(
				"name" => "Email",
				"icon" => "envelope-o",
				"color" => "#787482",
			),
			'external-link' => array(
				"name" => "Print",
				"icon" => "external-link",
				"color" => "#333",
			),
		);

		return $social_links_color;
	}
}
if(!function_exists('ereco_mascot_get_social_share_links')) {
	/**
	 * Function that Renders Social Share Links
	 * @return HTML
	 */
	function ereco_mascot_get_social_share_links() {
		if ( ereco_mascot_core_plugin_installed() ) {
			mascot_core_ereco_get_social_share_links();
		}
	}
}