<?php
namespace MascotErecoNamespace\Framework\IconFonts\FontAwesome5;

use MascotErecoNamespace\Framework\IconFonts\Lib;

/**
 * class Ereco_Mascot_Icons_Fontawesome5
 * @package MascotErecoNamespace\Framework\IconFonts\FontAwesome;
 */
if( !class_exists( 'Ereco_Mascot_Icons_Fontawesome5' ) ) {
class Ereco_Mascot_Icons_Fontawesome5 implements Lib\Ereco_Mascot_Interface_IconFonts {
	/**
	 * @var icons
	 * @var socialIcons
	 */
	private $icons;
	
	/**
	 * construct
	 */
	public function __construct() {
		$this->icons = array();
		$this->social_icons = array();
		$this->iconList();
	}
	
	/**
	 * Returns Icon List
	 */
	public function getIconList() {
		return $this->icons;
	}

	private function iconList() {
		$this->icons = array (
			"fab fa-500px" => "500px",
			"fab fa-accessible-icon" => "Accessible Icon",
			"fab fa-accusoft" => "Accusoft",
			"fab fa-acquisitions-incorporated" => "Acquisitions Incorporated",
			"fa fa-ad" => "Ad",
			"fa fa-address-book" => "Address Book",
			"fa fa-address-card" => "Address Card",
			"fa fa-adjust" => "adjust",
			"fab fa-adn" => "App.net",
			"fab fa-adobe" => "Adobe",
			"fab fa-adversal" => "Adversal",
			"fab fa-affiliatetheme" => "affiliatetheme",
			"fa fa-air-freshener" => "Air Freshener",
			"fab fa-airbnb" => "Airbnb",
			"fab fa-algolia" => "Algolia",
			"fa fa-align-center" => "align-center",
			"fa fa-align-justify" => "align-justify",
			"fa fa-align-left" => "align-left",
			"fa fa-align-right" => "align-right",
			"fab fa-alipay" => "Alipay",
			"fa fa-allergies" => "Allergies",
			"fab fa-amazon" => "Amazon",
			"fab fa-amazon-pay" => "Amazon Pay",
			"fa fa-ambulance" => "ambulance",
			"fa fa-american-sign-language-interpreting" => "American Sign Language Interpreting",
			"fab fa-amilia" => "Amilia",
			"fa fa-anchor" => "Anchor",
			"fab fa-android" => "Android",
			"fab fa-angellist" => "AngelList",
			"fa fa-angle-double-down" => "Angle Double Down",
			"fa fa-angle-double-left" => "Angle Double Left",
			"fa fa-angle-double-right" => "Angle Double Right",
			"fa fa-angle-double-up" => "Angle Double Up",
			"fa fa-angle-down" => "angle-down",
			"fa fa-angle-left" => "angle-left",
			"fa fa-angle-right" => "angle-right",
			"fa fa-angle-up" => "angle-up",
			"fa fa-angry" => "Angry Face",
			"fab fa-angrycreative" => "Angry Creative",
			"fab fa-angular" => "Angular",
			"fa fa-ankh" => "Ankh",
			"fab fa-app-store" => "App Store",
			"fab fa-app-store-ios" => "iOS App Store",
			"fab fa-apper" => "Apper Systems AB",
			"fab fa-apple" => "Apple",
			"fa fa-apple-alt" => "Fruit Apple",
			"fab fa-apple-pay" => "Apple Pay",
			"fa fa-archive" => "Archive",
			"fa fa-archway" => "Archway",
			"fa fa-arrow-alt-circle-down" => "Alternate Arrow Circle Down",
			"fa fa-arrow-alt-circle-left" => "Alternate Arrow Circle Left",
			"fa fa-arrow-alt-circle-right" => "Alternate Arrow Circle Right",
			"fa fa-arrow-alt-circle-up" => "Alternate Arrow Circle Up",
			"fa fa-arrow-circle-down" => "Arrow Circle Down",
			"fa fa-arrow-circle-left" => "Arrow Circle Left",
			"fa fa-arrow-circle-right" => "Arrow Circle Right",
			"fa fa-arrow-circle-up" => "Arrow Circle Up",
			"fa fa-arrow-down" => "arrow-down",
			"fa fa-arrow-left" => "arrow-left",
			"fa fa-arrow-right" => "arrow-right",
			"fa fa-arrow-up" => "arrow-up",
			"fa fa-arrows-alt" => "Alternate Arrows",
			"fa fa-arrows-alt-h" => "Alternate Arrows Horizontal",
			"fa fa-arrows-alt-v" => "Alternate Arrows Vertical",
			"fab fa-artstation" => "Artstation",
			"fa fa-assistive-listening-systems" => "Assistive Listening Systems",
			"fa fa-asterisk" => "asterisk",
			"fab fa-asymmetrik" => "Asymmetrik, Ltd.",
			"fa fa-at" => "At",
			"fa fa-atlas" => "Atlas",
			"fab fa-atlassian" => "Atlassian",
			"fa fa-atom" => "Atom",
			"fab fa-audible" => "Audible",
			"fa fa-audio-description" => "Audio Description",
			"fab fa-autoprefixer" => "Autoprefixer",
			"fab fa-avianex" => "avianex",
			"fab fa-aviato" => "Aviato",
			"fa fa-award" => "Award",
			"fab fa-aws" => "Amazon Web Services (AWS)",
			"fa fa-baby" => "Baby",
			"fa fa-baby-carriage" => "Baby Carriage",
			"fa fa-backspace" => "Backspace",
			"fa fa-backward" => "backward",
			"fa fa-bacon" => "Bacon",
			"fa fa-bahai" => "Bahá'í",
			"fa fa-balance-scale" => "Balance Scale",
			"fa fa-balance-scale-left" => "Balance Scale (Left-Weighted)",
			"fa fa-balance-scale-right" => "Balance Scale (Right-Weighted)",
			"fa fa-ban" => "ban",
			"fa fa-band-aid" => "Band-Aid",
			"fab fa-bandcamp" => "Bandcamp",
			"fa fa-barcode" => "barcode",
			"fa fa-bars" => "Bars",
			"fa fa-baseball-ball" => "Baseball Ball",
			"fa fa-basketball-ball" => "Basketball Ball",
			"fa fa-bath" => "Bath",
			"fa fa-battery-empty" => "Battery Empty",
			"fa fa-battery-full" => "Battery Full",
			"fa fa-battery-half" => "Battery 1/2 Full",
			"fa fa-battery-quarter" => "Battery 1/4 Full",
			"fa fa-battery-three-quarters" => "Battery 3/4 Full",
			"fab fa-battle-net" => "Battle.net",
			"fa fa-bed" => "Bed",
			"fa fa-beer" => "beer",
			"fab fa-behance" => "Behance",
			"fab fa-behance-square" => "Behance Square",
			"fa fa-bell" => "bell",
			"fa fa-bell-slash" => "Bell Slash",
			"fa fa-bezier-curve" => "Bezier Curve",
			"fa fa-bible" => "Bible",
			"fa fa-bicycle" => "Bicycle",
			"fa fa-biking" => "Biking",
			"fab fa-bimobject" => "BIMobject",
			"fa fa-binoculars" => "Binoculars",
			"fa fa-biohazard" => "Biohazard",
			"fa fa-birthday-cake" => "Birthday Cake",
			"fab fa-bitbucket" => "Bitbucket",
			"fab fa-bitcoin" => "Bitcoin",
			"fab fa-bity" => "Bity",
			"fab fa-black-tie" => "Font Awesome Black Tie",
			"fab fa-blackberry" => "BlackBerry",
			"fa fa-blender" => "Blender",
			"fa fa-blender-phone" => "Blender Phone",
			"fa fa-blind" => "Blind",
			"fa fa-blog" => "Blog",
			"fab fa-blogger" => "Blogger",
			"fab fa-blogger-b" => "Blogger B",
			"fab fa-bluetooth-b" => "Bluetooth",
			"fa fa-bold" => "bold",
			"fa fa-bolt" => "Lightning Bolt",
			"fa fa-bomb" => "Bomb",
			"fa fa-bone" => "Bone",
			"fa fa-bong" => "Bong",
			"fa fa-book" => "book",
			"fa fa-book-dead" => "Book of the Dead",
			"fa fa-book-medical" => "Medical Book",
			"fa fa-book-open" => "Book Open",
			"fa fa-book-reader" => "Book Reader",
			"fa fa-bookmark" => "bookmark",
			"fab fa-bootstrap" => "Bootstrap",
			"fa fa-border-all" => "Border All",
			"fa fa-border-none" => "Border None",
			"fa fa-border-style" => "Border Style",
			"fa fa-bowling-ball" => "Bowling Ball",
			"fa fa-box" => "Box",
			"fa fa-box-open" => "Box Open",
			"fa fa-boxes" => "Boxes",
			"fa fa-braille" => "Braille",
			"fa fa-brain" => "Brain",
			"fa fa-bread-slice" => "Bread Slice",
			"fa fa-briefcase" => "Briefcase",
			"fa fa-briefcase-medical" => "Medical Briefcase",
			"fa fa-broadcast-tower" => "Broadcast Tower",
			"fa fa-broom" => "Broom",
			"fa fa-brush" => "Brush",
			"fab fa-btc" => "BTC",
			"fab fa-buffer" => "Buffer",
			"fa fa-bug" => "Bug",
			"fa fa-building" => "Building",
			"fa fa-bullhorn" => "bullhorn",
			"fa fa-bullseye" => "Bullseye",
			"fa fa-burn" => "Burn",
			"fab fa-buromobelexperte" => "Büromöbel-Experte GmbH & Co. KG.",
			"fa fa-bus" => "Bus",
			"fa fa-bus-alt" => "Bus Alt",
			"fa fa-business-time" => "Business Time",
			"fab fa-buy-n-large" => "Buy n Large",
			"fab fa-buysellads" => "BuySellAds",
			"fa fa-calculator" => "Calculator",
			"fa fa-calendar" => "Calendar",
			"fa fa-calendar-alt" => "Alternate Calendar",
			"fa fa-calendar-check" => "Calendar Check",
			"fa fa-calendar-day" => "Calendar with Day Focus",
			"fa fa-calendar-minus" => "Calendar Minus",
			"fa fa-calendar-plus" => "Calendar Plus",
			"fa fa-calendar-times" => "Calendar Times",
			"fa fa-calendar-week" => "Calendar with Week Focus",
			"fa fa-camera" => "camera",
			"fa fa-camera-retro" => "Retro Camera",
			"fa fa-campground" => "Campground",
			"fab fa-canadian-maple-leaf" => "Canadian Maple Leaf",
			"fa fa-candy-cane" => "Candy Cane",
			"fa fa-cannabis" => "Cannabis",
			"fa fa-capsules" => "Capsules",
			"fa fa-car" => "Car",
			"fa fa-car-alt" => "Alternate Car",
			"fa fa-car-battery" => "Car Battery",
			"fa fa-car-crash" => "Car Crash",
			"fa fa-car-side" => "Car Side",
			"fa fa-caravan" => "Caravan",
			"fa fa-caret-down" => "Caret Down",
			"fa fa-caret-left" => "Caret Left",
			"fa fa-caret-right" => "Caret Right",
			"fa fa-caret-square-down" => "Caret Square Down",
			"fa fa-caret-square-left" => "Caret Square Left",
			"fa fa-caret-square-right" => "Caret Square Right",
			"fa fa-caret-square-up" => "Caret Square Up",
			"fa fa-caret-up" => "Caret Up",
			"fa fa-carrot" => "Carrot",
			"fa fa-cart-arrow-down" => "Shopping Cart Arrow Down",
			"fa fa-cart-plus" => "Add to Shopping Cart",
			"fa fa-cash-register" => "Cash Register",
			"fa fa-cat" => "Cat",
			"fab fa-cc-amazon-pay" => "Amazon Pay Credit Card",
			"fab fa-cc-amex" => "American Express Credit Card",
			"fab fa-cc-apple-pay" => "Apple Pay Credit Card",
			"fab fa-cc-diners-club" => "Diner's Club Credit Card",
			"fab fa-cc-discover" => "Discover Credit Card",
			"fab fa-cc-jcb" => "JCB Credit Card",
			"fab fa-cc-mastercard" => "MasterCard Credit Card",
			"fab fa-cc-paypal" => "Paypal Credit Card",
			"fab fa-cc-stripe" => "Stripe Credit Card",
			"fab fa-cc-visa" => "Visa Credit Card",
			"fab fa-centercode" => "Centercode",
			"fab fa-centos" => "Centos",
			"fa fa-certificate" => "certificate",
			"fa fa-chair" => "Chair",
			"fa fa-chalkboard" => "Chalkboard",
			"fa fa-chalkboard-teacher" => "Chalkboard Teacher",
			"fa fa-charging-station" => "Charging Station",
			"fa fa-chart-area" => "Area Chart",
			"fa fa-chart-bar" => "Bar Chart",
			"fa fa-chart-line" => "Line Chart",
			"fa fa-chart-pie" => "Pie Chart",
			"fa fa-check" => "Check",
			"fa fa-check-circle" => "Check Circle",
			"fa fa-check-double" => "Double Check",
			"fa fa-check-square" => "Check Square",
			"fa fa-cheese" => "Cheese",
			"fa fa-chess" => "Chess",
			"fa fa-chess-bishop" => "Chess Bishop",
			"fa fa-chess-board" => "Chess Board",
			"fa fa-chess-king" => "Chess King",
			"fa fa-chess-knight" => "Chess Knight",
			"fa fa-chess-pawn" => "Chess Pawn",
			"fa fa-chess-queen" => "Chess Queen",
			"fa fa-chess-rook" => "Chess Rook",
			"fa fa-chevron-circle-down" => "Chevron Circle Down",
			"fa fa-chevron-circle-left" => "Chevron Circle Left",
			"fa fa-chevron-circle-right" => "Chevron Circle Right",
			"fa fa-chevron-circle-up" => "Chevron Circle Up",
			"fa fa-chevron-down" => "chevron-down",
			"fa fa-chevron-left" => "chevron-left",
			"fa fa-chevron-right" => "chevron-right",
			"fa fa-chevron-up" => "chevron-up",
			"fa fa-child" => "Child",
			"fab fa-chrome" => "Chrome",
			"fab fa-chromecast" => "Chromecast",
			"fa fa-church" => "Church",
			"fa fa-circle" => "Circle",
			"fa fa-circle-notch" => "Circle Notched",
			"fa fa-city" => "City",
			"fa fa-clinic-medical" => "Medical Clinic",
			"fa fa-clipboard" => "Clipboard",
			"fa fa-clipboard-check" => "Clipboard with Check",
			"fa fa-clipboard-list" => "Clipboard List",
			"fa fa-clock" => "Clock",
			"fa fa-clone" => "Clone",
			"fa fa-closed-captioning" => "Closed Captioning",
			"fa fa-cloud" => "Cloud",
			"fa fa-cloud-download-alt" => "Alternate Cloud Download",
			"fa fa-cloud-meatball" => "Cloud with (a chance of) Meatball",
			"fa fa-cloud-moon" => "Cloud with Moon",
			"fa fa-cloud-moon-rain" => "Cloud with Moon and Rain",
			"fa fa-cloud-rain" => "Cloud with Rain",
			"fa fa-cloud-showers-heavy" => "Cloud with Heavy Showers",
			"fa fa-cloud-sun" => "Cloud with Sun",
			"fa fa-cloud-sun-rain" => "Cloud with Sun and Rain",
			"fa fa-cloud-upload-alt" => "Alternate Cloud Upload",
			"fab fa-cloudscale" => "cloudscale.ch",
			"fab fa-cloudsmith" => "Cloudsmith",
			"fab fa-cloudversify" => "cloudversify",
			"fa fa-cocktail" => "Cocktail",
			"fa fa-code" => "Code",
			"fa fa-code-branch" => "Code Branch",
			"fab fa-codepen" => "Codepen",
			"fab fa-codiepie" => "Codie Pie",
			"fa fa-coffee" => "Coffee",
			"fa fa-cog" => "cog",
			"fa fa-cogs" => "cogs",
			"fa fa-coins" => "Coins",
			"fa fa-columns" => "Columns",
			"fa fa-comment" => "comment",
			"fa fa-comment-alt" => "Alternate Comment",
			"fa fa-comment-dollar" => "Comment Dollar",
			"fa fa-comment-dots" => "Comment Dots",
			"fa fa-comment-medical" => "Alternate Medical Chat",
			"fa fa-comment-slash" => "Comment Slash",
			"fa fa-comments" => "comments",
			"fa fa-comments-dollar" => "Comments Dollar",
			"fa fa-compact-disc" => "Compact Disc",
			"fa fa-compass" => "Compass",
			"fa fa-compress" => "Compress",
			"fa fa-compress-alt" => "Alternate Compress",
			"fa fa-compress-arrows-alt" => "Alternate Compress Arrows",
			"fa fa-concierge-bell" => "Concierge Bell",
			"fab fa-confluence" => "Confluence",
			"fab fa-connectdevelop" => "Connect Develop",
			"fab fa-contao" => "Contao",
			"fa fa-cookie" => "Cookie",
			"fa fa-cookie-bite" => "Cookie Bite",
			"fa fa-copy" => "Copy",
			"fa fa-copyright" => "Copyright",
			"fab fa-cotton-bureau" => "Cotton Bureau",
			"fa fa-couch" => "Couch",
			"fab fa-cpanel" => "cPanel",
			"fab fa-creative-commons" => "Creative Commons",
			"fab fa-creative-commons-by" => "Creative Commons Attribution",
			"fab fa-creative-commons-nc" => "Creative Commons Noncommercial",
			"fab fa-creative-commons-nc-eu" => "Creative Commons Noncommercial (Euro Sign)",
			"fab fa-creative-commons-nc-jp" => "Creative Commons Noncommercial (Yen Sign)",
			"fab fa-creative-commons-nd" => "Creative Commons No Derivative Works",
			"fab fa-creative-commons-pd" => "Creative Commons Public Domain",
			"fab fa-creative-commons-pd-alt" => "Alternate Creative Commons Public Domain",
			"fab fa-creative-commons-remix" => "Creative Commons Remix",
			"fab fa-creative-commons-sa" => "Creative Commons Share Alike",
			"fab fa-creative-commons-sampling" => "Creative Commons Sampling",
			"fab fa-creative-commons-sampling-plus" => "Creative Commons Sampling +",
			"fab fa-creative-commons-share" => "Creative Commons Share",
			"fab fa-creative-commons-zero" => "Creative Commons CC0",
			"fa fa-credit-card" => "Credit Card",
			"fab fa-critical-role" => "Critical Role",
			"fa fa-crop" => "crop",
			"fa fa-crop-alt" => "Alternate Crop",
			"fa fa-cross" => "Cross",
			"fa fa-crosshairs" => "Crosshairs",
			"fa fa-crow" => "Crow",
			"fa fa-crown" => "Crown",
			"fa fa-crutch" => "Crutch",
			"fab fa-css3" => "CSS 3 Logo",
			"fab fa-css3-alt" => "Alternate CSS3 Logo",
			"fa fa-cube" => "Cube",
			"fa fa-cubes" => "Cubes",
			"fa fa-cut" => "Cut",
			"fab fa-cuttlefish" => "Cuttlefish",
			"fab fa-d-and-d" => "Dungeons & Dragons",
			"fab fa-d-and-d-beyond" => "D&D Beyond",
			"fab fa-dashcube" => "DashCube",
			"fa fa-database" => "Database",
			"fa fa-deaf" => "Deaf",
			"fab fa-delicious" => "Delicious",
			"fa fa-democrat" => "Democrat",
			"fab fa-deploydog" => "deploy.dog",
			"fab fa-deskpro" => "Deskpro",
			"fa fa-desktop" => "Desktop",
			"fab fa-dev" => "DEV",
			"fab fa-deviantart" => "deviantART",
			"fa fa-dharmachakra" => "Dharmachakra",
			"fab fa-dhl" => "DHL",
			"fa fa-diagnoses" => "Diagnoses",
			"fab fa-diaspora" => "Diaspora",
			"fa fa-dice" => "Dice",
			"fa fa-dice-d20" => "Dice D20",
			"fa fa-dice-d6" => "Dice D6",
			"fa fa-dice-five" => "Dice Five",
			"fa fa-dice-four" => "Dice Four",
			"fa fa-dice-one" => "Dice One",
			"fa fa-dice-six" => "Dice Six",
			"fa fa-dice-three" => "Dice Three",
			"fa fa-dice-two" => "Dice Two",
			"fab fa-digg" => "Digg Logo",
			"fab fa-digital-ocean" => "Digital Ocean",
			"fa fa-digital-tachograph" => "Digital Tachograph",
			"fa fa-directions" => "Directions",
			"fab fa-discord" => "Discord",
			"fab fa-discourse" => "Discourse",
			"fa fa-divide" => "Divide",
			"fa fa-dizzy" => "Dizzy Face",
			"fa fa-dna" => "DNA",
			"fab fa-dochub" => "DocHub",
			"fab fa-docker" => "Docker",
			"fa fa-dog" => "Dog",
			"fa fa-dollar-sign" => "Dollar Sign",
			"fa fa-dolly" => "Dolly",
			"fa fa-dolly-flatbed" => "Dolly Flatbed",
			"fa fa-donate" => "Donate",
			"fa fa-door-closed" => "Door Closed",
			"fa fa-door-open" => "Door Open",
			"fa fa-dot-circle" => "Dot Circle",
			"fa fa-dove" => "Dove",
			"fa fa-download" => "Download",
			"fab fa-draft2digital" => "Draft2digital",
			"fa fa-drafting-compass" => "Drafting Compass",
			"fa fa-dragon" => "Dragon",
			"fa fa-draw-polygon" => "Draw Polygon",
			"fab fa-dribbble" => "Dribbble",
			"fab fa-dribbble-square" => "Dribbble Square",
			"fab fa-dropbox" => "Dropbox",
			"fa fa-drum" => "Drum",
			"fa fa-drum-steelpan" => "Drum Steelpan",
			"fa fa-drumstick-bite" => "Drumstick with Bite Taken Out",
			"fab fa-drupal" => "Drupal Logo",
			"fa fa-dumbbell" => "Dumbbell",
			"fa fa-dumpster" => "Dumpster",
			"fa fa-dumpster-fire" => "Dumpster Fire",
			"fa fa-dungeon" => "Dungeon",
			"fab fa-dyalog" => "Dyalog",
			"fab fa-earlybirds" => "Earlybirds",
			"fab fa-ebay" => "eBay",
			"fab fa-edge" => "Edge Browser",
			"fa fa-edit" => "Edit",
			"fa fa-egg" => "Egg",
			"fa fa-eject" => "eject",
			"fab fa-elementor" => "Elementor",
			"fa fa-ellipsis-h" => "Horizontal Ellipsis",
			"fa fa-ellipsis-v" => "Vertical Ellipsis",
			"fab fa-ello" => "Ello",
			"fab fa-ember" => "Ember",
			"fab fa-empire" => "Galactic Empire",
			"fa fa-envelope" => "Envelope",
			"fa fa-envelope-open" => "Envelope Open",
			"fa fa-envelope-open-text" => "Envelope Open-text",
			"fa fa-envelope-square" => "Envelope Square",
			"fab fa-envira" => "Envira Gallery",
			"fa fa-equals" => "Equals",
			"fa fa-eraser" => "eraser",
			"fab fa-erlang" => "Erlang",
			"fab fa-ethereum" => "Ethereum",
			"fa fa-ethernet" => "Ethernet",
			"fab fa-etsy" => "Etsy",
			"fa fa-euro-sign" => "Euro Sign",
			"fab fa-evernote" => "Evernote",
			"fa fa-exchange-alt" => "Alternate Exchange",
			"fa fa-exclamation" => "exclamation",
			"fa fa-exclamation-circle" => "Exclamation Circle",
			"fa fa-exclamation-triangle" => "Exclamation Triangle",
			"fa fa-expand" => "Expand",
			"fa fa-expand-alt" => "Alternate Expand",
			"fa fa-expand-arrows-alt" => "Alternate Expand Arrows",
			"fab fa-expeditedssl" => "ExpeditedSSL",
			"fa fa-external-link-alt" => "Alternate External Link",
			"fa fa-external-link-square-alt" => "Alternate External Link Square",
			"fa fa-eye" => "Eye",
			"fa fa-eye-dropper" => "Eye Dropper",
			"fa fa-eye-slash" => "Eye Slash",
			"fab fa-facebook" => "Facebook",
			"fab fa-facebook-f" => "Facebook F",
			"fab fa-facebook-messenger" => "Facebook Messenger",
			"fab fa-facebook-square" => "Facebook Square",
			"fa fa-fan" => "Fan",
			"fab fa-fantasy-flight-games" => "Fantasy Flight-games",
			"fa fa-fast-backward" => "fast-backward",
			"fa fa-fast-forward" => "fast-forward",
			"fa fa-fax" => "Fax",
			"fa fa-feather" => "Feather",
			"fa fa-feather-alt" => "Alternate Feather",
			"fab fa-fedex" => "FedEx",
			"fab fa-fedora" => "Fedora",
			"fa fa-female" => "Female",
			"fa fa-fighter-jet" => "fighter-jet",
			"fab fa-figma" => "Figma",
			"fa fa-file" => "File",
			"fa fa-file-alt" => "Alternate File",
			"fa fa-file-archive" => "Archive File",
			"fa fa-file-audio" => "Audio File",
			"fa fa-file-code" => "Code File",
			"fa fa-file-contract" => "File Contract",
			"fa fa-file-csv" => "File CSV",
			"fa fa-file-download" => "File Download",
			"fa fa-file-excel" => "Excel File",
			"fa fa-file-export" => "File Export",
			"fa fa-file-image" => "Image File",
			"fa fa-file-import" => "File Import",
			"fa fa-file-invoice" => "File Invoice",
			"fa fa-file-invoice-dollar" => "File Invoice with US Dollar",
			"fa fa-file-medical" => "Medical File",
			"fa fa-file-medical-alt" => "Alternate Medical File",
			"fa fa-file-pdf" => "PDF File",
			"fa fa-file-powerpoint" => "Powerpoint File",
			"fa fa-file-prescription" => "File Prescription",
			"fa fa-file-signature" => "File Signature",
			"fa fa-file-upload" => "File Upload",
			"fa fa-file-video" => "Video File",
			"fa fa-file-word" => "Word File",
			"fa fa-fill" => "Fill",
			"fa fa-fill-drip" => "Fill Drip",
			"fa fa-film" => "Film",
			"fa fa-filter" => "Filter",
			"fa fa-fingerprint" => "Fingerprint",
			"fa fa-fire" => "fire",
			"fa fa-fire-alt" => "Alternate Fire",
			"fa fa-fire-extinguisher" => "fire-extinguisher",
			"fab fa-firefox" => "Firefox",
			"fab fa-firefox-browser" => "Firefox Browser",
			"fa fa-first-aid" => "First Aid",
			"fab fa-first-order" => "First Order",
			"fab fa-first-order-alt" => "Alternate First Order",
			"fab fa-firstdraft" => "firstdraft",
			"fa fa-fish" => "Fish",
			"fa fa-fist-raised" => "Raised Fist",
			"fa fa-flag" => "flag",
			"fa fa-flag-checkered" => "flag-checkered",
			"fa fa-flag-usa" => "United States of America Flag",
			"fa fa-flask" => "Flask",
			"fab fa-flickr" => "Flickr",
			"fab fa-flipboard" => "Flipboard",
			"fa fa-flushed" => "Flushed Face",
			"fab fa-fly" => "Fly",
			"fa fa-folder" => "Folder",
			"fa fa-folder-minus" => "Folder Minus",
			"fa fa-folder-open" => "Folder Open",
			"fa fa-folder-plus" => "Folder Plus",
			"fa fa-font" => "font",
			"fab fa-font-awesome" => "Font Awesome",
			"fab fa-font-awesome-alt" => "Alternate Font Awesome",
			"fab fa-font-awesome-flag" => "Font Awesome Flag",
			"fab fa-font-awesome-logo-full" => "Font Awesome Full Logo",
			"fab fa-fonticons" => "Fonticons",
			"fab fa-fonticons-fi" => "Fonticons Fi",
			"fa fa-football-ball" => "Football Ball",
			"fab fa-fort-awesome" => "Fort Awesome",
			"fab fa-fort-awesome-alt" => "Alternate Fort Awesome",
			"fab fa-forumbee" => "Forumbee",
			"fa fa-forward" => "forward",
			"fab fa-foursquare" => "Foursquare",
			"fab fa-free-code-camp" => "freeCodeCamp",
			"fab fa-freebsd" => "FreeBSD",
			"fa fa-frog" => "Frog",
			"fa fa-frown" => "Frowning Face",
			"fa fa-frown-open" => "Frowning Face With Open Mouth",
			"fab fa-fulcrum" => "Fulcrum",
			"fa fa-funnel-dollar" => "Funnel Dollar",
			"fa fa-futbol" => "Futbol",
			"fab fa-galactic-republic" => "Galactic Republic",
			"fab fa-galactic-senate" => "Galactic Senate",
			"fa fa-gamepad" => "Gamepad",
			"fa fa-gas-pump" => "Gas Pump",
			"fa fa-gavel" => "Gavel",
			"fa fa-gem" => "Gem",
			"fa fa-genderless" => "Genderless",
			"fab fa-get-pocket" => "Get Pocket",
			"fab fa-gg" => "GG Currency",
			"fab fa-gg-circle" => "GG Currency Circle",
			"fa fa-ghost" => "Ghost",
			"fa fa-gift" => "gift",
			"fa fa-gifts" => "Gifts",
			"fab fa-git" => "Git",
			"fab fa-git-alt" => "Git Alt",
			"fab fa-git-square" => "Git Square",
			"fab fa-github" => "GitHub",
			"fab fa-github-alt" => "Alternate GitHub",
			"fab fa-github-square" => "GitHub Square",
			"fab fa-gitkraken" => "GitKraken",
			"fab fa-gitlab" => "GitLab",
			"fab fa-gitter" => "Gitter",
			"fa fa-glass-cheers" => "Glass Cheers",
			"fa fa-glass-martini" => "Martini Glass",
			"fa fa-glass-martini-alt" => "Alternate Glass Martini",
			"fa fa-glass-whiskey" => "Glass Whiskey",
			"fa fa-glasses" => "Glasses",
			"fab fa-glide" => "Glide",
			"fab fa-glide-g" => "Glide G",
			"fa fa-globe" => "Globe",
			"fa fa-globe-africa" => "Globe with Africa shown",
			"fa fa-globe-americas" => "Globe with Americas shown",
			"fa fa-globe-asia" => "Globe with Asia shown",
			"fa fa-globe-europe" => "Globe with Europe shown",
			"fab fa-gofore" => "Gofore",
			"fa fa-golf-ball" => "Golf Ball",
			"fab fa-goodreads" => "Goodreads",
			"fab fa-goodreads-g" => "Goodreads G",
			"fab fa-google" => "Google Logo",
			"fab fa-google-drive" => "Google Drive",
			"fab fa-google-play" => "Google Play",
			"fab fa-google-plus" => "Google Plus",
			"fab fa-google-plus-g" => "Google Plus G",
			"fab fa-google-plus-square" => "Google Plus Square",
			"fab fa-google-wallet" => "Google Wallet",
			"fa fa-gopuram" => "Gopuram",
			"fa fa-graduation-cap" => "Graduation Cap",
			"fab fa-gratipay" => "Gratipay (Gittip)",
			"fab fa-grav" => "Grav",
			"fa fa-greater-than" => "Greater Than",
			"fa fa-greater-than-equal" => "Greater Than Equal To",
			"fa fa-grimace" => "Grimacing Face",
			"fa fa-grin" => "Grinning Face",
			"fa fa-grin-alt" => "Alternate Grinning Face",
			"fa fa-grin-beam" => "Grinning Face With Smiling Eyes",
			"fa fa-grin-beam-sweat" => "Grinning Face With Sweat",
			"fa fa-grin-hearts" => "Smiling Face With Heart-Eyes",
			"fa fa-grin-squint" => "Grinning Squinting Face",
			"fa fa-grin-squint-tears" => "Rolling on the Floor Laughing",
			"fa fa-grin-stars" => "Star-Struck",
			"fa fa-grin-tears" => "Face With Tears of Joy",
			"fa fa-grin-tongue" => "Face With Tongue",
			"fa fa-grin-tongue-squint" => "Squinting Face With Tongue",
			"fa fa-grin-tongue-wink" => "Winking Face With Tongue",
			"fa fa-grin-wink" => "Grinning Winking Face",
			"fa fa-grip-horizontal" => "Grip Horizontal",
			"fa fa-grip-lines" => "Grip Lines",
			"fa fa-grip-lines-vertical" => "Grip Lines Vertical",
			"fa fa-grip-vertical" => "Grip Vertical",
			"fab fa-gripfire" => "Gripfire, Inc.",
			"fab fa-grunt" => "Grunt",
			"fa fa-guitar" => "Guitar",
			"fab fa-gulp" => "Gulp",
			"fa fa-h-square" => "H Square",
			"fab fa-hacker-news" => "Hacker News",
			"fab fa-hacker-news-square" => "Hacker News Square",
			"fab fa-hackerrank" => "Hackerrank",
			"fa fa-hamburger" => "Hamburger",
			"fa fa-hammer" => "Hammer",
			"fa fa-hamsa" => "Hamsa",
			"fa fa-hand-holding" => "Hand Holding",
			"fa fa-hand-holding-heart" => "Hand Holding Heart",
			"fa fa-hand-holding-usd" => "Hand Holding US Dollar",
			"fa fa-hand-lizard" => "Lizard (Hand)",
			"fa fa-hand-middle-finger" => "Hand with Middle Finger Raised",
			"fa fa-hand-paper" => "Paper (Hand)",
			"fa fa-hand-peace" => "Peace (Hand)",
			"fa fa-hand-point-down" => "Hand Pointing Down",
			"fa fa-hand-point-left" => "Hand Pointing Left",
			"fa fa-hand-point-right" => "Hand Pointing Right",
			"fa fa-hand-point-up" => "Hand Pointing Up",
			"fa fa-hand-pointer" => "Pointer (Hand)",
			"fa fa-hand-rock" => "Rock (Hand)",
			"fa fa-hand-scissors" => "Scissors (Hand)",
			"fa fa-hand-spock" => "Spock (Hand)",
			"fa fa-hands" => "Hands",
			"fa fa-hands-helping" => "Helping Hands",
			"fa fa-handshake" => "Handshake",
			"fa fa-hanukiah" => "Hanukiah",
			"fa fa-hard-hat" => "Hard Hat",
			"fa fa-hashtag" => "Hashtag",
			"fa fa-hat-cowboy" => "Cowboy Hat",
			"fa fa-hat-cowboy-side" => "Cowboy Hat Side",
			"fa fa-hat-wizard" => "Wizard's Hat",
			"fa fa-hdd" => "HDD",
			"fa fa-heading" => "heading",
			"fa fa-headphones" => "headphones",
			"fa fa-headphones-alt" => "Alternate Headphones",
			"fa fa-headset" => "Headset",
			"fa fa-heart" => "Heart",
			"fa fa-heart-broken" => "Heart Broken",
			"fa fa-heartbeat" => "Heartbeat",
			"fa fa-helicopter" => "Helicopter",
			"fa fa-highlighter" => "Highlighter",
			"fa fa-hiking" => "Hiking",
			"fa fa-hippo" => "Hippo",
			"fab fa-hips" => "Hips",
			"fab fa-hire-a-helper" => "HireAHelper",
			"fa fa-history" => "History",
			"fa fa-hockey-puck" => "Hockey Puck",
			"fa fa-holly-berry" => "Holly Berry",
			"fa fa-home" => "home",
			"fab fa-hooli" => "Hooli",
			"fab fa-hornbill" => "Hornbill",
			"fa fa-horse" => "Horse",
			"fa fa-horse-head" => "Horse Head",
			"fa fa-hospital" => "hospital",
			"fa fa-hospital-alt" => "Alternate Hospital",
			"fa fa-hospital-symbol" => "Hospital Symbol",
			"fa fa-hot-tub" => "Hot Tub",
			"fa fa-hotdog" => "Hot Dog",
			"fa fa-hotel" => "Hotel",
			"fab fa-hotjar" => "Hotjar",
			"fa fa-hourglass" => "Hourglass",
			"fa fa-hourglass-end" => "Hourglass End",
			"fa fa-hourglass-half" => "Hourglass Half",
			"fa fa-hourglass-start" => "Hourglass Start",
			"fa fa-house-damage" => "Damaged House",
			"fab fa-houzz" => "Houzz",
			"fa fa-hryvnia" => "Hryvnia",
			"fab fa-html5" => "HTML 5 Logo",
			"fab fa-hubspot" => "HubSpot",
			"fa fa-i-cursor" => "I Beam Cursor",
			"fa fa-ice-cream" => "Ice Cream",
			"fa fa-icicles" => "Icicles",
			"fa fa-icons" => "Icons",
			"fa fa-id-badge" => "Identification Badge",
			"fa fa-id-card" => "Identification Card",
			"fa fa-id-card-alt" => "Alternate Identification Card",
			"fab fa-ideal" => "iDeal",
			"fa fa-igloo" => "Igloo",
			"fa fa-image" => "Image",
			"fa fa-images" => "Images",
			"fab fa-imdb" => "IMDB",
			"fa fa-inbox" => "inbox",
			"fa fa-indent" => "Indent",
			"fa fa-industry" => "Industry",
			"fa fa-infinity" => "Infinity",
			"fa fa-info" => "Info",
			"fa fa-info-circle" => "Info Circle",
			"fab fa-instagram" => "Instagram",
			"fab fa-intercom" => "Intercom",
			"fab fa-internet-explorer" => "Internet-explorer",
			"fab fa-invision" => "InVision",
			"fab fa-ioxhost" => "ioxhost",
			"fa fa-italic" => "italic",
			"fab fa-itch-io" => "itch.io",
			"fab fa-itunes" => "iTunes",
			"fab fa-itunes-note" => "Itunes Note",
			"fab fa-java" => "Java",
			"fa fa-jedi" => "Jedi",
			"fab fa-jedi-order" => "Jedi Order",
			"fab fa-jenkins" => "Jenkis",
			"fab fa-jira" => "Jira",
			"fab fa-joget" => "Joget",
			"fa fa-joint" => "Joint",
			"fab fa-joomla" => "Joomla Logo",
			"fa fa-journal-whills" => "Journal of the Whills",
			"fab fa-js" => "JavaScript (JS)",
			"fab fa-js-square" => "JavaScript (JS) Square",
			"fab fa-jsfiddle" => "jsFiddle",
			"fa fa-kaaba" => "Kaaba",
			"fab fa-kaggle" => "Kaggle",
			"fa fa-key" => "key",
			"fab fa-keybase" => "Keybase",
			"fa fa-keyboard" => "Keyboard",
			"fab fa-keycdn" => "KeyCDN",
			"fa fa-khanda" => "Khanda",
			"fab fa-kickstarter" => "Kickstarter",
			"fab fa-kickstarter-k" => "Kickstarter K",
			"fa fa-kiss" => "Kissing Face",
			"fa fa-kiss-beam" => "Kissing Face With Smiling Eyes",
			"fa fa-kiss-wink-heart" => "Face Blowing a Kiss",
			"fa fa-kiwi-bird" => "Kiwi Bird",
			"fab fa-korvue" => "KORVUE",
			"fa fa-landmark" => "Landmark",
			"fa fa-language" => "Language",
			"fa fa-laptop" => "Laptop",
			"fa fa-laptop-code" => "Laptop Code",
			"fa fa-laptop-medical" => "Laptop Medical",
			"fab fa-laravel" => "Laravel",
			"fab fa-lastfm" => "last.fm",
			"fab fa-lastfm-square" => "last.fm Square",
			"fa fa-laugh" => "Grinning Face With Big Eyes",
			"fa fa-laugh-beam" => "Laugh Face with Beaming Eyes",
			"fa fa-laugh-squint" => "Laughing Squinting Face",
			"fa fa-laugh-wink" => "Laughing Winking Face",
			"fa fa-layer-group" => "Layer Group",
			"fa fa-leaf" => "leaf",
			"fab fa-leanpub" => "Leanpub",
			"fa fa-lemon" => "Lemon",
			"fab fa-less" => "Less",
			"fa fa-less-than" => "Less Than",
			"fa fa-less-than-equal" => "Less Than Equal To",
			"fa fa-level-down-alt" => "Alternate Level Down",
			"fa fa-level-up-alt" => "Alternate Level Up",
			"fa fa-life-ring" => "Life Ring",
			"fa fa-lightbulb" => "Lightbulb",
			"fab fa-line" => "Line",
			"fa fa-link" => "Link",
			"fab fa-linkedin" => "LinkedIn",
			"fab fa-linkedin-in" => "LinkedIn In",
			"fab fa-linode" => "Linode",
			"fab fa-linux" => "Linux",
			"fa fa-lira-sign" => "Turkish Lira Sign",
			"fa fa-list" => "List",
			"fa fa-list-alt" => "Alternate List",
			"fa fa-list-ol" => "list-ol",
			"fa fa-list-ul" => "list-ul",
			"fa fa-location-arrow" => "location-arrow",
			"fa fa-lock" => "lock",
			"fa fa-lock-open" => "Lock Open",
			"fa fa-long-arrow-alt-down" => "Alternate Long Arrow Down",
			"fa fa-long-arrow-alt-left" => "Alternate Long Arrow Left",
			"fa fa-long-arrow-alt-right" => "Alternate Long Arrow Right",
			"fa fa-long-arrow-alt-up" => "Alternate Long Arrow Up",
			"fa fa-low-vision" => "Low Vision",
			"fa fa-luggage-cart" => "Luggage Cart",
			"fab fa-lyft" => "lyft",
			"fab fa-magento" => "Magento",
			"fa fa-magic" => "magic",
			"fa fa-magnet" => "magnet",
			"fa fa-mail-bulk" => "Mail Bulk",
			"fab fa-mailchimp" => "Mailchimp",
			"fa fa-male" => "Male",
			"fab fa-mandalorian" => "Mandalorian",
			"fa fa-map" => "Map",
			"fa fa-map-marked" => "Map Marked",
			"fa fa-map-marked-alt" => "Alternate Map Marked",
			"fa fa-map-marker" => "map-marker",
			"fa fa-map-marker-alt" => "Alternate Map Marker",
			"fa fa-map-pin" => "Map Pin",
			"fa fa-map-signs" => "Map Signs",
			"fab fa-markdown" => "Markdown",
			"fa fa-marker" => "Marker",
			"fa fa-mars" => "Mars",
			"fa fa-mars-double" => "Mars Double",
			"fa fa-mars-stroke" => "Mars Stroke",
			"fa fa-mars-stroke-h" => "Mars Stroke Horizontal",
			"fa fa-mars-stroke-v" => "Mars Stroke Vertical",
			"fa fa-mask" => "Mask",
			"fab fa-mastodon" => "Mastodon",
			"fab fa-maxcdn" => "MaxCDN",
			"fab fa-mdb" => "Material Design for Bootstrap",
			"fa fa-medal" => "Medal",
			"fab fa-medapps" => "MedApps",
			"fab fa-medium" => "Medium",
			"fab fa-medium-m" => "Medium M",
			"fa fa-medkit" => "medkit",
			"fab fa-medrt" => "MRT",
			"fab fa-meetup" => "Meetup",
			"fab fa-megaport" => "Megaport",
			"fa fa-meh" => "Neutral Face",
			"fa fa-meh-blank" => "Face Without Mouth",
			"fa fa-meh-rolling-eyes" => "Face With Rolling Eyes",
			"fa fa-memory" => "Memory",
			"fab fa-mendeley" => "Mendeley",
			"fa fa-menorah" => "Menorah",
			"fa fa-mercury" => "Mercury",
			"fa fa-meteor" => "Meteor",
			"fab fa-microblog" => "Micro.blog",
			"fa fa-microchip" => "Microchip",
			"fa fa-microphone" => "microphone",
			"fa fa-microphone-alt" => "Alternate Microphone",
			"fa fa-microphone-alt-slash" => "Alternate Microphone Slash",
			"fa fa-microphone-slash" => "Microphone Slash",
			"fa fa-microscope" => "Microscope",
			"fab fa-microsoft" => "Microsoft",
			"fa fa-minus" => "minus",
			"fa fa-minus-circle" => "Minus Circle",
			"fa fa-minus-square" => "Minus Square",
			"fa fa-mitten" => "Mitten",
			"fab fa-mix" => "Mix",
			"fab fa-mixcloud" => "Mixcloud",
			"fab fa-mizuni" => "Mizuni",
			"fa fa-mobile" => "Mobile Phone",
			"fa fa-mobile-alt" => "Alternate Mobile",
			"fab fa-modx" => "MODX",
			"fab fa-monero" => "Monero",
			"fa fa-money-bill" => "Money Bill",
			"fa fa-money-bill-alt" => "Alternate Money Bill",
			"fa fa-money-bill-wave" => "Wavy Money Bill",
			"fa fa-money-bill-wave-alt" => "Alternate Wavy Money Bill",
			"fa fa-money-check" => "Money Check",
			"fa fa-money-check-alt" => "Alternate Money Check",
			"fa fa-monument" => "Monument",
			"fa fa-moon" => "Moon",
			"fa fa-mortar-pestle" => "Mortar Pestle",
			"fa fa-mosque" => "Mosque",
			"fa fa-motorcycle" => "Motorcycle",
			"fa fa-mountain" => "Mountain",
			"fa fa-mouse" => "Mouse",
			"fa fa-mouse-pointer" => "Mouse Pointer",
			"fa fa-mug-hot" => "Mug Hot",
			"fa fa-music" => "Music",
			"fab fa-napster" => "Napster",
			"fab fa-neos" => "Neos",
			"fa fa-network-wired" => "Wired Network",
			"fa fa-neuter" => "Neuter",
			"fa fa-newspaper" => "Newspaper",
			"fab fa-nimblr" => "Nimblr",
			"fab fa-node" => "Node.js",
			"fab fa-node-js" => "Node.js JS",
			"fa fa-not-equal" => "Not Equal",
			"fa fa-notes-medical" => "Medical Notes",
			"fab fa-npm" => "npm",
			"fab fa-ns8" => "NS8",
			"fab fa-nutritionix" => "Nutritionix",
			"fa fa-object-group" => "Object Group",
			"fa fa-object-ungroup" => "Object Ungroup",
			"fab fa-odnoklassniki" => "Odnoklassniki",
			"fab fa-odnoklassniki-square" => "Odnoklassniki Square",
			"fa fa-oil-can" => "Oil Can",
			"fab fa-old-republic" => "Old Republic",
			"fa fa-om" => "Om",
			"fab fa-opencart" => "OpenCart",
			"fab fa-openid" => "OpenID",
			"fab fa-opera" => "Opera",
			"fab fa-optin-monster" => "Optin Monster",
			"fab fa-orcid" => "ORCID",
			"fab fa-osi" => "Open Source Initiative",
			"fa fa-otter" => "Otter",
			"fa fa-outdent" => "Outdent",
			"fab fa-page4" => "page4 Corporation",
			"fab fa-pagelines" => "Pagelines",
			"fa fa-pager" => "Pager",
			"fa fa-paint-brush" => "Paint Brush",
			"fa fa-paint-roller" => "Paint Roller",
			"fa fa-palette" => "Palette",
			"fab fa-palfed" => "Palfed",
			"fa fa-pallet" => "Pallet",
			"fa fa-paper-plane" => "Paper Plane",
			"fa fa-paperclip" => "Paperclip",
			"fa fa-parachute-box" => "Parachute Box",
			"fa fa-paragraph" => "paragraph",
			"fa fa-parking" => "Parking",
			"fa fa-passport" => "Passport",
			"fa fa-pastafarianism" => "Pastafarianism",
			"fa fa-paste" => "Paste",
			"fab fa-patreon" => "Patreon",
			"fa fa-pause" => "pause",
			"fa fa-pause-circle" => "Pause Circle",
			"fa fa-paw" => "Paw",
			"fab fa-paypal" => "Paypal",
			"fa fa-peace" => "Peace",
			"fa fa-pen" => "Pen",
			"fa fa-pen-alt" => "Alternate Pen",
			"fa fa-pen-fancy" => "Pen Fancy",
			"fa fa-pen-nib" => "Pen Nib",
			"fa fa-pen-square" => "Pen Square",
			"fa fa-pencil-alt" => "Alternate Pencil",
			"fa fa-pencil-ruler" => "Pencil Ruler",
			"fab fa-penny-arcade" => "Penny Arcade",
			"fa fa-people-carry" => "People Carry",
			"fa fa-pepper-hot" => "Hot Pepper",
			"fa fa-percent" => "Percent",
			"fa fa-percentage" => "Percentage",
			"fab fa-periscope" => "Periscope",
			"fa fa-person-booth" => "Person Entering Booth",
			"fab fa-phabricator" => "Phabricator",
			"fab fa-phoenix-framework" => "Phoenix Framework",
			"fab fa-phoenix-squadron" => "Phoenix Squadron",
			"fa fa-phone" => "Phone",
			"fa fa-phone-alt" => "Alternate Phone",
			"fa fa-phone-slash" => "Phone Slash",
			"fa fa-phone-square" => "Phone Square",
			"fa fa-phone-square-alt" => "Alternate Phone Square",
			"fa fa-phone-volume" => "Phone Volume",
			"fa fa-photo-video" => "Photo Video",
			"fab fa-php" => "PHP",
			"fab fa-pied-piper" => "Pied Piper Logo",
			"fab fa-pied-piper-alt" => "Alternate Pied Piper Logo (Old)",
			"fab fa-pied-piper-hat" => "Pied Piper Hat (Old)",
			"fab fa-pied-piper-pp" => "Pied Piper PP Logo (Old)",
			"fab fa-pied-piper-square" => "Pied Piper Square Logo (Old)",
			"fa fa-piggy-bank" => "Piggy Bank",
			"fa fa-pills" => "Pills",
			"fab fa-pinterest" => "Pinterest",
			"fab fa-pinterest-p" => "Pinterest P",
			"fab fa-pinterest-square" => "Pinterest Square",
			"fa fa-pizza-slice" => "Pizza Slice",
			"fa fa-place-of-worship" => "Place of Worship",
			"fa fa-plane" => "plane",
			"fa fa-plane-arrival" => "Plane Arrival",
			"fa fa-plane-departure" => "Plane Departure",
			"fa fa-play" => "play",
			"fa fa-play-circle" => "Play Circle",
			"fab fa-playstation" => "PlayStation",
			"fa fa-plug" => "Plug",
			"fa fa-plus" => "plus",
			"fa fa-plus-circle" => "Plus Circle",
			"fa fa-plus-square" => "Plus Square",
			"fa fa-podcast" => "Podcast",
			"fa fa-poll" => "Poll",
			"fa fa-poll-h" => "Poll H",
			"fa fa-poo" => "Poo",
			"fa fa-poo-storm" => "Poo Storm",
			"fa fa-poop" => "Poop",
			"fa fa-portrait" => "Portrait",
			"fa fa-pound-sign" => "Pound Sign",
			"fa fa-power-off" => "Power Off",
			"fa fa-pray" => "Pray",
			"fa fa-praying-hands" => "Praying Hands",
			"fa fa-prescription" => "Prescription",
			"fa fa-prescription-bottle" => "Prescription Bottle",
			"fa fa-prescription-bottle-alt" => "Alternate Prescription Bottle",
			"fa fa-print" => "print",
			"fa fa-procedures" => "Procedures",
			"fab fa-product-hunt" => "Product Hunt",
			"fa fa-project-diagram" => "Project Diagram",
			"fab fa-pushed" => "Pushed",
			"fa fa-puzzle-piece" => "Puzzle Piece",
			"fab fa-python" => "Python",
			"fab fa-qq" => "QQ",
			"fa fa-qrcode" => "qrcode",
			"fa fa-question" => "Question",
			"fa fa-question-circle" => "Question Circle",
			"fa fa-quidditch" => "Quidditch",
			"fab fa-quinscape" => "QuinScape",
			"fab fa-quora" => "Quora",
			"fa fa-quote-left" => "quote-left",
			"fa fa-quote-right" => "quote-right",
			"fa fa-quran" => "Quran",
			"fab fa-r-project" => "R Project",
			"fa fa-radiation" => "Radiation",
			"fa fa-radiation-alt" => "Alternate Radiation",
			"fa fa-rainbow" => "Rainbow",
			"fa fa-random" => "random",
			"fab fa-raspberry-pi" => "Raspberry Pi",
			"fab fa-ravelry" => "Ravelry",
			"fab fa-react" => "React",
			"fab fa-reacteurope" => "ReactEurope",
			"fab fa-readme" => "ReadMe",
			"fab fa-rebel" => "Rebel Alliance",
			"fa fa-receipt" => "Receipt",
			"fa fa-record-vinyl" => "Record Vinyl",
			"fa fa-recycle" => "Recycle",
			"fab fa-red-river" => "red river",
			"fab fa-reddit" => "reddit Logo",
			"fab fa-reddit-alien" => "reddit Alien",
			"fab fa-reddit-square" => "reddit Square",
			"fab fa-redhat" => "Redhat",
			"fa fa-redo" => "Redo",
			"fa fa-redo-alt" => "Alternate Redo",
			"fa fa-registered" => "Registered Trademark",
			"fa fa-remove-format" => "Remove Format",
			"fab fa-renren" => "Renren",
			"fa fa-reply" => "Reply",
			"fa fa-reply-all" => "reply-all",
			"fab fa-replyd" => "replyd",
			"fa fa-republican" => "Republican",
			"fab fa-researchgate" => "Researchgate",
			"fab fa-resolving" => "Resolving",
			"fa fa-restroom" => "Restroom",
			"fa fa-retweet" => "Retweet",
			"fab fa-rev" => "Rev.io",
			"fa fa-ribbon" => "Ribbon",
			"fa fa-ring" => "Ring",
			"fa fa-road" => "road",
			"fa fa-robot" => "Robot",
			"fa fa-rocket" => "rocket",
			"fab fa-rocketchat" => "Rocket.Chat",
			"fab fa-rockrms" => "Rockrms",
			"fa fa-route" => "Route",
			"fa fa-rss" => "rss",
			"fa fa-rss-square" => "RSS Square",
			"fa fa-ruble-sign" => "Ruble Sign",
			"fa fa-ruler" => "Ruler",
			"fa fa-ruler-combined" => "Ruler Combined",
			"fa fa-ruler-horizontal" => "Ruler Horizontal",
			"fa fa-ruler-vertical" => "Ruler Vertical",
			"fa fa-running" => "Running",
			"fa fa-rupee-sign" => "Indian Rupee Sign",
			"fa fa-sad-cry" => "Crying Face",
			"fa fa-sad-tear" => "Loudly Crying Face",
			"fab fa-safari" => "Safari",
			"fab fa-salesforce" => "Salesforce",
			"fab fa-sass" => "Sass",
			"fa fa-satellite" => "Satellite",
			"fa fa-satellite-dish" => "Satellite Dish",
			"fa fa-save" => "Save",
			"fab fa-schlix" => "SCHLIX",
			"fa fa-school" => "School",
			"fa fa-screwdriver" => "Screwdriver",
			"fab fa-scribd" => "Scribd",
			"fa fa-scroll" => "Scroll",
			"fa fa-sd-card" => "Sd Card",
			"fa fa-search" => "Search",
			"fa fa-search-dollar" => "Search Dollar",
			"fa fa-search-location" => "Search Location",
			"fa fa-search-minus" => "Search Minus",
			"fa fa-search-plus" => "Search Plus",
			"fab fa-searchengin" => "Searchengin",
			"fa fa-seedling" => "Seedling",
			"fab fa-sellcast" => "Sellcast",
			"fab fa-sellsy" => "Sellsy",
			"fa fa-server" => "Server",
			"fab fa-servicestack" => "Servicestack",
			"fa fa-shapes" => "Shapes",
			"fa fa-share" => "Share",
			"fa fa-share-alt" => "Alternate Share",
			"fa fa-share-alt-square" => "Alternate Share Square",
			"fa fa-share-square" => "Share Square",
			"fa fa-shekel-sign" => "Shekel Sign",
			"fa fa-shield-alt" => "Alternate Shield",
			"fa fa-ship" => "Ship",
			"fa fa-shipping-fast" => "Shipping Fast",
			"fab fa-shirtsinbulk" => "Shirts in Bulk",
			"fa fa-shoe-prints" => "Shoe Prints",
			"fa fa-shopping-bag" => "Shopping Bag",
			"fa fa-shopping-basket" => "Shopping Basket",
			"fa fa-shopping-cart" => "shopping-cart",
			"fab fa-shopware" => "Shopware",
			"fa fa-shower" => "Shower",
			"fa fa-shuttle-van" => "Shuttle Van",
			"fa fa-sign" => "Sign",
			"fa fa-sign-in-alt" => "Alternate Sign In",
			"fa fa-sign-language" => "Sign Language",
			"fa fa-sign-out-alt" => "Alternate Sign Out",
			"fa fa-signal" => "signal",
			"fa fa-signature" => "Signature",
			"fa fa-sim-card" => "SIM Card",
			"fab fa-simplybuilt" => "SimplyBuilt",
			"fab fa-sistrix" => "SISTRIX",
			"fa fa-sitemap" => "Sitemap",
			"fab fa-sith" => "Sith",
			"fa fa-skating" => "Skating",
			"fab fa-sketch" => "Sketch",
			"fa fa-skiing" => "Skiing",
			"fa fa-skiing-nordic" => "Skiing Nordic",
			"fa fa-skull" => "Skull",
			"fa fa-skull-crossbones" => "Skull & Crossbones",
			"fab fa-skyatlas" => "skyatlas",
			"fab fa-skype" => "Skype",
			"fab fa-slack" => "Slack Logo",
			"fab fa-slack-hash" => "Slack Hashtag",
			"fa fa-slash" => "Slash",
			"fa fa-sleigh" => "Sleigh",
			"fa fa-sliders-h" => "Horizontal Sliders",
			"fab fa-slideshare" => "Slideshare",
			"fa fa-smile" => "Smiling Face",
			"fa fa-smile-beam" => "Beaming Face With Smiling Eyes",
			"fa fa-smile-wink" => "Winking Face",
			"fa fa-smog" => "Smog",
			"fa fa-smoking" => "Smoking",
			"fa fa-smoking-ban" => "Smoking Ban",
			"fa fa-sms" => "SMS",
			"fab fa-snapchat" => "Snapchat",
			"fab fa-snapchat-ghost" => "Snapchat Ghost",
			"fab fa-snapchat-square" => "Snapchat Square",
			"fa fa-snowboarding" => "Snowboarding",
			"fa fa-snowflake" => "Snowflake",
			"fa fa-snowman" => "Snowman",
			"fa fa-snowplow" => "Snowplow",
			"fa fa-socks" => "Socks",
			"fa fa-solar-panel" => "Solar Panel",
			"fa fa-sort" => "Sort",
			"fa fa-sort-alpha-down" => "Sort Alphabetical Down",
			"fa fa-sort-alpha-down-alt" => "Alternate Sort Alphabetical Down",
			"fa fa-sort-alpha-up" => "Sort Alphabetical Up",
			"fa fa-sort-alpha-up-alt" => "Alternate Sort Alphabetical Up",
			"fa fa-sort-amount-down" => "Sort Amount Down",
			"fa fa-sort-amount-down-alt" => "Alternate Sort Amount Down",
			"fa fa-sort-amount-up" => "Sort Amount Up",
			"fa fa-sort-amount-up-alt" => "Alternate Sort Amount Up",
			"fa fa-sort-down" => "Sort Down (Descending)",
			"fa fa-sort-numeric-down" => "Sort Numeric Down",
			"fa fa-sort-numeric-down-alt" => "Alternate Sort Numeric Down",
			"fa fa-sort-numeric-up" => "Sort Numeric Up",
			"fa fa-sort-numeric-up-alt" => "Alternate Sort Numeric Up",
			"fa fa-sort-up" => "Sort Up (Ascending)",
			"fab fa-soundcloud" => "SoundCloud",
			"fab fa-sourcetree" => "Sourcetree",
			"fa fa-spa" => "Spa",
			"fa fa-space-shuttle" => "Space Shuttle",
			"fab fa-speakap" => "Speakap",
			"fab fa-speaker-deck" => "Speaker Deck",
			"fa fa-spell-check" => "Spell Check",
			"fa fa-spider" => "Spider",
			"fa fa-spinner" => "Spinner",
			"fa fa-splotch" => "Splotch",
			"fab fa-spotify" => "Spotify",
			"fa fa-spray-can" => "Spray Can",
			"fa fa-square" => "Square",
			"fa fa-square-full" => "Square Full",
			"fa fa-square-root-alt" => "Alternate Square Root",
			"fab fa-squarespace" => "Squarespace",
			"fab fa-stack-exchange" => "Stack Exchange",
			"fab fa-stack-overflow" => "Stack Overflow",
			"fab fa-stackpath" => "Stackpath",
			"fa fa-stamp" => "Stamp",
			"fa fa-star" => "Star",
			"fa fa-star-and-crescent" => "Star and Crescent",
			"fa fa-star-half" => "star-half",
			"fa fa-star-half-alt" => "Alternate Star Half",
			"fa fa-star-of-david" => "Star of David",
			"fa fa-star-of-life" => "Star of Life",
			"fab fa-staylinked" => "StayLinked",
			"fab fa-steam" => "Steam",
			"fab fa-steam-square" => "Steam Square",
			"fab fa-steam-symbol" => "Steam Symbol",
			"fa fa-step-backward" => "step-backward",
			"fa fa-step-forward" => "step-forward",
			"fa fa-stethoscope" => "Stethoscope",
			"fab fa-sticker-mule" => "Sticker Mule",
			"fa fa-sticky-note" => "Sticky Note",
			"fa fa-stop" => "stop",
			"fa fa-stop-circle" => "Stop Circle",
			"fa fa-stopwatch" => "Stopwatch",
			"fa fa-store" => "Store",
			"fa fa-store-alt" => "Alternate Store",
			"fab fa-strava" => "Strava",
			"fa fa-stream" => "Stream",
			"fa fa-street-view" => "Street View",
			"fa fa-strikethrough" => "Strikethrough",
			"fab fa-stripe" => "Stripe",
			"fab fa-stripe-s" => "Stripe S",
			"fa fa-stroopwafel" => "Stroopwafel",
			"fab fa-studiovinari" => "Studio Vinari",
			"fab fa-stumbleupon" => "StumbleUpon Logo",
			"fab fa-stumbleupon-circle" => "StumbleUpon Circle",
			"fa fa-subscript" => "subscript",
			"fa fa-subway" => "Subway",
			"fa fa-suitcase" => "Suitcase",
			"fa fa-suitcase-rolling" => "Suitcase Rolling",
			"fa fa-sun" => "Sun",
			"fab fa-superpowers" => "Superpowers",
			"fa fa-superscript" => "superscript",
			"fab fa-supple" => "Supple",
			"fa fa-surprise" => "Hushed Face",
			"fab fa-suse" => "Suse",
			"fa fa-swatchbook" => "Swatchbook",
			"fab fa-swift" => "Swift",
			"fa fa-swimmer" => "Swimmer",
			"fa fa-swimming-pool" => "Swimming Pool",
			"fab fa-symfony" => "Symfony",
			"fa fa-synagogue" => "Synagogue",
			"fa fa-sync" => "Sync",
			"fa fa-sync-alt" => "Alternate Sync",
			"fa fa-syringe" => "Syringe",
			"fa fa-table" => "table",
			"fa fa-table-tennis" => "Table Tennis",
			"fa fa-tablet" => "tablet",
			"fa fa-tablet-alt" => "Alternate Tablet",
			"fa fa-tablets" => "Tablets",
			"fa fa-tachometer-alt" => "Alternate Tachometer",
			"fa fa-tag" => "tag",
			"fa fa-tags" => "tags",
			"fa fa-tape" => "Tape",
			"fa fa-tasks" => "Tasks",
			"fa fa-taxi" => "Taxi",
			"fab fa-teamspeak" => "TeamSpeak",
			"fa fa-teeth" => "Teeth",
			"fa fa-teeth-open" => "Teeth Open",
			"fab fa-telegram" => "Telegram",
			"fab fa-telegram-plane" => "Telegram Plane",
			"fa fa-temperature-high" => "High Temperature",
			"fa fa-temperature-low" => "Low Temperature",
			"fab fa-tencent-weibo" => "Tencent Weibo",
			"fa fa-tenge" => "Tenge",
			"fa fa-terminal" => "Terminal",
			"fa fa-text-height" => "text-height",
			"fa fa-text-width" => "Text Width",
			"fa fa-th" => "th",
			"fa fa-th-large" => "th-large",
			"fa fa-th-list" => "th-list",
			"fab fa-the-red-yeti" => "The Red Yeti",
			"fa fa-theater-masks" => "Theater Masks",
			"fab fa-themeco" => "Themeco",
			"fab fa-themeisle" => "ThemeIsle",
			"fa fa-thermometer" => "Thermometer",
			"fa fa-thermometer-empty" => "Thermometer Empty",
			"fa fa-thermometer-full" => "Thermometer Full",
			"fa fa-thermometer-half" => "Thermometer 1/2 Full",
			"fa fa-thermometer-quarter" => "Thermometer 1/4 Full",
			"fa fa-thermometer-three-quarters" => "Thermometer 3/4 Full",
			"fab fa-think-peaks" => "Think Peaks",
			"fa fa-thumbs-down" => "thumbs-down",
			"fa fa-thumbs-up" => "thumbs-up",
			"fa fa-thumbtack" => "Thumbtack",
			"fa fa-ticket-alt" => "Alternate Ticket",
			"fa fa-times" => "Times",
			"fa fa-times-circle" => "Times Circle",
			"fa fa-tint" => "tint",
			"fa fa-tint-slash" => "Tint Slash",
			"fa fa-tired" => "Tired Face",
			"fa fa-toggle-off" => "Toggle Off",
			"fa fa-toggle-on" => "Toggle On",
			"fa fa-toilet" => "Toilet",
			"fa fa-toilet-paper" => "Toilet Paper",
			"fa fa-toolbox" => "Toolbox",
			"fa fa-tools" => "Tools",
			"fa fa-tooth" => "Tooth",
			"fa fa-torah" => "Torah",
			"fa fa-torii-gate" => "Torii Gate",
			"fa fa-tractor" => "Tractor",
			"fab fa-trade-federation" => "Trade Federation",
			"fa fa-trademark" => "Trademark",
			"fa fa-traffic-light" => "Traffic Light",
			"fa fa-trailer" => "Trailer",
			"fa fa-train" => "Train",
			"fa fa-tram" => "Tram",
			"fa fa-transgender" => "Transgender",
			"fa fa-transgender-alt" => "Alternate Transgender",
			"fa fa-trash" => "Trash",
			"fa fa-trash-alt" => "Alternate Trash",
			"fa fa-trash-restore" => "Trash Restore",
			"fa fa-trash-restore-alt" => "Alternative Trash Restore",
			"fa fa-tree" => "Tree",
			"fab fa-trello" => "Trello",
			"fab fa-tripadvisor" => "TripAdvisor",
			"fa fa-trophy" => "trophy",
			"fa fa-truck" => "truck",
			"fa fa-truck-loading" => "Truck Loading",
			"fa fa-truck-monster" => "Truck Monster",
			"fa fa-truck-moving" => "Truck Moving",
			"fa fa-truck-pickup" => "Truck Side",
			"fa fa-tshirt" => "T-Shirt",
			"fa fa-tty" => "TTY",
			"fab fa-tumblr" => "Tumblr",
			"fab fa-tumblr-square" => "Tumblr Square",
			"fa fa-tv" => "Television",
			"fab fa-twitch" => "Twitch",
			"fab fa-twitter" => "Twitter",
			"fab fa-twitter-square" => "Twitter Square",
			"fab fa-typo3" => "Typo3",
			"fab fa-uber" => "Uber",
			"fab fa-ubuntu" => "Ubuntu",
			"fab fa-uikit" => "UIkit",
			"fab fa-umbraco" => "Umbraco",
			"fa fa-umbrella" => "Umbrella",
			"fa fa-umbrella-beach" => "Umbrella Beach",
			"fa fa-underline" => "Underline",
			"fa fa-undo" => "Undo",
			"fa fa-undo-alt" => "Alternate Undo",
			"fab fa-uniregistry" => "Uniregistry",
			"fab fa-unity" => "Unity 3D",
			"fa fa-universal-access" => "Universal Access",
			"fa fa-university" => "University",
			"fa fa-unlink" => "unlink",
			"fa fa-unlock" => "unlock",
			"fa fa-unlock-alt" => "Alternate Unlock",
			"fab fa-untappd" => "Untappd",
			"fa fa-upload" => "Upload",
			"fab fa-ups" => "UPS",
			"fab fa-usb" => "USB",
			"fa fa-user" => "User",
			"fa fa-user-alt" => "Alternate User",
			"fa fa-user-alt-slash" => "Alternate User Slash",
			"fa fa-user-astronaut" => "User Astronaut",
			"fa fa-user-check" => "User Check",
			"fa fa-user-circle" => "User Circle",
			"fa fa-user-clock" => "User Clock",
			"fa fa-user-cog" => "User Cog",
			"fa fa-user-edit" => "User Edit",
			"fa fa-user-friends" => "User Friends",
			"fa fa-user-graduate" => "User Graduate",
			"fa fa-user-injured" => "User Injured",
			"fa fa-user-lock" => "User Lock",
			"fa fa-user-md" => "Doctor",
			"fa fa-user-minus" => "User Minus",
			"fa fa-user-ninja" => "User Ninja",
			"fa fa-user-nurse" => "Nurse",
			"fa fa-user-plus" => "User Plus",
			"fa fa-user-secret" => "User Secret",
			"fa fa-user-shield" => "User Shield",
			"fa fa-user-slash" => "User Slash",
			"fa fa-user-tag" => "User Tag",
			"fa fa-user-tie" => "User Tie",
			"fa fa-user-times" => "Remove User",
			"fa fa-users" => "Users",
			"fa fa-users-cog" => "Users Cog",
			"fab fa-usps" => "United States Postal Service",
			"fab fa-ussunnah" => "us-Sunnah Foundation",
			"fa fa-utensil-spoon" => "Utensil Spoon",
			"fa fa-utensils" => "Utensils",
			"fab fa-vaadin" => "Vaadin",
			"fa fa-vector-square" => "Vector Square",
			"fa fa-venus" => "Venus",
			"fa fa-venus-double" => "Venus Double",
			"fa fa-venus-mars" => "Venus Mars",
			"fab fa-viacoin" => "Viacoin",
			"fa fa-video" => "Video",
			"fab fa-viadeo-square" => "Video Square",
			"fa fa-vial" => "Vial",
			"fa fa-vials" => "Vials",
			"fab fa-viber" => "Viber",
			"fa fa-video-slash" => "Video Slash",
			"fa fa-vihara" => "Vihara",
			"fab fa-vimeo-v" => "Vimeo",
			"fab fa-vimeo-square" => "Vimeo Square",
			"fab fa-vine" => "Vine",
			"fab fa-vk" => "VK",
			"fab fa-vnv" => "VNV",
			"fa fa-voicemail" => "Voicemail",
			"fa fa-volleyball-ball" => "Volleyball Ball",
			"fa fa-volume-down" => "Volume Down",
			"fa fa-volume-mute" => "Volume Mute",
			"fa fa-volume-off" => "Volume Off",
			"fa fa-volume-up" => "Volume Up",
			"fa fa-vote-yea" => "Vote Yea",
			"fa fa-vr-cardboard" => "Cardboard VR",
			"fab fa-vuejs" => "Vue.js",
			"fa fa-walking" => "Walking",
			"fa fa-wallet" => "Wallet",
			"fa fa-warehouse" => "Warehouse",
			"fa fa-water" => "Water",
			"fa fa-wave-square" => "Square Wave",
			"fab fa-waze" => "Waze",
			"fab fa-weebly" => "Weebly",
			"fab fa-weibo" => "Weibo",
			"fa fa-weight" => "Weight",
			"fa fa-weight-hanging" => "Hanging Weight",
			"fab fa-weixin" => "Weixin (WeChat)",
			"fab fa-whatsapp" => "What's App",
			"fab fa-whatsapp-square" => "What's App Square",
			"fa fa-wheelchair" => "Wheelchair",
			"fab fa-whmcs" => "WHMCS",
			"fa fa-wifi" => "WiFi",
			"fab fa-wikipedia-w" => "Wikipedia W",
			"fa fa-wind" => "Wind",
			"fa fa-window-close" => "Window Close",
			"fa fa-window-maximize" => "Window Maximize",
			"fa fa-window-minimize" => "Window Minimize",
			"fa fa-window-restore" => "Window Restore",
			"fab fa-windows" => "Windows",
			"fa fa-wine-bottle" => "Wine Bottle",
			"fa fa-wine-glass" => "Wine Glass",
			"fa fa-wine-glass-alt" => "Alternate Wine Glas",
			"fab fa-wix" => "Wix",
			"fab fa-wizards-of-the-coast" => "Wizards of the Coast",
			"fab fa-wolf-pack-battalion" => "Wolf Pack Battalion",
			"fa fa-won-sign" => "Won Sign",
			"fab fa-wordpress" => "WordPress Logo",
			"fab fa-wordpress-simple" => "Wordpress Simple",
			"fab fa-wpbeginner" => "WPBeginner",
			"fab fa-wpexplorer" => "WPExplorer",
			"fab fa-wpforms" => "WPForms",
			"fab fa-wpressr" => "wpressr",
			"fa fa-wrench" => "Wrench",
			"fa fa-x-ray" => "X-Ray",
			"fab fa-xbox" => "Xbox",
			"fab fa-xing" => "Xing",
			"fab fa-xing-square" => "Xing Square",
			"fab fa-y-combinator" => "Y Combinator",
			"fab fa-yahoo" => "Yahoo Logo",
			"fab fa-yammer" => "Yammer",
			"fab fa-yandex" => "Yandex",
			"fab fa-yandex-international" => "Yandex International",
			"fab fa-yarn" => "Yarn",
			"fab fa-yelp" => "Yelp",
			"fa fa-yen-sign" => "Yen Sign",
			"fa fa-yin-yang" => "Yin Yang",
			"fab fa-yoast" => "Yoast",
			"fab fa-youtube" => "YouTube",
			"fab fa-youtube-square" => "YouTube Square",
			"fab fa-zhihu" => "Zhihu",
		);
	}
	
	/**
	* Check if the font package has Social Icons
	*/
	public function hasSocialIcons() {
		return false;
	}
}
}