<?php

use MascotErecoNamespace\Framework\IconFonts\Lib;
use MascotErecoNamespace\Framework\IconFonts\FontAwesome\Ereco_Mascot_Icons_Fontawesome;
use MascotErecoNamespace\Framework\IconFonts\FontAwesome5\Ereco_Mascot_Icons_Fontawesome5;
use MascotErecoNamespace\Framework\IconFonts\Elegant\Ereco_Mascot_Icons_Elegant;
use MascotErecoNamespace\Framework\IconFonts\IcoMoon\Ereco_Mascot_Icons_IcoMoon;
use MascotErecoNamespace\Framework\IconFonts\SevenStroke\Ereco_Mascot_Icons_SevenStroke;
use MascotErecoNamespace\Framework\IconFonts\FlatIconSetCurrentTheme\Ereco_Mascot_Icons_FlatIconSetCurrentTheme;
use MascotErecoNamespace\Framework\IconFonts\FlatIconSetContact\Ereco_Mascot_Icons_FlatIconSetContact;
use MascotErecoNamespace\Framework\IconFonts\FlatIconShop\Ereco_Mascot_Icons_FlatIconShop;

/**
 * class RegIconFonts
 */
class RegIconFonts {
	/**
	 * @var Singleton The reference to *Singleton* instance of this class
	 */
	private static $instance;

	/**
	 * @var array
	 */
	private $allIconFontPacks = array();

	/**
	 * Returns the *Singleton* instance of this class.
	 *
	 * @return Singleton The *Singleton* instance.
	 */
	public static function getInstance()
	{
		if (null === static::$instance) {
			static::$instance = new static();
		}

		return static::$instance;
	}

	/**
	 * Protected constructor to prevent creating a new instance of the
	 * *Singleton* via the `new` operator from outside of this class.
	 */
	protected function __construct()
	{
		$this->allIconFontPacksToReg();
	}

	/**
	 * Private clone method to prevent cloning of the instance of the
	 * *Singleton* instance.
	 *
	 * @return void
	 */
	private function __clone()
	{
	}

	/**
	 * Private unserialize method to prevent unserializing of the *Singleton*
	 * instance.
	 *
	 * @return void
	 */
	public function __wakeup()
	{
	}

	/**
	 * Add each Icon Font Pack to array
	 */
	public function addIconFontPack($key, $name, $value) {
		$this->allIconFontPacks[$key]['name'] = $name;
		$this->allIconFontPacks[$key]['value'] = $value;
	}

	/**
	 * List of all Icon Font Packs to register
	 */
	private function allIconFontPacksToReg() {
		$this->addIconFontPack('font_awesome', 'FontAwesome',  new Ereco_Mascot_Icons_Fontawesome());
		$this->addIconFontPack('font_awesome5', 'FontAwesome5',  new Ereco_Mascot_Icons_Fontawesome5());

		if( ereco_mascot_get_redux_option( 'page-settings-use-elegant-icons' ) ) {
			$this->addIconFontPack('elegant', 'Elegant Icons', new Ereco_Mascot_Icons_Elegant());
		}

		if( ereco_mascot_get_redux_option( 'page-settings-use-icomoon' ) ) {
			$this->addIconFontPack('icomoon', 'IcoMoon', new Ereco_Mascot_Icons_IcoMoon());
		}

		if( ereco_mascot_get_redux_option( 'page-settings-use-pe-icon-7-stroke' ) ) {
			$this->addIconFontPack('seven_stroke', '7 Stroke Icons', new Ereco_Mascot_Icons_SevenStroke());
		}

		if( ereco_mascot_get_redux_option( 'page-settings-use-flaticon-current-theme' ) ) {
			$this->addIconFontPack('flaticon_set_current_theme', 'Flaticon Set Current Theme', new Ereco_Mascot_Icons_FlatIconSetCurrentTheme());
		}

		if( ereco_mascot_get_redux_option( 'page-settings-use-flaticon-contact' ) ) {
			$this->addIconFontPack('flaticon_set_contact', 'Flaticon Set Contact', new Ereco_Mascot_Icons_FlatIconSetContact());
		}

		if( ereco_mascot_get_redux_option( 'page-settings-use-flaticon-shop' ) ) {
			$this->addIconFontPack('flaticon_shop', 'Flaticon Shop', new Ereco_Mascot_Icons_FlatIconShop());
		}
	}

	/**
	 * Get Icon Font Pack by Key
	 */
	public function getIconFontPackByKey($key) {
		if(array_key_exists($key, $this->allIconFontPacks)) {
			return $this->allIconFontPacks[$key]['value'];
		}
		return false;
	}

	/**
	 * Get key of all Icon Font Packs
	 */
	public function getIconFontPackKeys() {
		return array_keys($this->allIconFontPacks);
	}

	/**
	 * Get Icon Font Pack Names Array
	 */
	public function getIconFontPackNamesAarray() {
		$font_array = array();

		foreach($this->allIconFontPacks as $key => $icon_pack) {
			$font_array[$key] = $icon_pack['name'];
		}
		return $font_array;
	}
}

//create global variable $ereco_mascot_icon_font_packs
if ( ! function_exists( 'ereco_mascot_activate_theme_icon_packs' ) ) {
	function ereco_mascot_activate_theme_icon_packs() {
		global $ereco_mascot_icon_font_packs;
		$ereco_mascot_icon_font_packs = RegIconFonts::getInstance();
	}
	add_action('after_setup_theme', 'ereco_mascot_activate_theme_icon_packs');
}

if( !function_exists( 'ereco_mascot_icon_font_packs' ) ) {
	/**
	 * Returns instance of RegIconFonts class
	 */
	function ereco_mascot_icon_font_packs() {
		return RegIconFonts::getInstance();
	}
}