<?php
/**
 *  /!\ This is a copy of Walker_Nav_Menu_Edit class in core
 * 
 * Create HTML list of nav menu input items.
 *
 * @package WordPress
 * @since 3.0.0
 * @uses Walker_Nav_Menu
 */




// Add the mega menu custom fields to the menu fields.
add_action( 'ereco_mascot_wp_nav_megamenu_item_custom_fields', 'ereco_mascot_wp_add_megamenu_fields', 20, 4 );

/**
 * Adds the menu markup.
 *
 * @param string $item_id The ID of the menu item.
 * @param object $item    The menu item object.
 * @param int    $depth   The depth of the current item in the menu.
 * @param array  $args    Menu arguments.
 */
function ereco_mascot_wp_add_megamenu_fields( $item_id, $item, $depth, $args ) {
	?>
	<div class="clear"></div>
	<div class="mascot-mega-menu-options">
		<p class="field-megamenu-status description description-wide">
			<label for="edit-menu-item-mascot-megamenu-status-<?php echo esc_attr( $item_id ); ?>">
				<input type="checkbox" id="edit-menu-item-mascot-megamenu-status-<?php echo esc_attr( $item_id ); ?>" class="widefat code edit-menu-item-mascot-megamenu-status" name="menu-item-mascot-megamenu-status[<?php echo esc_attr( $item_id ); ?>]" value="enabled" <?php checked( $item->mascot_megamenu_status, 'enabled' ); ?> />
				<strong><?php esc_html_e( 'Enable Mega Menu (only for main menu)', 'ereco-wp' ); ?></strong>
			</label>
		</p>
		<p class="field-megamenu-containerwidth description description-wide">
			<label for="edit-menu-item-mascot-megamenu-containerwidth-<?php echo esc_attr( $item_id ); ?>">
				<?php esc_html_e( 'Mega Menu Container Width', 'ereco-wp' ); ?>
				<select id="edit-menu-item-mascot-megamenu-containerwidth-<?php echo esc_attr( $item_id ); ?>" class="widefat code edit-menu-item-mascot-megamenu-containerwidth" name="menu-item-mascot-megamenu-containerwidth[<?php echo esc_attr( $item_id ); ?>]">
					<option value="megamenu-fullwidth" <?php selected( $item->mascot_megamenu_containerwidth, 'megamenu-fullwidth' ); ?>><?php esc_html_e( 'Fullwidth', 'ereco-wp' ); ?></option>
					<option value="megamenu-three-quarter-width" <?php selected( $item->mascot_megamenu_containerwidth, 'megamenu-three-quarter-width' ); ?>><?php esc_html_e( 'Three Quarter Width', 'ereco-wp' ); ?></option>
					<option value="megamenu-half-width" <?php selected( $item->mascot_megamenu_containerwidth, 'megamenu-half-width' ); ?>><?php esc_html_e( 'Half Width', 'ereco-wp' ); ?></option>
					<option value="megamenu-quarter-width" <?php selected( $item->mascot_megamenu_containerwidth, 'megamenu-quarter-width' ); ?>><?php esc_html_e( 'Quarter Width', 'ereco-wp' ); ?></option>
				</select>
			</label>
		</p>
		<p class="field-megamenu-dropdownposition description description-wide">
			<label for="edit-menu-item-mascot-megamenu-dropdownposition-<?php echo esc_attr( $item_id ); ?>">
				<?php esc_html_e( 'Mega Menu Dropdown Position', 'ereco-wp' ); ?>
				<select id="edit-menu-item-mascot-megamenu-dropdownposition-<?php echo esc_attr( $item_id ); ?>" class="widefat code edit-menu-item-mascot-megamenu-dropdownposition" name="menu-item-mascot-megamenu-dropdownposition[<?php echo esc_attr( $item_id ); ?>]">
					<option value="megamenu-position-left" <?php selected( $item->mascot_megamenu_dropdownposition, 'megamenu-position-left' ); ?>><?php esc_html_e( 'Left', 'ereco-wp' ); ?></option>
					<option value="megamenu-position-center" <?php selected( $item->mascot_megamenu_dropdownposition, 'megamenu-position-center' ); ?>><?php esc_html_e( 'Center', 'ereco-wp' ); ?></option>
					<option value="megamenu-position-right" <?php selected( $item->mascot_megamenu_dropdownposition, 'megamenu-position-right' ); ?>><?php esc_html_e( 'Right', 'ereco-wp' ); ?></option>
				</select>
			</label>
		</p>
		<p class="field-megamenu-gridcolumnwidth description description-wide">
			<label for="edit-menu-item-mascot-megamenu-gridcolumnwidth-<?php echo esc_attr( $item_id ); ?>">
				<?php esc_html_e( 'Mega Menu Column Width in Grid system', 'ereco-wp' ); ?>
				<select id="edit-menu-item-mascot-megamenu-gridcolumnwidth-<?php echo esc_attr( $item_id ); ?>" class="widefat code edit-menu-item-mascot-megamenu-gridcolumnwidth" name="menu-item-mascot-megamenu-gridcolumnwidth[<?php echo esc_attr( $item_id ); ?>]">
					<option value="12" <?php selected( $item->mascot_megamenu_gridcolumnwidth, 'auto' ); ?>><?php esc_html_e( 'Auto', 'ereco-wp' ); ?></option>
					<option value="1" <?php selected( $item->mascot_megamenu_gridcolumnwidth, '1' ); ?>>1</option>
					<option value="2" <?php selected( $item->mascot_megamenu_gridcolumnwidth, '2' ); ?>>2</option>
					<option value="3" <?php selected( $item->mascot_megamenu_gridcolumnwidth, '3' ); ?>>3</option>
					<option value="4" <?php selected( $item->mascot_megamenu_gridcolumnwidth, '4' ); ?>>4</option>
					<option value="5" <?php selected( $item->mascot_megamenu_gridcolumnwidth, '5' ); ?>>5</option>
					<option value="6" <?php selected( $item->mascot_megamenu_gridcolumnwidth, '6' ); ?>>6</option>
					<option value="7" <?php selected( $item->mascot_megamenu_gridcolumnwidth, '7' ); ?>>7</option>
					<option value="8" <?php selected( $item->mascot_megamenu_gridcolumnwidth, '8' ); ?>>8</option>
					<option value="9" <?php selected( $item->mascot_megamenu_gridcolumnwidth, '9' ); ?>>9</option>
					<option value="10" <?php selected( $item->mascot_megamenu_gridcolumnwidth, '10' ); ?>>10</option>
					<option value="11" <?php selected( $item->mascot_megamenu_gridcolumnwidth, '11' ); ?>>11</option>
					<option value="12" <?php selected( $item->mascot_megamenu_gridcolumnwidth, '12' ); ?>>12</option>
				</select>
			</label>
		</p>
		<p class="field-megamenu-widgetarea description description-wide">
			<label for="edit-menu-item-mascot-megamenu-widgetarea-<?php echo esc_attr( $item_id ); ?>">
				<?php esc_html_e( 'Mega Menu Widget Area', 'ereco-wp' ); ?>
				<select id="edit-menu-item-mascot-megamenu-widgetarea-<?php echo esc_attr( $item_id ); ?>" class="widefat code edit-menu-item-mascot-megamenu-widgetarea" name="menu-item-mascot-megamenu-widgetarea[<?php echo esc_attr( $item_id ); ?>]">
					<option value="0"><?php esc_html_e( 'Select Widget Area', 'ereco-wp' ); ?></option>
					<?php global $wp_registered_sidebars; ?>
					<?php if ( ! empty( $wp_registered_sidebars ) && is_array( $wp_registered_sidebars ) ) : ?>
						<?php foreach ( $wp_registered_sidebars as $sidebar ) : ?>
							<option value="<?php echo esc_attr( $sidebar['id'] ); ?>" <?php selected( $item->mascot_megamenu_widgetarea, $sidebar['id'] ); ?>><?php echo esc_html( $sidebar['name'] ); ?></option>
						<?php endforeach; ?>
					<?php endif; ?>
				</select>
			</label>
		</p>

		<p class="field-megamenu-bgimage description description-wide">
			<a  id="mascot-media-upload-<?php echo esc_attr( $item_id ); ?>" class="mascot-open-media button button-primary mascot-megamenu-upload-bgimage" data-target="#edit-menu-item-mascot-megamenu-bgimage-<?php echo esc_attr( $item_id ); ?>" data-preview=".mascot-megamenu-bgimage-image" data-frame="select" data-state="wpc_widgets_insert_single" data-fetch="url" data-title="<?php esc_attr_e( 'Insert Image', 'ereco-wp' ); ?>" data-button="<?php esc_attr_e( 'Insert', 'ereco-wp' ); ?>" data-class="media-frame tm-widget-custom-uploader" title="<?php esc_attr_e( 'Add Media', 'ereco-wp' ); ?>"><?php esc_html_e( 'Set BG image', 'ereco-wp' ); ?></a>

			<label for="edit-menu-item-mascot-megamenu-bgimage-<?php echo esc_attr( $item_id ); ?>">
				<input type="hidden" id="edit-menu-item-mascot-megamenu-bgimage-<?php echo esc_attr( $item_id ); ?>" class="mascot-new-media-image widefat code edit-menu-item-mascot-megamenu-bgimage" name="menu-item-mascot-megamenu-bgimage[<?php echo esc_attr( $item_id ); ?>]" value="<?php echo esc_url( $item->mascot_megamenu_bgimage ); ?>" />
				<img src="<?php echo esc_url( $item->mascot_megamenu_bgimage ); ?>" id="mascot-media-img-<?php echo esc_attr( $item_id ); ?>" class="mascot-megamenu-bgimage-image" style="<?php echo ( trim( esc_url( $item->mascot_megamenu_bgimage ) ) ) ? 'display:inline;' : ''; ?>" />

				<a href="#" id="mascot-media-remove-<?php echo esc_attr( $item_id ); ?>" data-target="#edit-menu-item-mascot-megamenu-bgimage-<?php echo esc_attr( $item_id ); ?>" data-preview=".mascot-megamenu-bgimage-image" class="remove-mascot-megamenu-bgimage" style="<?php echo ( trim( esc_url( $item->mascot_megamenu_bgimage ) ) ) ? 'display:inline;' : ''; ?>"><?php esc_html_e( 'Remove Image', 'ereco-wp' ); ?></a>


			</label>
		</p>
	</div><!-- .mascot-mega-menu-options-->
	<?php
}



if( !class_exists( 'Ereco_Mascot_Walker_Nav_Menu_Edit_Custom' ) ) {
class Ereco_Mascot_Walker_Nav_Menu_Edit_Custom extends Walker_Nav_Menu  {
	/**
	 * Starts the list before the elements are added.
	 *
	 * @since 3.0.0
	 *
	 * @see Walker::start_lvl()
	 *
	 * @param string $output Passed by reference. Used to append additional content.
	 * @param int    $depth  Depth of menu item. Used for padding.
	 * @param array  $args   An array of wp_nav_menu() arguments.
	 */
	function start_lvl( &$output, $depth = 0, $args = array() ) {
	}

	/**
	 * Ends the list of after the elements are added.
	 *
	 * @since 3.0.0
	 *
	 * @see Walker::end_lvl()
	 *
	 * @param string $output Passed by reference. Used to append additional content.
	 * @param int    $depth  Depth of menu item. Used for padding.
	 * @param array  $args   An array of wp_nav_menu() arguments.
	 */
	function end_lvl( &$output, $depth = 0, $args = array() ) {
	}
	
	/**
	 * Starts the element output.
	 *
	 * @since 3.0.0
	 * @since 4.4.0 The {@see 'nav_menu_item_args'} filter was added.
	 *
	 * @see Walker::start_el()
	 *
	 * @param string $output Passed by reference. Used to append additional content.
	 * @param object $item   Menu item data object.
	 * @param int    $depth  Depth of menu item. Used for padding.
	 * @param array  $args   An array of wp_nav_menu() arguments.
	 * @param int    $id     Current item ID.
	 */
	function start_el( &$output, $item, $depth = 0, $args = array(), $id = 0 ) {
		global $_wp_nav_menu_max_depth, $wp_registered_sidebars;
		$_wp_nav_menu_max_depth = $depth > $_wp_nav_menu_max_depth ? $depth : $_wp_nav_menu_max_depth;

		ob_start();
		$item_id = esc_attr( $item->ID );
		$removed_args = array(
			'action',
			'customlink-tab',
			'edit-menu-item',
			'menu-item',
			'page-tab',
			'_wpnonce',
		);

		$original_title = '';
		if ( 'taxonomy' == $item->type ) {
			$original_title = get_term_field( 'name', $item->object_id, $item->object, 'raw' );
			if ( is_wp_error( $original_title ) ) {
				$original_title = false;
			}
		} elseif ( 'post_type' == $item->type ) {
			$original_object = get_post( $item->object_id );
			$original_title  = get_the_title( $original_object->ID );
		}

		$classes = array(
			'menu-item menu-item-depth-' . $depth,
			'menu-item-' . esc_attr( $item->object ),
			'menu-item-edit-' . ( ( isset( $_GET['edit-menu-item'] ) && $item_id == $_GET['edit-menu-item'] ) ? 'active' : 'inactive' ),
		);

		$title = $item->title;

		if ( ! empty( $item->_invalid ) ) {
			$classes[] = 'menu-item-invalid';
			/* translators: %s: title of menu item which is invalid */
			$title = sprintf( esc_html__( '%s (Invalid)', 'ereco-wp' ), $item->title );
		} elseif ( isset( $item->post_status ) && 'draft' == $item->post_status ) {
			$classes[] = 'pending';
			/* translators: %s: title of menu item in draft status */
			$title = sprintf( esc_html__( '%s (Pending)', 'ereco-wp' ), $item->title );
		}

		$title = ( ! isset( $item->label ) || '' == $item->label ) ? $title : $item->label;

		$submenu_text = '';
		if ( 0 == $depth ) {
			$submenu_text = 'display: none;';
		}

		?>
		<li id="menu-item-<?php echo esc_attr( $item_id ); ?>" class="<?php echo implode( ' ', $classes ); ?>">
			<dl class="menu-item-bar">
				<dt class="menu-item-handle">
					<span class="item-title"><span class="menu-item-title"><?php echo esc_html( $title ); ?></span> <span class="is-submenu" style="<?php echo esc_attr( $submenu_text ); ?>"><?php esc_html_e( 'sub item' , 'ereco-wp' ); ?></span></span>
					<span class="item-controls">
						<span class="item-type"><?php echo esc_html( $item->type_label ); ?></span>
						<span class="item-order hide-if-js">
							<?php
							$url1 = wp_nonce_url(
								add_query_arg(
									array( 'action' => 'move-up-menu-item', 'menu-item' => $item_id ),
									remove_query_arg( $removed_args, admin_url( 'nav-menus.php' ) )
								),
								'move-menu_item'
							);
							$url2 = wp_nonce_url(
								add_query_arg(
									array( 'action' => 'move-down-menu-item', 'menu-item' => $item_id ),
									remove_query_arg( $removed_args, admin_url( 'nav-menus.php' ) )
								),
								'move-menu_item'
							);
							if ( isset( $_GET['edit-menu-item'] ) && $item_id == $_GET['edit-menu-item'] ) {
								$url3 = admin_url( 'nav-menus.php' );
							} else {
								$url3 = add_query_arg(
									'edit-menu-item', $item_id, remove_query_arg(
										$removed_args,
										admin_url( 'nav-menus.php#menu-item-settings-' . $item_id )
									)
								);
							}
							?>
							<a href="<?php echo esc_url( $url1 ); ?>" class="item-move-up"><abbr title="<?php esc_attr_e( 'Move up', 'ereco-wp' ); ?>">&#8593;</abbr></a>
							|
							<a href="<?php echo esc_url( $url2 ); ?>" class="item-move-down"><abbr title="<?php esc_attr_e( 'Move down', 'ereco-wp' ); ?>">&#8595;</abbr></a>
						</span>
						<a class="item-edit" id="edit-<?php echo esc_attr( $item_id ); ?>" title="<?php esc_attr_e( 'Edit Menu Item', 'ereco-wp' ); ?>" href="<?php echo esc_url( $url3 ); ?>"><span class="screen-reader-text"><?php esc_html_e( 'Edit', 'ereco-wp' ); ?></span></a>
					</span>
				</dt>
			</dl>
			<!-- .menu-item-bar-->
	

			<div class="menu-item-settings wp-clearfix" id="menu-item-settings-<?php echo esc_attr( $item_id ); ?>">
				<?php if( 'custom' == $item->type ) : ?>
					<p class="field-url description description-wide">
						<label for="edit-menu-item-url-<?php echo esc_attr( $item_id ); ?>">
							<?php esc_html_e( 'URL', 'ereco-wp' ); ?><br />
							<input type="text" id="edit-menu-item-url-<?php echo esc_attr( $item_id ); ?>" class="widefat code edit-menu-item-url" name="menu-item-url[<?php echo esc_attr( $item_id ); ?>]" value="<?php echo esc_attr( $item->url ); ?>" />
						</label>
					</p>
				<?php endif; ?>
				<p class="description description-thin">
					<label for="edit-menu-item-title-<?php echo esc_attr( $item_id ); ?>">
						<?php esc_html_e( 'Navigation Label', 'ereco-wp' ); ?><br />
						<input type="text" id="edit-menu-item-title-<?php echo esc_attr( $item_id ); ?>" class="widefat edit-menu-item-title" name="menu-item-title[<?php echo esc_attr( $item_id ); ?>]" value="<?php echo esc_attr( $item->title ); ?>" />
					</label>
				</p>
				<p class="description description-thin">
					<label for="edit-menu-item-attr-title-<?php echo esc_attr( $item_id ); ?>">
						<?php esc_html_e( 'Title Attribute', 'ereco-wp' ); ?><br />
						<input type="text" id="edit-menu-item-attr-title-<?php echo esc_attr( $item_id ); ?>" class="widefat edit-menu-item-attr-title" name="menu-item-attr-title[<?php echo esc_attr( $item_id ); ?>]" value="<?php echo esc_attr( $item->post_excerpt ); ?>" />
					</label>
				</p>
				<p class="field-link-target description">
					<label for="edit-menu-item-target-<?php echo esc_attr( $item_id ); ?>">
						<input type="checkbox" id="edit-menu-item-target-<?php echo esc_attr( $item_id ); ?>" value="_blank" name="menu-item-target[<?php echo esc_attr( $item_id ); ?>]"<?php checked( $item->target, '_blank' ); ?> />
						<?php esc_html_e( 'Open link in a new window/tab', 'ereco-wp' ); ?>
					</label>
				</p>
				<p class="field-css-classes description description-thin">
					<label for="edit-menu-item-classes-<?php echo esc_attr( $item_id ); ?>">
						<?php esc_html_e( 'CSS Classes (optional)', 'ereco-wp' ); ?><br />
						<input type="text" id="edit-menu-item-classes-<?php echo esc_attr( $item_id ); ?>" class="widefat code edit-menu-item-classes" name="menu-item-classes[<?php echo esc_attr( $item_id ); ?>]" value="<?php echo esc_attr( implode(' ', $item->classes ) ); ?>" />
					</label>
				</p>
				<p class="field-xfn description description-thin">
					<label for="edit-menu-item-xfn-<?php echo esc_attr( $item_id ); ?>">
						<?php esc_html_e( 'Link Relationship (XFN)', 'ereco-wp' ); ?><br />
						<input type="text" id="edit-menu-item-xfn-<?php echo esc_attr( $item_id ); ?>" class="widefat code edit-menu-item-xfn" name="menu-item-xfn[<?php echo esc_attr( $item_id ); ?>]" value="<?php echo esc_attr( $item->xfn ); ?>" />
					</label>
				</p>
				<p class="field-description description description-wide">
					<label for="edit-menu-item-description-<?php echo esc_attr( $item_id ); ?>">
						<?php esc_html_e( 'Description', 'ereco-wp' ); ?><br />
						<textarea id="edit-menu-item-description-<?php echo esc_attr( $item_id ); ?>" class="widefat edit-menu-item-description" rows="3" cols="20" name="menu-item-description[<?php echo esc_attr( $item_id ); ?>]"><?php echo esc_html( $item->description ); // textarea_escaped ?></textarea>
						<span class="description"><?php esc_html_e('The description will be displayed in the menu if the current theme supports it.', 'ereco-wp'); ?></span>
					</label>
				</p>
				<?php
					/* New fields insertion starts here */
				?>
				<p class="field-megamenu-title description description-wide">
					<label for="edit-menu-item-mascot-submenu-title-<?php echo esc_attr( $item_id ); ?>">
						<input type="checkbox" id="edit-menu-item-mascot-submenu-title-<?php echo esc_attr( $item_id ); ?>" class="widefat code edit-menu-item-mascot-submenu-title" name="menu-item-mascot-submenu-title[<?php echo esc_attr( $item_id ); ?>]" value="enabled" <?php checked( $item->mascot_submenu_title, 'enabled' ); ?> />
						<strong><?php esc_html_e( 'Show this Navigation Label as a Bold Title', 'ereco-wp' ); ?></strong>
					</label>
				</p>
				<p class="field-dropdownposition description description-wide">
					<label for="edit-menu-item-mascot-dropdownposition-<?php echo esc_attr( $item_id ); ?>">
						<input type="checkbox" id="edit-menu-item-mascot-dropdownposition-<?php echo esc_attr( $item_id ); ?>" class="widefat code edit-menu-item-mascot-dropdownposition" name="menu-item-mascot-dropdownposition[<?php echo esc_attr( $item_id ); ?>]" value="left" <?php checked( $item->mascot_dropdownposition, 'left' ); ?> />
						<?php esc_html_e( 'Show it\'s dropdown items to left (default right)', 'ereco-wp' ); ?>
					</label>
				</p>
				<p class="field-custom description description-wide">
					<label for="edit-menu-item-mascot-subtitle-<?php echo esc_attr( $item_id ); ?>">
					<?php esc_html_e( 'Subtitle', 'ereco-wp' ); ?>
					<br />
					<input type="text" id="edit-menu-item-mascot-subtitle-<?php echo esc_attr( $item_id ); ?>" class="widefat code edit-menu-item-custom" name="menu-item-mascot-subtitle[<?php echo esc_attr( $item_id ); ?>]" value="<?php echo esc_attr( $item->mascot_subtitle ); ?>" />
					</label>
				</p>
				<p class="field-custom description description-wide">
					<label for="edit-menu-item-mascot-menuicon-<?php echo esc_attr( $item_id ); ?>">
					<?php esc_html_e( 'Menu Icon (use full Font Awesome Icon name. Example: fa fa-home)', 'ereco-wp' ); ?>
					<br />
					<input type="text" id="edit-menu-item-mascot-menuicon-<?php echo esc_attr( $item_id ); ?>" class="widefat code edit-menu-item-custom" name="menu-item-mascot-menuicon[<?php echo esc_attr( $item_id ); ?>]" value="<?php echo esc_attr( $item->mascot_menuicon ); ?>" />
					<?php echo sprintf( esc_html__( 'Collect your own icon from here: %1$sFontAwesome%2$s.', 'ereco-wp' ), '<a target="_blank" href="' . esc_url( 'https://fontawesome.com/v4.7.0/icons/' ) . '">', '</a>' ); ?>
					</label>
				</p>
				<p class="field-custom description description-wide">
					<label for="edit-menu-item-mascot-custombadge-<?php echo esc_attr( $item_id ); ?>">
					<?php esc_html_e( 'Custom Badge/Tag', 'ereco-wp' ); ?>
					<br />
					<input type="text" id="edit-menu-item-mascot-custombadge-<?php echo esc_attr( $item_id ); ?>" class="widefat code edit-menu-item-custom" name="menu-item-mascot-custombadge[<?php echo esc_attr( $item_id ); ?>]" value="<?php echo esc_attr( $item->mascot_custombadge ); ?>" />
					</label>
				</p>
				<?php 
					if( ereco_mascot_get_redux_option( 'header-menu-megamenu-enable-megamenu' ) ) {
						do_action( 'ereco_mascot_wp_nav_megamenu_item_custom_fields', $item_id, $item, $depth, $args );
					}
				?>
				<?php
					/* New fields insertion ends here */
				?>
				<fieldset class="field-move hide-if-no-js description description-wide">
					<span class="field-move-visual-label" aria-hidden="true"><?php esc_html_e( 'Move', 'ereco-wp' ); ?></span>
					<button type="button" class="button-link menus-move menus-move-up" data-dir="up" aria-label="<?php esc_attr_e( 'Move up one', 'ereco-wp' ); ?>"><?php esc_html_e( 'Up one', 'ereco-wp' ); ?></button>
					<button type="button" class="button-link menus-move menus-move-down" data-dir="down" aria-label="<?php esc_attr_e( 'Move down one', 'ereco-wp' ); ?>"><?php esc_html_e( 'Down one', 'ereco-wp' ); ?></button>
					<button type="button" class="button-link menus-move menus-move-left" data-dir="left" aria-label="<?php esc_attr_e( 'Move out from under Home', 'ereco-wp' ); ?>"><?php esc_html_e( 'Out from under Home', 'ereco-wp' ); ?></button>
					<button type="button" class="button-link menus-move menus-move-right" data-dir="right"></button>
					<button type="button" class="button-link menus-move menus-move-top" data-dir="top"><?php esc_attr_e( 'To the top', 'ereco-wp' ); ?></button>
				</fieldset>
				<div class="menu-item-actions description-wide submitbox">
					<?php if( 'custom' != $item->type && $original_title !== false ) : ?>
					<p class="link-to-original"> <?php printf( esc_html__('Original: %s', 'ereco-wp'), '<a href="' . esc_attr( $item->url ) . '">' . esc_html( $original_title ) . '</a>' ); ?> </p>
					<?php endif; ?>
					<a class="item-delete submitdelete deletion" id="delete-<?php echo esc_attr( $item_id ); ?>" href="<?php
						echo wp_nonce_url(
							add_query_arg(
								array(
									'action' => 'delete-menu-item',
									'menu-item' => $item_id,
								),
								remove_query_arg($removed_args, admin_url( 'nav-menus.php' ) )
							),
							'delete-menu_item_' . $item_id
						); ?>">
					<?php esc_html_e('Remove', 'ereco-wp'); ?>
					</a> <span class="meta-sep"> | </span> <a class="item-cancel submitcancel" id="cancel-<?php echo esc_attr( $item_id ); ?>" href="<?php echo esc_url( add_query_arg( array('edit-menu-item' => $item_id, 'cancel' => time()), remove_query_arg( $removed_args, admin_url( 'nav-menus.php' ) ) ) );
						?>#menu-item-settings-<?php echo esc_attr( $item_id ); ?>">
					<?php esc_html_e('Cancel', 'ereco-wp'); ?>
					</a> 
				</div>
				<input class="menu-item-data-db-id" name="menu-item-db-id[<?php echo esc_attr( $item_id ); ?>]" value="<?php echo esc_attr( $item_id ); ?>" type="hidden">
				<input class="menu-item-data-object-id" name="menu-item-object-id[<?php echo esc_attr( $item_id ); ?>]" value="<?php echo esc_attr( $item->object_id ); ?>" type="hidden">
				<input class="menu-item-data-object" name="menu-item-object[<?php echo esc_attr( $item_id ); ?>]" value="<?php echo esc_attr( $item->object ); ?>" type="hidden">
				<input class="menu-item-data-parent-id" name="menu-item-parent-id[<?php echo esc_attr( $item_id ); ?>]" value="<?php echo esc_attr( $item->menu_item_parent ); ?>" type="hidden">
				<input class="menu-item-data-position" name="menu-item-position[<?php echo esc_attr( $item_id ); ?>]" value="<?php echo esc_attr( $item->menu_order ); ?>" type="hidden">
				<input class="menu-item-data-type" name="menu-item-type[<?php echo esc_attr( $item_id ); ?>]" value="<?php echo esc_attr( $item->type ); ?>" type="hidden">
			</div>
			<!-- .menu-item-settings-->

				<ul class="menu-item-transport"></ul>
				
		<?php
		$output .= ob_get_clean();
	}
}
}


