<?php


/**
 * Predefine demo imports
 */
function ereco_mascot_ocdi_import_files() {
	$preview_base_url = 'https://wp.kodesolution.live/2021/business/ereco/';
	$base_url = 'https://wp.kodesolution.live/2021/business/ereco/tgm/v1.0/';
	$item_variations = array (
		'main-demo' => 'Main Demo',
		'rtl' => 'RTL',
	);
	$preview_variations = array (
		'main-demo' => '',
		'rtl' => 'rtl',
	);


	//Don't edit below code:
	$final_output = array();
	foreach ($item_variations as $key => $eachitem) {
		$title = strtoupper( str_replace("-"," ",$eachitem) );
		if( $key != '' ) {
			$key_new =  $key . '/';
		}

		$current_url = $base_url . $key_new;
		$preview_url = $preview_base_url . $preview_variations[$key];
		if( $key == 'rtl' ) {
			$preview_url = $preview_url . '?d=rtl';
		}
		$final_output[] = array(
				'import_file_name'           => $title,
				'categories'                 => array( $title ),
				'import_file_url'            => $current_url . 'xml.xml',
				'import_widget_file_url'     => $current_url . 'wie.wie',
				//'import_customizer_file_url' => 'http://www.your_domain.com/ocdi/customizer.dat',
				'import_redux'               => array(
						array(
								'file_url'    => $current_url . 'json.json',
								'option_name' => 'ereco_mascot_redux_theme_opt',
						),
				),
				'import_preview_image_url'   => $current_url . 'screenshot.jpg',
				'import_notice'              => esc_html__( 'After you import this demo, you will have to import the slider separately. You will find slider in "import-sliders" folder in your downloaded package.', 'ereco-wp' ),
				'preview_url'                => $preview_url,
		);
	}

	return $final_output;
}
add_filter( 'pt-ocdi/import_files', 'ereco_mascot_ocdi_import_files' );



/**
 * Automatically assign “Front page”, “Posts page” and menu locations after the importer is done
 */
function ereco_mascot_ocdi_after_import_setup( $selected_import ) {
	// Assign menus to their locations.
	$main_menu = get_term_by( 'name', 'Top Primary Nav', 'nav_menu' );
	$header_useful_menu = get_term_by( 'name', 'Header Useful Links', 'nav_menu' );

	set_theme_mod( 'nav_menu_locations', array(
			'primary' => $main_menu->term_id,
			'column2-header-top-nav' => $header_useful_menu->term_id,
		)
	);

	if ( 'Main Demo' === $selected_import['import_file_name'] ) {
	}




	// Assign front page and posts page (blog page).
	$front_page_id = get_page_by_title( 'Index Multipage Layout1' );
	$blog_page_id  = get_page_by_title( 'Blog With Right Sidebar' );

	update_option( 'show_on_front', 'page' );
	update_option( 'page_on_front', $front_page_id->ID );
	update_option( 'page_for_posts', $blog_page_id->ID );

	//update theme options:
	ereco_mascot_generate_css_for_custom_theme_color_from_less();
	ereco_mascot_generate_dynamic_css();

}
add_action( 'pt-ocdi/after_import', 'ereco_mascot_ocdi_after_import_setup' );



/**
 * Change the location, title and other parameters of the plugin page
 */
function ereco_mascot_ocdi_plugin_page_setup( $default_settings ) {
	$default_settings['parent_slug'] = 'themes.php';
	$default_settings['page_title']  = esc_html__( 'One Click Demo Import - ThemeMascot' , 'ereco-wp' );
	$default_settings['menu_title']  = esc_html__( 'Import Demo Data' , 'ereco-wp' );
	$default_settings['capability']  = 'import';
	$default_settings['menu_slug']   = 'tm-one-click-demo-import';

	return $default_settings;
}
add_filter( 'pt-ocdi/plugin_page_setup', 'ereco_mascot_ocdi_plugin_page_setup' );


add_filter( 'pt-ocdi/disable_pt_branding', '__return_true' );